/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy.spi_impl;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.policy.assertion.AckRequestIntervalClientAssertion;
import com.sun.xml.ws.rm.policy.assertion.AllowDuplicatesAssertion;
import com.sun.xml.ws.rm.policy.assertion.CloseTimeoutClientAssertion;
import com.sun.xml.ws.rm.policy.assertion.InactivityTimeoutAssertion;
import com.sun.xml.ws.rm.policy.assertion.OrderedDeliveryAssertion;
import com.sun.xml.ws.rm.policy.assertion.ResendIntervalClientAssertion;
import com.sun.xml.ws.rm.policy.assertion.Rm10Assertion;
import com.sun.xml.ws.rm.policy.assertion.Rm11Assertion;
import com.sun.xml.ws.rm.policy.assertion.RmFlowControlAssertion;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class RmAssertionValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> serverSideSupportedAssertions = new ArrayList(5);
    private static final ArrayList<QName> clientSideSupportedAssertions = new ArrayList(8);

    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion assertion) {
        return clientSideSupportedAssertions.contains(assertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion assertion) {
        QName assertionName = assertion.getName();
        if (serverSideSupportedAssertions.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        if (clientSideSupportedAssertions.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public String[] declareSupportedDomains() {
        return new String[]{RmVersion.WSRM10.policyNamespaceUri, RmVersion.WSRM11.policyNamespaceUri, "http://schemas.microsoft.com/net/2005/02/rm/policy", "http://sun.com/2006/03/rm", "http://sun.com/2006/03/rm/client"};
    }

    static {
        serverSideSupportedAssertions.add(Rm10Assertion.NAME);
        serverSideSupportedAssertions.add(Rm11Assertion.NAME);
        serverSideSupportedAssertions.add(OrderedDeliveryAssertion.NAME);
        serverSideSupportedAssertions.add(AllowDuplicatesAssertion.NAME);
        serverSideSupportedAssertions.add(RmFlowControlAssertion.NAME);
        serverSideSupportedAssertions.add(InactivityTimeoutAssertion.NAME);
        clientSideSupportedAssertions.add(AckRequestIntervalClientAssertion.NAME);
        clientSideSupportedAssertions.add(ResendIntervalClientAssertion.NAME);
        clientSideSupportedAssertions.add(CloseTimeoutClientAssertion.NAME);
        clientSideSupportedAssertions.addAll(serverSideSupportedAssertions);
    }
}

