/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xwss;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.xwss.SecurityConfiguration;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;

public class XWSSClientPipe
implements Pipe {
    protected Pipe nextPipe = null;
    protected WSDLPort port = null;
    protected WSService service = null;
    protected WSBinding binding = null;
    protected SOAPFactory soapFactory = null;
    protected MessageFactory messageFactory = null;
    protected SOAPVersion soapVersion = null;
    protected boolean isSOAP12 = false;
    private static final String MESSAGE_SECURITY_CONFIGURATION = "com.sun.xml.ws.security.configuration";
    private static final String CONTEXT_WSDL_OPERATION = "com.sun.xml.ws.wsdl.operation";
    protected boolean wasConfigChecked = false;

    public XWSSClientPipe(WSDLPort prt, WSService svc, WSBinding bnd, Pipe nextP) {
        this.nextPipe = nextP;
        this.port = prt;
        this.service = svc;
        this.binding = bnd;
        this.soapVersion = bnd.getSOAPVersion();
        this.isSOAP12 = this.soapVersion == SOAPVersion.SOAP_12;
        this.soapFactory = this.soapVersion.saajSoapFactory;
        this.messageFactory = this.soapVersion.saajMessageFactory;
    }

    public XWSSClientPipe(XWSSClientPipe that) {
        this.nextPipe = that.nextPipe;
        this.binding = that.binding;
        this.port = that.port;
        this.service = that.service;
        this.soapFactory = that.soapFactory;
        this.messageFactory = that.messageFactory;
        this.soapVersion = that.soapVersion;
        this.isSOAP12 = that.isSOAP12;
    }

    public Packet process(Packet packet) {
        SecurityConfiguration sConfig = (SecurityConfiguration)packet.invocationProperties.get(MESSAGE_SECURITY_CONFIGURATION);
        if (sConfig == null) {
            URL url = null;
            if (!this.wasConfigChecked) {
                this.wasConfigChecked = true;
                String configUrl = "META-INF/client_security_config.xml";
                url = SecurityUtil.loadFromClasspath(configUrl);
            }
            if (url != null) {
                try {
                    sConfig = new SecurityConfiguration(url);
                    packet.invocationProperties.put(MESSAGE_SECURITY_CONFIGURATION, sConfig);
                }
                catch (XWSSecurityException e) {
                    throw new XWSSecurityRuntimeException(e);
                }
            } else {
                return this.nextPipe.process(packet);
            }
        }
        Packet ret = this.secureRequest(packet);
        if ((ret = this.nextPipe.process(ret)) == null || ret.getMessage() == null) {
            return ret;
        }
        return this.validateResponse(ret);
    }

    public void preDestroy() {
    }

    public Pipe copy(PipeCloner pipeCloner) {
        Pipe clonedNextPipe = null;
        if (this.nextPipe != null) {
            clonedNextPipe = pipeCloner.copy(this.nextPipe);
        }
        XWSSClientPipe copied = new XWSSClientPipe(this);
        copied.setNextPipe(clonedNextPipe);
        pipeCloner.add(this, copied);
        return copied;
    }

    public void setNextPipe(Pipe pipe) {
        this.nextPipe = pipe;
    }

    public Packet validateResponse(Packet packet) {
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)packet.invocationProperties.get(MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return packet;
            }
            SOAPMessage message = null;
            try {
                message = packet.getMessage().readAsSOAPMessage();
            }
            catch (SOAPException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            String operation = (String)packet.invocationProperties.get(CONTEXT_WSDL_OPERATION);
            StaticApplicationContext sContext = this.getPolicyContext(packet, sConfig);
            sContext.setOperationIdentifier(operation);
            ApplicationSecurityConfiguration config = sConfig.getSecurityConfiguration();
            SecurityPolicy policy = config.getSecurityConfiguration(sContext);
            ProcessingContextImpl context = new ProcessingContextImpl(packet.invocationProperties);
            context.setPolicyContext(sContext);
            context.setSOAPMessage(message);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).receiverSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(true);
            if (config.retainSecurityHeader()) {
                context.retainSecurityHeader(true);
            }
            SecurityRecipient.validateMessage(context);
            packet.setMessage(Messages.create(context.getSOAPMessage()));
            return packet;
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException, this.isSOAP12);
        }
        catch (XWSSecurityException xwse) {
            QName qname = null;
            qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe, this.isSOAP12);
        }
    }

    public Packet secureRequest(Packet packet) {
        ProcessingContextImpl context = null;
        SOAPMessage message = null;
        try {
            message = packet.getMessage().readAsSOAPMessage();
        }
        catch (SOAPException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)packet.invocationProperties.get(MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return packet;
            }
            WSDLBoundOperation op = null;
            if (this.port != null) {
                op = packet.getMessage().getOperation(this.port);
            }
            QName operationQName = null;
            if (op != null) {
                operationQName = op.getName();
            }
            String operation = null;
            try {
                operation = operationQName == null ? this.getOperationName(message) : operationQName.toString();
            }
            catch (XWSSecurityException e) {
                throw new WebServiceException((Throwable)e);
            }
            packet.invocationProperties.put(CONTEXT_WSDL_OPERATION, operation);
            StaticApplicationContext sContext = this.getPolicyContext(packet, sConfig);
            sContext.setOperationIdentifier(operation);
            ApplicationSecurityConfiguration config = sConfig.getSecurityConfiguration();
            SecurityPolicy policy = config.getSecurityConfiguration(sContext);
            context = new ProcessingContextImpl(packet.invocationProperties);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).senderSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(false);
            context.setSOAPMessage(message);
            SecurityAnnotator.secureMessage(context);
            packet.setMessage(Messages.create(context.getSOAPMessage()));
            return packet;
        }
        catch (WssSoapFaultException soapFaultException) {
            throw new WebServiceException((Throwable)soapFaultException);
        }
        catch (XWSSecurityException xwse) {
            throw new WebServiceException((Throwable)xwse);
        }
    }

    private String getOperationName(SOAPMessage message) throws XWSSecurityException {
        Node node = null;
        Object key = null;
        SOAPBody body = null;
        if (message != null) {
            try {
                body = message.getSOAPBody();
            }
            catch (SOAPException ex) {
                throw new XWSSecurityException(ex);
            }
        } else {
            throw new XWSSecurityException("SOAPMessage in message context is null");
        }
        if (body == null) {
            throw new XWSSecurityException("No body element identifying an operation is found");
        }
        StringBuffer tmp = new StringBuffer("");
        String operation = "";
        for (node = body.getFirstChild(); node != null; node = node.getNextSibling()) {
            tmp.append("{" + node.getNamespaceURI() + "}" + node.getLocalName() + ":");
        }
        operation = tmp.toString();
        if (operation.length() > 0) {
            return operation.substring(0, operation.length() - 1);
        }
        return operation;
    }

    public SOAPFaultException getSOAPFaultException(WssSoapFaultException sfe, boolean isSOAP12) {
        SOAPFault fault = null;
        try {
            if (isSOAP12) {
                fault = this.soapFactory.createFault(sfe.getFaultString(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = this.soapFactory.createFault(sfe.getFaultString(), sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this + ": Internal Error while trying to create a SOAPFault");
        }
        return new SOAPFaultException(fault);
    }

    private StaticApplicationContext getPolicyContext(Packet packet, SecurityConfiguration config) {
        ApplicationSecurityConfiguration appconfig = config.getSecurityConfiguration();
        StaticApplicationContext iContext = (StaticApplicationContext)appconfig.getAllContexts().next();
        StaticApplicationContext sContext = new StaticApplicationContext(iContext);
        QName portQname = null;
        if (this.port != null) {
            portQname = this.port.getName();
        }
        String prt = null;
        prt = portQname == null ? "" : portQname.toString();
        sContext.setPortIdentifier(prt);
        return sContext;
    }
}

