/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser;

import java.io.ByteArrayOutputStream;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLDocumentParser
implements ContentHandler {
    private final TransformerHandler transformerHandler;
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
    boolean isDone = false;
    private Locator locator;
    private static final TransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();

    public String getDocumentation() {
        return this.bos.toString();
    }

    public WSDLDocumentParser() throws SAXParseException {
        try {
            this.transformerHandler = ((SAXTransformerFactory)transformerFactory).newTransformerHandler();
            Properties prop = new Properties();
            prop.put("omit-xml-declaration", "yes");
            this.transformerHandler.getTransformer().setOutputProperties(prop);
            this.transformerHandler.setResult(new StreamResult(this.bos));
        }
        catch (TransformerConfigurationException e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.transformerHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.transformerHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.transformerHandler.endDocument();
        this.isDone = true;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.transformerHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.transformerHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("documentation")) {
            return;
        }
        this.transformerHandler.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("documentation")) {
            return;
        }
        this.transformerHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.transformerHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.transformerHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
        this.transformerHandler.skippedEntity(name);
    }
}

