/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionFilterRegistry;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActionContributionHandler
extends ContributionFragmentRegistry<Action> {
    private final Log log = LogFactory.getLog(ActionContributionHandler.class);
    protected ActionRegistry actionReg = new ActionRegistry();
    protected ActionFilterRegistry filterReg;

    public ActionContributionHandler(ActionFilterRegistry fitlerReg) {
        this.filterReg = fitlerReg;
    }

    public ActionRegistry getRegistry() {
        return this.actionReg;
    }

    public Action clone(Action object) {
        try {
            return object.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void contributionRemoved(String id, Action origContrib) {
        this.actionReg.removeAction(id);
    }

    public void contributionUpdated(String actionId, Action action, Action origAction) {
        List<String> actionFilterIds;
        ActionFilter[] filters = origAction.getFilters();
        Action existingAction = this.actionReg.getAction(actionId);
        if (existingAction != null) {
            this.log.debug((Object)("Upgrading web action with id " + actionId));
            this.actionReg.removeAction(actionId);
        }
        ArrayList<String> filterIds = new ArrayList<String>();
        if (filters != null) {
            for (ActionFilter filter : filters) {
                this.filterReg.removeFilter(filter.getId());
                this.filterReg.addFilter(filter);
                filterIds.add(filter.getId());
            }
        }
        if ((actionFilterIds = action.getFilterIds()) == null) {
            action.setFilterIds(filterIds);
        } else {
            actionFilterIds.addAll(filterIds);
            action.setFilterIds(actionFilterIds);
        }
        if (action.getLabel() == null) {
            action.setLabel(actionId);
        }
        this.actionReg.addAction(action);
    }

    public String getContributionId(Action contrib) {
        return contrib.getId();
    }

    public void merge(Action src, Action dst) {
        dst.mergeWith(src);
    }
}

