/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.CmisAtomPubConstants;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAcl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAllowableActions;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomBase;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.RepositoryWorkspace;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.ServiceDoc;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisProperty;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyId;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDocumentDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeFolderDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypePolicyDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeRelationshipDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomPubParser {
    public static final String LINK_REL_CONTENT = "@@content@@";
    private final InputStream fStream;
    private AtomBase fParseResult;

    public AtomPubParser(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("No stream.");
        }
        this.fStream = stream;
    }

    public void parse() throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(this.fStream);
        do {
            int event;
            if ((event = parser.getEventType()) != 1) continue;
            QName name = parser.getName();
            if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                if ("feed".equals(name.getLocalPart())) {
                    this.fParseResult = this.parseFeed(parser);
                } else {
                    if (!"entry".equals(name.getLocalPart())) continue;
                    this.fParseResult = this.parseEntry(parser);
                }
            } else if ("http://docs.oasis-open.org/ns/cmis/core/200908/".equals(name.getNamespaceURI())) {
                if ("allowableActions".equals(name.getLocalPart())) {
                    this.fParseResult = AtomPubParser.parseAllowableActions(parser);
                } else {
                    if (!"acl".equals(name.getLocalPart())) continue;
                    this.fParseResult = AtomPubParser.parseACL(parser);
                }
            } else {
                if (!"http://www.w3.org/2007/app".equals(name.getNamespaceURI()) || !"service".equals(name.getLocalPart())) continue;
                this.fParseResult = AtomPubParser.parseServiceDoc(parser);
            }
            break;
        } while (AtomPubParser.next(parser));
        parser.close();
    }

    public AtomBase getResults() {
        return this.fParseResult;
    }

    private static ServiceDoc parseServiceDoc(XMLStreamReader parser) throws Exception {
        ServiceDoc result = new ServiceDoc();
        AtomPubParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI())) {
                    if ("workspace".equals(name.getLocalPart())) {
                        result.addWorkspace(AtomPubParser.parseWorkspace(parser));
                        continue;
                    }
                    AtomPubParser.skip(parser);
                    continue;
                }
                AtomPubParser.skip(parser);
                continue;
            }
            if (event == 2 || !AtomPubParser.next(parser)) break;
        }
        return result;
    }

    private static RepositoryWorkspace parseWorkspace(XMLStreamReader parser) throws Exception {
        RepositoryWorkspace workspace = new RepositoryWorkspace();
        AtomPubParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                AtomElement element = AtomPubParser.parseWorkspaceElement(parser);
                if (element != null && element.getObject() instanceof CmisRepositoryInfoType) {
                    workspace.setId(((CmisRepositoryInfoType)element.getObject()).getRepositoryId());
                }
                workspace.addElement(element);
                continue;
            }
            if (event == 2 || !AtomPubParser.next(parser)) break;
        }
        AtomPubParser.next(parser);
        return workspace;
    }

    private AtomFeed parseFeed(XMLStreamReader parser) throws Exception {
        AtomFeed result = new AtomFeed();
        AtomPubParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("link".equals(name.getLocalPart())) {
                        result.addElement(AtomPubParser.parseLink(parser));
                        continue;
                    }
                    if ("entry".equals(name.getLocalPart())) {
                        result.addEntry(this.parseEntry(parser));
                        continue;
                    }
                    AtomPubParser.skip(parser);
                    continue;
                }
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if ("numItems".equals(name.getLocalPart())) {
                        result.addElement(AtomPubParser.parseBigInteger(parser));
                        continue;
                    }
                    AtomPubParser.skip(parser);
                    continue;
                }
                AtomPubParser.skip(parser);
                continue;
            }
            if (event == 2 || !AtomPubParser.next(parser)) break;
        }
        AtomPubParser.next(parser);
        return result;
    }

    private AtomEntry parseEntry(XMLStreamReader parser) throws Exception {
        AtomEntry result = new AtomEntry();
        AtomPubParser.next(parser);
        block0: while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                AtomElement element = this.parseElement(parser);
                if (element == null) continue;
                result.addElement(element);
                if (element.getObject() instanceof CmisObjectType) {
                    Iterator i$ = ((CmisObjectType)element.getObject()).getProperties().getProperty().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block0;
                        CmisProperty prop = (CmisProperty)i$.next();
                        if (!EnumPropertiesBase.CMIS_OBJECT_ID.value().equals(prop.getPropertyDefinitionId())) continue;
                        result.setId((String)((CmisPropertyId)prop).getValue().get(0));
                    }
                }
                if (!(element.getObject() instanceof CmisTypeDefinitionType)) continue;
                result.setId(((CmisTypeDefinitionType)element.getObject()).getId());
                continue;
            }
            if (event == 2 || !AtomPubParser.next(parser)) break;
        }
        AtomPubParser.next(parser);
        return result;
    }

    private static AtomAllowableActions parseAllowableActions(XMLStreamReader parser) throws Exception {
        AtomElement elemenet = AtomPubParser.unmarshalElement(parser, CmisAllowableActionsType.class);
        return new AtomAllowableActions((CmisAllowableActionsType)elemenet.getObject());
    }

    private static AtomAcl parseACL(XMLStreamReader parser) throws Exception {
        AtomElement elemenet = AtomPubParser.unmarshalElement(parser, CmisAccessControlListType.class);
        return new AtomAcl((CmisAccessControlListType)elemenet.getObject());
    }

    private AtomElement parseElement(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("object".equals(name.getLocalPart())) {
                return AtomPubParser.unmarshalElement(parser, CmisObjectType.class);
            }
            if ("pathSegment".equals(name.getLocalPart()) || "relativePathSegment".equals(name.getLocalPart())) {
                return AtomPubParser.parseText(parser);
            }
            if ("type".equals(name.getLocalPart())) {
                String typeAttr = parser.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (typeAttr == null) {
                    return AtomPubParser.unmarshalElement(parser, CmisTypeDefinitionType.class);
                }
                if (typeAttr.endsWith(CmisAtomPubConstants.ATTR_DOCUMENT_TYPE)) {
                    return AtomPubParser.unmarshalElement(parser, CmisTypeDocumentDefinitionType.class);
                }
                if (typeAttr.endsWith(CmisAtomPubConstants.ATTR_FOLDER_TYPE)) {
                    return AtomPubParser.unmarshalElement(parser, CmisTypeFolderDefinitionType.class);
                }
                if (typeAttr.endsWith(CmisAtomPubConstants.ATTR_RELATIONSHIP_TYPE)) {
                    return AtomPubParser.unmarshalElement(parser, CmisTypeRelationshipDefinitionType.class);
                }
                if (typeAttr.endsWith(CmisAtomPubConstants.ATTR_POLICY_TYPE)) {
                    return AtomPubParser.unmarshalElement(parser, CmisTypePolicyDefinitionType.class);
                }
                throw new CmisRuntimeException("Cannot read type definition!");
            }
            if ("children".equals(name.getLocalPart())) {
                return this.parseChildren(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return AtomPubParser.parseLink(parser);
            }
            if ("content".equals(name.getLocalPart())) {
                return AtomPubParser.parseAtomContentSrc(parser);
            }
        }
        AtomPubParser.skip(parser);
        return null;
    }

    private static <T> AtomElement unmarshalElement(XMLStreamReader parser, Class<T> cmisType) throws Exception {
        QName name = parser.getName();
        Unmarshaller u = JaxBHelper.createUnmarshaller();
        JAXBElement object = u.unmarshal(parser, cmisType);
        return new AtomElement(name, object.getValue());
    }

    private AtomElement parseChildren(XMLStreamReader parser) throws Exception {
        AtomElement result = null;
        QName childName = parser.getName();
        AtomPubParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("feed".equals(name.getLocalPart())) {
                        result = new AtomElement(childName, this.parseFeed(parser));
                        continue;
                    }
                    AtomPubParser.skip(parser);
                    continue;
                }
                AtomPubParser.skip(parser);
                continue;
            }
            if (event == 2 || !AtomPubParser.next(parser)) break;
        }
        AtomPubParser.next(parser);
        return result;
    }

    private static AtomElement parseWorkspaceElement(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("repositoryInfo".equals(name.getLocalPart())) {
                return AtomPubParser.unmarshalElement(parser, CmisRepositoryInfoType.class);
            }
            if ("uritemplate".equals(name.getLocalPart())) {
                return AtomPubParser.parseTemplate(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return AtomPubParser.parseLink(parser);
            }
        } else if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI()) && "collection".equals(name.getLocalPart())) {
            return AtomPubParser.parseCollection(parser);
        }
        AtomPubParser.skip(parser);
        return null;
    }

    private static AtomElement parseCollection(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("href", parser.getAttributeValue(null, "href"));
        AtomPubParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName tagName = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI()) && "collectionType".equals(tagName.getLocalPart())) {
                    result.put("collectionType", AtomPubParser.readText(parser));
                    continue;
                }
                AtomPubParser.skip(parser);
                continue;
            }
            if (event == 2 || !AtomPubParser.next(parser)) break;
        }
        AtomPubParser.next(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseTemplate(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        AtomPubParser.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName tagName = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI())) {
                    if ("template".equals(tagName.getLocalPart())) {
                        result.put("template", AtomPubParser.readText(parser));
                        continue;
                    }
                    if ("type".equals(tagName.getLocalPart())) {
                        result.put("type", AtomPubParser.readText(parser));
                        continue;
                    }
                    AtomPubParser.skip(parser);
                    continue;
                }
                AtomPubParser.skip(parser);
                continue;
            }
            if (event == 2 || !AtomPubParser.next(parser)) break;
        }
        AtomPubParser.next(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseLink(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        AtomLink result = new AtomLink();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if ("rel".equals(parser.getAttributeLocalName(i))) {
                result.setRel(parser.getAttributeValue(i));
                continue;
            }
            if ("href".equals(parser.getAttributeLocalName(i))) {
                result.setHref(parser.getAttributeValue(i));
                continue;
            }
            if (!"type".equals(parser.getAttributeLocalName(i))) continue;
            result.setType(parser.getAttributeValue(i));
        }
        AtomPubParser.skip(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseAtomContentSrc(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        AtomLink result = new AtomLink();
        result.setRel(LINK_REL_CONTENT);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!"src".equals(parser.getAttributeLocalName(i))) continue;
            result.setHref(parser.getAttributeValue(i));
        }
        AtomPubParser.skip(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseText(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        return new AtomElement(name, AtomPubParser.readText(parser));
    }

    private static AtomElement parseBigInteger(XMLStreamReader parser) throws Exception {
        QName name = parser.getName();
        return new AtomElement(name, new BigInteger(AtomPubParser.readText(parser)));
    }

    private static String readText(XMLStreamReader parser) throws Exception {
        int event;
        StringBuilder sb = new StringBuilder();
        AtomPubParser.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4) {
                String s = parser.getText();
                if (s != null) {
                    sb.append(s);
                }
            } else if (event == 1) {
                throw new RuntimeException("Unexpected tag: " + parser.getName());
            }
            if (AtomPubParser.next(parser)) continue;
            break;
        }
        AtomPubParser.next(parser);
        return sb.toString();
    }

    private static void skip(XMLStreamReader parser) throws Exception {
        int level = 1;
        while (AtomPubParser.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                ++level;
                continue;
            }
            if (event != 2 || --level != 0) continue;
            break;
        }
        AtomPubParser.next(parser);
    }

    private static boolean next(XMLStreamReader parser) throws Exception {
        if (parser.hasNext()) {
            parser.next();
            return true;
        }
        return false;
    }
}

