/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.exists;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.exists.ExistsRequest;
import org.elasticsearch.action.exists.ExistsResponse;
import org.elasticsearch.action.exists.ShardExistsRequest;
import org.elasticsearch.action.exists.ShardExistsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportExistsAction
extends TransportBroadcastOperationAction<ExistsRequest, ExistsResponse, ShardExistsRequest, ShardExistsResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final CacheRecycler cacheRecycler;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;

    @Inject
    public TransportExistsAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, CacheRecycler cacheRecycler, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, ActionFilters actionFilters) {
        super(settings, "indices:data/read/exists", threadPool, clusterService, transportService, actionFilters);
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.cacheRecycler = cacheRecycler;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
    }

    @Override
    protected void doExecute(ExistsRequest request, ActionListener<ExistsResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        new ExistsAsyncBroadcastAction(request, listener).start();
    }

    @Override
    protected String executor() {
        return "search";
    }

    @Override
    protected ExistsRequest newRequest() {
        return new ExistsRequest();
    }

    @Override
    protected ShardExistsRequest newShardRequest() {
        return new ShardExistsRequest();
    }

    @Override
    protected ShardExistsRequest newShardRequest(int numShards, ShardRouting shard, ExistsRequest request) {
        String[] filteringAliases = this.clusterService.state().metaData().filteringAliases(shard.index(), request.indices());
        return new ShardExistsRequest(shard.shardId(), filteringAliases, request);
    }

    @Override
    protected ShardExistsResponse newShardResponse() {
        return new ShardExistsResponse();
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, ExistsRequest request, String[] concreteIndices) {
        Map<String, Set<String>> routingMap = clusterState.metaData().resolveSearchRouting(request.routing(), request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, request.indices(), concreteIndices, routingMap, request.preference());
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ExistsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ExistsRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected ExistsResponse newResponse(ExistsRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        boolean exists = false;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = shardsResponses.length() - 1; i >= 0; --i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = Lists.newArrayList();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            ++successfulShards;
            exists = ((ShardExistsResponse)shardResponse).exists();
            if (!exists) continue;
            successfulShards = shardsResponses.length() - failedShards;
            break;
        }
        return new ExistsResponse(exists, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ShardExistsResponse shardOperation(ShardExistsRequest request) throws ElasticsearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.shardSafe(request.shardId().id());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.shardId().getIndex(), request.shardId().id());
        DefaultSearchContext context = new DefaultSearchContext(0L, new ShardSearchLocalRequest(request.types(), request.nowInMillis(), request.filteringAliases()), shardTarget, indexShard.acquireSearcher("exists"), indexService, indexShard, this.scriptService, this.cacheRecycler, this.pageCacheRecycler, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter());
        SearchContext.setCurrent(context);
        try {
            BytesReference source;
            if (request.minScore() != -1.0f) {
                ((SearchContext)context).minimumScore(request.minScore());
            }
            if ((source = request.querySource()) != null && source.length() > 0) {
                try {
                    QueryParseContext.setTypes(request.types());
                    ((SearchContext)context).parsedQuery(indexService.queryParserService().parseQuery(source));
                }
                finally {
                    QueryParseContext.removeTypes();
                }
            }
            ((SearchContext)context).preProcess();
            try {
                Lucene.EarlyTerminatingCollector existsCollector = Lucene.createExistsCollector();
                Lucene.exists(((SearchContext)context).searcher(), ((SearchContext)context).query(), existsCollector);
                ShardExistsResponse shardExistsResponse = new ShardExistsResponse(request.shardId(), existsCollector.exists());
                return shardExistsResponse;
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(context, "failed to execute exists", (Throwable)e);
            }
        }
        finally {
            context.close();
            SearchContext.removeCurrent();
        }
    }

    private final class ExistsAsyncBroadcastAction
    extends TransportBroadcastOperationAction.AsyncBroadcastAction {
        final AtomicBoolean processed;

        ExistsAsyncBroadcastAction(ExistsRequest request, ActionListener<ExistsResponse> listener) {
            super((TransportBroadcastOperationAction)TransportExistsAction.this, (BroadcastOperationRequest)request, listener);
            this.processed = new AtomicBoolean(false);
        }

        protected void onOperation(ShardRouting shard, int shardIndex, ShardExistsResponse response) {
            super.onOperation(shard, shardIndex, response);
            if (response.exists()) {
                this.finishHim();
            }
        }

        @Override
        protected void performOperation(ShardIterator shardIt, ShardRouting shard, int shardIndex) {
            if (this.processed.get()) {
                return;
            }
            super.performOperation(shardIt, shard, shardIndex);
        }

        @Override
        protected void finishHim() {
            if (this.processed.compareAndSet(false, true)) {
                super.finishHim();
            }
        }
    }
}

