/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;

public class CancellableThreads {
    private final Set<Thread> threads = new HashSet<Thread>();
    private boolean cancelled = false;
    private String reason;

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void checkForCancel() {
        if (this.isCancelled()) {
            this.onCancel(this.reason, null);
        }
    }

    protected void onCancel(String reason, @Nullable Throwable suppressedException) {
        ExecutionCancelledException e = new ExecutionCancelledException("operation was cancelled reason [" + reason + "]");
        if (suppressedException != null) {
            e.addSuppressed(suppressedException);
        }
        throw e;
    }

    private synchronized boolean add() {
        this.checkForCancel();
        this.threads.add(Thread.currentThread());
        return Thread.interrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Interruptable interruptable) {
        boolean wasInterrupted = this.add();
        RuntimeException throwable = null;
        try {
            interruptable.run();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        finally {
            this.remove();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        } else {
            Thread.interrupted();
        }
        CancellableThreads cancellableThreads = this;
        synchronized (cancellableThreads) {
            if (this.isCancelled()) {
                this.onCancel(this.reason, throwable);
            } else if (throwable != null) {
                throw throwable;
            }
        }
    }

    private synchronized void remove() {
        this.threads.remove(Thread.currentThread());
    }

    public synchronized void cancel(String reason) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.reason = reason;
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
    }

    public class ExecutionCancelledException
    extends ElasticsearchException {
        public ExecutionCancelledException(String msg) {
            super(msg);
        }

        public ExecutionCancelledException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static interface Interruptable {
        public void run() throws InterruptedException;
    }
}

