/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericLongTokenizer;

public class NumericLongAnalyzer
extends NumericAnalyzer<NumericLongTokenizer> {
    private static final IntObjectOpenHashMap<NamedAnalyzer> builtIn = new IntObjectOpenHashMap();
    private final int precisionStep;

    public static NamedAnalyzer buildNamedAnalyzer(int precisionStep) {
        NamedAnalyzer namedAnalyzer = builtIn.get(precisionStep);
        if (namedAnalyzer == null) {
            namedAnalyzer = new NamedAnalyzer("_long/" + precisionStep, AnalyzerScope.INDEX, new NumericLongAnalyzer(precisionStep));
        }
        return namedAnalyzer;
    }

    public NumericLongAnalyzer(int precisionStep) {
        this.precisionStep = precisionStep;
    }

    @Override
    protected NumericLongTokenizer createNumericTokenizer(Reader reader, char[] buffer) throws IOException {
        return new NumericLongTokenizer(reader, this.precisionStep, buffer);
    }

    static {
        builtIn.put(Integer.MAX_VALUE, new NamedAnalyzer("_long/max", AnalyzerScope.GLOBAL, new NumericLongAnalyzer(Integer.MAX_VALUE)));
        for (int i = 0; i <= 64; i += 4) {
            builtIn.put(i, new NamedAnalyzer("_long/" + i, AnalyzerScope.GLOBAL, new NumericLongAnalyzer(i)));
        }
    }
}

