/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.script.ScriptService;

public class TemplateQueryBuilder
extends BaseQueryBuilder {
    private Map<String, Object> vars;
    private String template;
    private ScriptService.ScriptType templateType;

    public TemplateQueryBuilder(String template, Map<String, Object> vars) {
        this(template, ScriptService.ScriptType.INLINE, vars);
    }

    public TemplateQueryBuilder(String template, ScriptService.ScriptType templateType, Map<String, Object> vars) {
        this.template = template;
        this.vars = vars;
        this.templateType = templateType;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String fieldname;
        builder.startObject("template");
        switch (this.templateType) {
            case FILE: {
                fieldname = "file";
                break;
            }
            case INDEXED: {
                fieldname = "id";
                break;
            }
            case INLINE: {
                fieldname = "query";
                break;
            }
            default: {
                throw new ElasticsearchIllegalArgumentException("Unknown template type " + (Object)((Object)this.templateType));
            }
        }
        builder.field(fieldname, this.template);
        builder.field("params", this.vars);
        builder.endObject();
    }
}

