/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.mapping.get;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestGetMappingAction
extends BaseRestHandler {
    @Inject
    public RestGetMappingAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestBuilderListener<GetMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsByIndex = response.getMappings();
                if (mappingsByIndex.isEmpty()) {
                    if (indices.length != 0 && types.length != 0) {
                        return new BytesRestResponse(RestStatus.OK, builder.endObject());
                    }
                    if (indices.length != 0) {
                        return new BytesRestResponse(this.channel, new IndexMissingException(new Index(indices[0])));
                    }
                    if (types.length != 0) {
                        return new BytesRestResponse(this.channel, new TypeMissingException(new Index("_all"), new String[]{types[0]}));
                    }
                    return new BytesRestResponse(RestStatus.OK, builder.endObject());
                }
                for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : mappingsByIndex) {
                    if (((ImmutableOpenMap)objectObjectCursor.value).isEmpty()) continue;
                    builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                    builder.startObject(Fields.MAPPINGS);
                    for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                        builder.field((String)typeEntry.key);
                        builder.map(((MappingMetaData)typeEntry.value).sourceAsMap());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    static class Fields {
        static final XContentBuilderString MAPPINGS = new XContentBuilderString("mappings");

        Fields() {
        }
    }
}

