/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.format;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class ValueFormatterStreams {
    public static ValueFormatter read(StreamInput in) throws IOException {
        byte id = in.readByte();
        ValueFormatter formatter = null;
        switch (id) {
            case 1: {
                return ValueFormatter.RAW;
            }
            case 6: {
                return ValueFormatter.IPv4;
            }
            case 2: {
                formatter = new ValueFormatter.DateTime();
                break;
            }
            case 4: {
                formatter = new ValueFormatter.Number.Pattern();
                break;
            }
            case 8: {
                formatter = ValueFormatter.GEOHASH;
                break;
            }
            default: {
                throw new ElasticsearchIllegalArgumentException("Unknown value formatter with id [" + id + "]");
            }
        }
        formatter.readFrom(in);
        return formatter;
    }

    public static ValueFormatter readOptional(StreamInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return ValueFormatterStreams.read(in);
    }

    public static void write(ValueFormatter formatter, StreamOutput out) throws IOException {
        out.writeByte(formatter.id());
        formatter.writeTo(out);
    }

    public static void writeOptional(ValueFormatter formatter, StreamOutput out) throws IOException {
        out.writeBoolean(formatter != null);
        if (formatter != null) {
            ValueFormatterStreams.write(formatter, out);
        }
    }
}

