/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.automation;

import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Operation(id="Favorite.GetDocuments", category="Document", label="Get documents from favorites", description="Get the list of documents visible from the currentUser's favorites. This is returning a list of documents.", aliases={"Collection.GetElementsInFavorite"})
public class GetDocumentsFromFavoritesOperation {
    public static final String ID = "Favorite.GetDocuments";
    @Context
    protected CoreSession session;
    @Context
    protected FavoritesManager favoritesManager;
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;

    @OperationMethod
    public DocumentModelList run(DocumentModel context) throws OperationException {
        DocumentModel favorites = this.favoritesManager.getFavorites(context, this.session);
        Map vars = this.ctx.getVars();
        vars.put("searchTerm", favorites.getId());
        vars.put("providerName", "default_content_collection");
        OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), vars);
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters("Repository.PageProvider", vars);
        chain.add(oparams);
        return (PaginableDocumentModelListImpl)this.service.run(subctx, chain);
    }
}

