/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Operation(id="Collection.RemoveFromCollection", category="Document", label="Remove from collection", description="Remove a list of documents from a collection. No value is returned.")
public class RemoveFromCollectionOperation {
    public static final String ID = "Collection.RemoveFromCollection";
    @Context
    protected CoreSession session;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="collection")
    protected DocumentModel collection;

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        for (DocumentModel doc : docs) {
            this.collectionManager.removeFromCollection(this.collection, doc, this.session);
        }
        return docs;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        this.collectionManager.removeFromCollection(this.collection, doc, this.session);
        return doc;
    }
}

