/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.TomcatConfigurator;
import org.nuxeo.runtime.deployment.NuxeoStarter;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PackWar {
    private static Log log = LogFactory.getLog(PackWar.class);
    private static final List<String> ENDORSED_LIBS = Arrays.asList("xercesImpl");
    private static final List<String> MISSING_WEBINF_LIBS = Arrays.asList("mail", "freemarker");
    private static final List<String> MISSING_LIBS = Arrays.asList("nuxeo-wss-front", "log4j", "commons-logging", "commons-lang", "jcl-over-slf4j", "slf4j-api", "slf4j-log4j12", "tomcat-juli-adapters", "derby", "h2", "ojdbc", "postgresql", "mysql-connector-java", "nuxeo-core-storage-sql-extensions", "lucene", "elasticsearch");
    private static final String ENDORSED_LIB = "endorsed/";
    private static final String ZIP_LIB = "lib/";
    private static final String ZIP_WEBAPPS = "webapps/";
    private static final String ZIP_WEBINF = "WEB-INF/";
    private static final String ZIP_WEBINF_LIB = "WEB-INF/lib/";
    private static final String ZIP_README = "README-NUXEO.txt";
    private static final String README_BEGIN = "This ZIP must be uncompressed at the root of your Tomcat instance.\n\nIn order for Nuxeo to run, the following Resource defining your JDBC datasource configuration\nmust be added inside the <GlobalNamingResources> section of the file conf/server.xml\n\n  ";
    private static final String README_END = "\n\nMake sure that the 'url' attribute above is correct.\nNote that the following file can also contains database configuration:\n\n  webapps/nuxeo/WEB-INF/default-repository-config.xml\n\nAlso note that you should start Tomcat with more memory than its default, for instance:\n\n  JAVA_OPTS=\"-Xms512m -Xmx1024m -Dnuxeo.log.dir=logs\" bin/catalina.sh start\n\n";
    private static final String COMMAND_PREPROCESSING = "preprocessing";
    private static final String COMMAND_PACKAGING = "packaging";
    protected File nxserver;
    protected File tomcat;
    protected File zip;
    private ConfigurationGenerator cg;
    private TomcatConfigurator tomcatConfigurator;

    public PackWar(File nxserver, File zip) {
        if (!nxserver.isDirectory() || !nxserver.getName().equals("nxserver")) {
            PackWar.fail("No nxserver found at " + nxserver);
        }
        if (zip.exists()) {
            PackWar.fail("Target ZIP file " + zip + " already exists");
        }
        this.nxserver = nxserver;
        this.tomcat = nxserver.getParentFile();
        this.zip = zip;
    }

    public void execute(String command) throws ConfigurationException, IOException {
        boolean packaging;
        boolean preprocessing = COMMAND_PREPROCESSING.equals(command) || StringUtils.isBlank((String)command);
        boolean bl = packaging = COMMAND_PACKAGING.equals(command) || StringUtils.isBlank((String)command);
        if (!preprocessing && !packaging) {
            PackWar.fail("Command parameter should be empty or preprocessing or packaging");
        }
        if (preprocessing) {
            this.executePreprocessing();
        }
        if (packaging) {
            this.executePackaging();
        }
    }

    protected void executePreprocessing() throws ConfigurationException, IOException {
        this.runTemplatePreprocessor();
        this.runDeploymentPreprocessor();
    }

    protected void runTemplatePreprocessor() throws ConfigurationException {
        if (System.getProperty("nuxeo.home") == null) {
            System.setProperty("nuxeo.home", this.tomcat.getAbsolutePath());
        }
        if (System.getProperty("nuxeo.conf") == null) {
            System.setProperty("nuxeo.conf", new File(this.tomcat, "bin/nuxeo.conf").getPath());
        }
        this.cg = new ConfigurationGenerator();
        this.cg.run();
        this.tomcatConfigurator = (TomcatConfigurator)this.cg.getServerConfigurator();
    }

    protected void runDeploymentPreprocessor() throws IOException {
        DeploymentPreprocessor processor = new DeploymentPreprocessor(this.nxserver);
        processor.init();
        processor.predeploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePackaging() throws IOException {
        FileOutputStream out = new FileOutputStream(this.zip);
        ZipOutputStream zout = new ZipOutputStream(out);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(README_BEGIN.getBytes("UTF-8"));
            ServerXmlProcessor.INSTANCE.process(PackWar.newFile(this.tomcat, "conf/server.xml"), bout);
            bout.write(README_END.replace("webapps/nuxeo", ZIP_WEBAPPS + this.tomcatConfigurator.getContextName()).getBytes("UTF-8"));
            this.zipBytes(ZIP_README, bout.toByteArray(), zout);
            File nuxeoXml = new File(this.tomcat, this.tomcatConfigurator.getTomcatConfig());
            String zipWebappsNuxeo = ZIP_WEBAPPS + this.tomcatConfigurator.getContextName() + "/";
            this.zipFile(zipWebappsNuxeo + "META-INF/context.xml", nuxeoXml, zout, NuxeoXmlProcessor.INSTANCE);
            this.zipTree(zipWebappsNuxeo, new File(this.nxserver, "nuxeo.war"), false, zout);
            this.zipTree(zipWebappsNuxeo + ZIP_WEBINF, new File(this.nxserver, "config"), false, zout);
            File nuxeoBundles = this.listNuxeoBundles();
            this.zipFile(zipWebappsNuxeo + ZIP_WEBINF + ".nuxeo-bundles", nuxeoBundles, zout, null);
            nuxeoBundles.delete();
            this.zipTree(zipWebappsNuxeo + ZIP_WEBINF_LIB, new File(this.nxserver, "bundles"), false, zout);
            this.zipTree(zipWebappsNuxeo + ZIP_WEBINF_LIB, new File(this.nxserver, "lib"), false, zout);
            this.zipLibs(zipWebappsNuxeo + ZIP_WEBINF_LIB, new File(this.tomcat, "lib"), MISSING_WEBINF_LIBS, zout);
            this.zipLibs(ZIP_LIB, new File(this.tomcat, "lib"), MISSING_LIBS, zout);
            this.zipFile("lib/log4j.xml", PackWar.newFile(this.tomcat, "lib/log4j.xml"), zout, null);
            this.zipTree(ENDORSED_LIB, new File(this.tomcat, "endorsed"), false, zout);
            this.zipLibs(ENDORSED_LIB, new File(this.tomcat, "lib"), ENDORSED_LIBS, zout);
        }
        finally {
            zout.finish();
            zout.close();
        }
    }

    private File listNuxeoBundles() throws IOException {
        File nuxeoBundles = File.createTempFile(".nuxeo-bundles", "");
        File[] bundles = new File(this.nxserver, "bundles").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(nuxeoBundles));){
            for (File bundle : bundles) {
                writer.write(bundle.getName());
                writer.newLine();
            }
        }
        return nuxeoBundles;
    }

    protected static File newFile(File base, String path) {
        return new File(base, path.replace("/", File.separator));
    }

    protected void zipLibs(String prefix, File dir, List<String> patterns, ZipOutputStream zout) throws IOException {
        block0: for (String name : dir.list()) {
            for (String pat : patterns) {
                if ((!name.startsWith(pat + '-') || !name.endsWith(".jar")) && !name.equals(pat + ".jar")) continue;
                this.zipFile(prefix + name, new File(dir, name), zout, null);
                continue block0;
            }
        }
    }

    protected void zipDirectory(String entryName, ZipOutputStream zout) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        zout.putNextEntry(zentry);
        zout.closeEntry();
    }

    protected void zipFile(String entryName, File file, ZipOutputStream zout, FileProcessor processor) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        if (processor == null) {
            processor = CopyProcessor.INSTANCE;
            zentry.setTime(file.lastModified());
        }
        zout.putNextEntry(zentry);
        processor.process(file, zout);
        zout.closeEntry();
    }

    protected void zipBytes(String entryName, byte[] bytes, ZipOutputStream zout) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        zout.putNextEntry(zentry);
        zout.write(bytes);
        zout.closeEntry();
    }

    protected void zipTree(String prefix, File root, boolean includeRoot, ZipOutputStream zout) throws IOException {
        if (includeRoot) {
            prefix = prefix + root.getName() + '/';
            this.zipDirectory(prefix, zout);
        }
        String zipWebappsNuxeo = ZIP_WEBAPPS + this.tomcatConfigurator.getContextName() + "/";
        for (String name : root.list()) {
            File file = new File(root, name);
            if (file.isDirectory()) {
                this.zipTree(prefix, file, true, zout);
                continue;
            }
            if (name.endsWith("~") || name.endsWith("#") || name.endsWith(".bak") || name.equals("README.txt")) continue;
            name = prefix + name;
            FileProcessor processor = name.equals(zipWebappsNuxeo + ZIP_WEBINF + "web.xml") ? WebXmlProcessor.INSTANCE : (name.equals(zipWebappsNuxeo + ZIP_WEBINF + "opensocial.properties") ? new PropertiesFileProcessor("res://config/", zipWebappsNuxeo + ZIP_WEBINF) : null);
            this.zipFile(name, file, zout, processor);
        }
    }

    public static void fail(String message) {
        PackWar.fail(message, null);
    }

    public static void fail(String message, Throwable t) {
        log.error((Object)message, t);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3 || args.length == 3 && !Arrays.asList(COMMAND_PREPROCESSING, COMMAND_PACKAGING).contains(args[2])) {
            PackWar.fail(String.format("Usage: %s <nxserver_dir> <target_zip> [command]\n    command may be empty or '%s' or '%s'", PackWar.class.getSimpleName(), COMMAND_PREPROCESSING, COMMAND_PACKAGING));
        }
        File nxserver = new File(args[0]).getAbsoluteFile();
        File zip = new File(args[1]).getAbsoluteFile();
        String command = args.length == 3 ? args[2] : null;
        log.info((Object)("Packing nuxeo WAR at " + nxserver + " into " + zip));
        try {
            new PackWar(nxserver, zip).execute(command);
        }
        catch (IOException | ConfigurationException e) {
            PackWar.fail("Pack failed", e);
        }
    }

    protected static class ServerXmlProcessor
    implements FileProcessor {
        public static ServerXmlProcessor INSTANCE = new ServerXmlProcessor();
        private static final String GLOBAL_NAMING_RESOURCES = "GlobalNamingResources";
        private static final String RESOURCE = "Resource";
        private static final String NAME = "name";
        private static final String JDBC_NUXEO = "jdbc/nuxeo";
        public String resource;

        protected ServerXmlProcessor() {
        }

        @Override
        public void process(File file, OutputStream out) throws IOException {
            DocumentBuilder parser;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            try (FileInputStream in = new FileInputStream(file);){
                Document doc = parser.parse(in);
                doc.setStrictErrorChecking(false);
                Element root = doc.getDocumentElement();
                Node n = root.getFirstChild();
                Element resourceElement = null;
                while (n != null) {
                    Node next = n.getNextSibling();
                    String name = n.getNodeName();
                    if (GLOBAL_NAMING_RESOURCES.equals(name)) {
                        next = n.getFirstChild();
                    }
                    if (RESOURCE.equals(name) && ((Element)n).getAttribute(NAME).equals(JDBC_NUXEO)) {
                        resourceElement = (Element)n;
                        break;
                    }
                    n = next;
                }
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "yes");
                trans.setOutputProperty("indent", "no");
                trans.transform(new DOMSource(resourceElement), new StreamResult(out));
            }
        }
    }

    protected static class NuxeoXmlProcessor
    extends XmlProcessor {
        public static NuxeoXmlProcessor INSTANCE = new NuxeoXmlProcessor();
        private static final String DOCBASE = "docBase";
        private static final String LOADER = "Loader";
        private static final String LISTENER = "Listener";

        protected NuxeoXmlProcessor() {
        }

        @Override
        protected void process(Document doc) {
            Element root = doc.getDocumentElement();
            root.removeAttribute(DOCBASE);
            Node n = root.getFirstChild();
            while (n != null) {
                Node next = n.getNextSibling();
                String name = n.getNodeName();
                if (LOADER.equals(name) || LISTENER.equals(name)) {
                    root.removeChild(n);
                }
                n = next;
            }
        }
    }

    protected static class WebXmlProcessor
    extends XmlProcessor {
        public static WebXmlProcessor INSTANCE = new WebXmlProcessor();
        private static final String LISTENER = "listener";
        private static final String LISTENER_CLASS = "listener-class";

        protected WebXmlProcessor() {
        }

        @Override
        protected void process(Document doc) {
            for (Node n = doc.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!LISTENER.equals(n.getNodeName())) continue;
                Element listener = doc.createElement(LISTENER);
                n.insertBefore(listener, n);
                listener.appendChild(doc.createElement(LISTENER_CLASS)).appendChild(doc.createTextNode(NuxeoStarter.class.getName()));
                break;
            }
        }
    }

    protected static abstract class XmlProcessor
    implements FileProcessor {
        protected XmlProcessor() {
        }

        @Override
        public void process(File file, OutputStream out) throws IOException {
            DocumentBuilder parser;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            try (FileInputStream in = new FileInputStream(file);){
                Document doc = parser.parse(in);
                doc.setStrictErrorChecking(false);
                this.process(doc);
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "no");
                trans.setOutputProperty("indent", "yes");
                trans.transform(new DOMSource(doc), new StreamResult(out));
            }
        }

        protected abstract void process(Document var1);
    }

    protected class PropertiesFileProcessor
    implements FileProcessor {
        protected String target;
        protected String replacement;

        public PropertiesFileProcessor(String target, String replacement) {
            this.target = target;
            this.replacement = replacement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(File file, OutputStream out) throws IOException {
            try (FileInputStream in = new FileInputStream(file);){
                List lines = IOUtils.readLines((InputStream)in, (String)"UTF-8");
                ArrayList<String> outLines = new ArrayList<String>();
                for (String line : lines) {
                    outLines.add(line.replace(this.target, this.replacement));
                }
                IOUtils.writeLines(outLines, null, (OutputStream)out, (String)"UTF-8");
            }
        }
    }

    protected static class CopyProcessor
    implements FileProcessor {
        public static final CopyProcessor INSTANCE = new CopyProcessor();

        protected CopyProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(File file, OutputStream out) throws IOException {
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    protected static interface FileProcessor {
        public void process(File var1, OutputStream var2) throws IOException;
    }
}

