/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.StateAccessor;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseDocument<T extends StateAccessor>
implements Document {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String BLOB_NAME = "name";
    public static final String BLOB_MIME_TYPE = "mime-type";
    public static final String BLOB_ENCODING = "encoding";
    public static final String BLOB_DIGEST = "digest";
    public static final String BLOB_LENGTH = "length";
    public static final String BLOB_DATA = "data";
    public static final String DC_PREFIX = "dc:";
    public static final String DC_ISSUED = "dc:issued";
    public static final String RELATED_TEXT_RESOURCES = "relatedtextresources";
    public static final String RELATED_TEXT_ID = "relatedtextid";
    public static final String RELATED_TEXT = "relatedtext";
    public static final String FULLTEXT_JOBID_PROP = "ecm:fulltextJobId";
    public static final String FULLTEXT_SIMPLETEXT_PROP = "ecm:simpleText";
    public static final String FULLTEXT_BINARYTEXT_PROP = "ecm:binaryText";
    public static final String MISC_LIFECYCLE_STATE_PROP = "ecm:lifeCycleState";
    public static final String LOCK_OWNER_PROP = "ecm:lockOwner";
    public static final String LOCK_CREATED_PROP = "ecm:lockCreated";
    public static final Set<String> VERSION_WRITABLE_PROPS = new HashSet<String>(Arrays.asList("ecm:fulltextJobId", "ecm:binaryText", "ecm:lifeCycleState", "ecm:lockOwner", "ecm:lockCreated", "dc:issued", "relatedtextresources", "relatedtextid", "relatedtext"));
    protected static final Pattern NON_CANONICAL_INDEX = Pattern.compile("[^/\\[\\]]+\\[(\\d+)\\]");
    protected static final Runnable NO_DIRTY = () -> {};

    protected abstract List<Schema> getProxySchemas();

    protected abstract T getChild(T var1, String var2, Type var3) throws PropertyException;

    protected abstract T getChildForWrite(T var1, String var2, Type var3) throws PropertyException;

    protected abstract List<T> getChildAsList(T var1, String var2) throws PropertyException;

    protected abstract void updateList(T var1, String var2, List<Object> var3, Field var4) throws PropertyException;

    protected abstract List<T> updateList(T var1, String var2, Property var3) throws PropertyException;

    protected abstract String internalName(String var1);

    protected static String canonicalXPath(String xpath) {
        if (xpath.indexOf(91) > 0) {
            xpath = NON_CANONICAL_INDEX.matcher(xpath).replaceAll("$1");
        }
        return xpath;
    }

    protected static Object[] typedArray(Type type, Object[] array) {
        Class klass;
        if (array == null) {
            array = EMPTY_STRING_ARRAY;
        }
        if (type instanceof StringType) {
            klass = String.class;
        } else if (type instanceof BooleanType) {
            klass = Boolean.class;
        } else if (type instanceof LongType) {
            klass = Long.class;
        } else if (type instanceof DoubleType) {
            klass = Double.class;
        } else if (type instanceof DateType) {
            klass = Calendar.class;
        } else if (type instanceof BinaryType) {
            klass = String.class;
        } else {
            if (type instanceof IntegerType) {
                throw new RuntimeException("Unimplemented primitive type: " + type.getClass().getName());
            }
            if (type instanceof SimpleTypeImpl) {
                return BaseDocument.typedArray(type.getSuperType(), array);
            }
            throw new RuntimeException("Invalid primitive type: " + type.getClass().getName());
        }
        int len = array.length;
        Object[] copy = (Object[])Array.newInstance(klass, len);
        System.arraycopy(array, 0, copy, 0, len);
        return copy;
    }

    protected static boolean isVersionWritableProperty(String name) {
        return VERSION_WRITABLE_PROPS.contains(name) || name.startsWith(FULLTEXT_BINARYTEXT_PROP) || name.startsWith(FULLTEXT_SIMPLETEXT_PROP);
    }

    protected static void clearDirtyFlags(Property property) {
        if (property.isContainer()) {
            for (Property p : property) {
                BaseDocument.clearDirtyFlags(p);
            }
        }
        property.clearDirtyFlags();
    }

    protected boolean checkReadOnlyIgnoredWrite(Property property, T state) throws PropertyException {
        Object[] oldValue;
        String name = property.getField().getName().getPrefixedName();
        if (!this.isReadOnly() || BaseDocument.isVersionWritableProperty(name)) {
            return false;
        }
        if (!this.isVersion()) {
            throw new PropertyException("Cannot write readonly property: " + name);
        }
        if (!name.startsWith(DC_PREFIX)) {
            throw new PropertyException("Cannot set property on a version: " + name);
        }
        Serializable value = property.getValueForWrite();
        return ArrayUtils.isEquals((Object)value, (Object)(oldValue = property.getType().isSimpleType() ? state.getSingle(name) : state.getArray(name)));
    }

    protected BlobManager.BlobInfo getBlobInfo(T state) throws PropertyException {
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        blobInfo.key = (String)state.getSingle(BLOB_DATA);
        blobInfo.filename = (String)state.getSingle(BLOB_NAME);
        blobInfo.mimeType = (String)state.getSingle(BLOB_MIME_TYPE);
        blobInfo.encoding = (String)state.getSingle(BLOB_ENCODING);
        blobInfo.digest = (String)state.getSingle(BLOB_DIGEST);
        blobInfo.length = (Long)state.getSingle(BLOB_LENGTH);
        return blobInfo;
    }

    protected void setBlobInfo(T state, BlobManager.BlobInfo blobInfo) throws PropertyException {
        state.setSingle(BLOB_DATA, blobInfo.key);
        state.setSingle(BLOB_NAME, blobInfo.filename);
        state.setSingle(BLOB_MIME_TYPE, blobInfo.mimeType);
        state.setSingle(BLOB_ENCODING, blobInfo.encoding);
        state.setSingle(BLOB_DIGEST, blobInfo.digest);
        state.setSingle(BLOB_LENGTH, blobInfo.length);
    }

    protected Object getValueObject(T state, String xpath) throws PropertyException {
        xpath = BaseDocument.canonicalXPath(xpath);
        String[] segments = xpath.split("/");
        DocumentType parentType = this.getType();
        for (int i = 0; i < segments.length; ++i) {
            Object schemaManager;
            String segment = segments[i];
            Field field = parentType.getField(segment);
            if (field == null && i == 0) {
                String facet;
                CompositeType facetType;
                schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                String[] stringArray = this.getFacets();
                int n = stringArray.length;
                for (int j = 0; j < n && (field = (facetType = schemaManager.getFacet(facet = stringArray[j])).getField(segment)) == null; ++j) {
                }
            }
            if (field == null && i == 0 && this.getProxySchemas() != null) {
                Schema schema;
                schemaManager = this.getProxySchemas().iterator();
                while (schemaManager.hasNext() && (field = (schema = (Schema)schemaManager.next()).getField(segment)) == null) {
                }
            }
            if (field == null) {
                throw new PropertyNotFoundException(xpath, i == 0 ? null : "Unknown segment: " + segment);
            }
            String name = field.getName().getPrefixedName();
            Type type = field.getType();
            if (i < segments.length - 1 && StringUtils.isNumeric((String)segments[i + 1])) {
                List list;
                int index = Integer.parseInt(segments[i + 1]);
                ++i;
                if (!type.isListType() || ((ListType)type).getFieldType().isSimpleType()) {
                    throw new PropertyNotFoundException(xpath, "Cannot use index after segment: " + segment);
                }
                List list2 = list = state == null ? Collections.emptyList() : this.getChildAsList(state, name);
                if (index >= list.size()) {
                    throw new PropertyNotFoundException(xpath, "Index out of bounds: " + index);
                }
                state = (StateAccessor)list.get(index);
                parentType = (ComplexType)((ListType)type).getFieldType();
                if (i != segments.length - 1) continue;
                return this.getValueComplex(state, (ComplexType)parentType);
            }
            if (i == segments.length - 1) {
                return state == null ? null : this.getValueField(state, field);
            }
            if (type.isSimpleType()) {
                throw new PropertyNotFoundException(xpath, "Segment must be last: " + segment);
            }
            if (type.isComplexType()) {
                state = state == null ? null : this.getChild(state, name, type);
                parentType = (ComplexType)type;
                continue;
            }
            ListType listType = (ListType)type;
            if (listType.isArray()) {
                throw new PropertyNotFoundException(xpath, "Segment must be last: " + segment);
            }
            throw new PropertyNotFoundException(xpath, "Missing list index after segment: " + segment);
        }
        throw new AssertionError((Object)"not reached");
    }

    protected Object getValueField(T state, Field field) throws PropertyException {
        Type type = field.getType();
        String name = field.getName().getPrefixedName();
        name = this.internalName(name);
        if (type.isSimpleType()) {
            return state.getSingle(name);
        }
        if (type.isComplexType()) {
            T childState = this.getChild(state, name, type);
            if (childState == null) {
                return null;
            }
            return this.getValueComplex(childState, (ComplexType)type);
        }
        Type fieldType = ((ListType)type).getFieldType();
        if (fieldType.isSimpleType()) {
            return state.getArray(name);
        }
        List<T> childStates = this.getChildAsList(state, name);
        ArrayList<Object> list = new ArrayList<Object>(childStates.size());
        for (StateAccessor childState : childStates) {
            Object value = this.getValueComplex(childState, (ComplexType)fieldType);
            list.add(value);
        }
        return list;
    }

    protected Object getValueComplex(T state, ComplexType complexType) throws PropertyException {
        if (TypeConstants.isContentType((Type)complexType)) {
            return this.getValueBlob(state);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : complexType.getFields()) {
            String name = field.getName().getPrefixedName();
            Object value = this.getValueField(state, field);
            map.put(name, value);
        }
        return map;
    }

    protected Blob getValueBlob(T state) throws PropertyException {
        BlobManager.BlobInfo blobInfo = this.getBlobInfo(state);
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        try {
            return blobManager.readBlob(blobInfo, this.getRepositoryName());
        }
        catch (IOException e) {
            throw new PropertyException("Cannot get blob info for: " + blobInfo.key, (Throwable)e);
        }
    }

    protected void setValueObject(T state, String xpath, Object value) throws PropertyException {
        xpath = BaseDocument.canonicalXPath(xpath);
        String[] segments = xpath.split("/");
        DocumentType parentType = this.getType();
        for (int i = 0; i < segments.length; ++i) {
            Object schemaManager;
            String segment = segments[i];
            Field field = parentType.getField(segment);
            if (field == null && i == 0) {
                String facet;
                CompositeType facetType;
                schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                String[] stringArray = this.getFacets();
                int n = stringArray.length;
                for (int j = 0; j < n && (field = (facetType = schemaManager.getFacet(facet = stringArray[j])).getField(segment)) == null; ++j) {
                }
            }
            if (field == null && i == 0 && this.getProxySchemas() != null) {
                Schema schema;
                schemaManager = this.getProxySchemas().iterator();
                while (schemaManager.hasNext() && (field = (schema = (Schema)schemaManager.next()).getField(segment)) == null) {
                }
            }
            if (field == null) {
                throw new PropertyNotFoundException(xpath, i == 0 ? null : "Unknown segment: " + segment);
            }
            String name = field.getName().getPrefixedName();
            Type type = field.getType();
            if (i < segments.length - 1 && StringUtils.isNumeric((String)segments[i + 1])) {
                int index = Integer.parseInt(segments[i + 1]);
                ++i;
                if (!type.isListType() || ((ListType)type).getFieldType().isSimpleType()) {
                    throw new PropertyNotFoundException(xpath, "Cannot use index after segment: " + segment);
                }
                List<T> list = this.getChildAsList(state, name);
                if (index >= list.size()) {
                    throw new PropertyNotFoundException(xpath, "Index out of bounds: " + index);
                }
                state = (StateAccessor)list.get(index);
                field = ((ListType)type).getField();
                if (i == segments.length - 1) {
                    this.setValueComplex(state, field, value);
                    continue;
                }
                parentType = (ComplexType)field.getType();
                continue;
            }
            if (i == segments.length - 1) {
                this.setValueField(state, field, value);
                continue;
            }
            if (type.isSimpleType()) {
                throw new PropertyNotFoundException(xpath, "Segment must be last: " + segment);
            }
            if (type.isComplexType()) {
                state = this.getChildForWrite(state, name, type);
                parentType = (ComplexType)type;
                continue;
            }
            ListType listType = (ListType)type;
            if (listType.isArray()) {
                throw new PropertyNotFoundException(xpath, "Segment must be last: " + segment);
            }
            throw new PropertyNotFoundException(xpath, "Missing list index after segment: " + segment);
        }
    }

    protected void setValueField(T state, Field field, Object value) throws PropertyException {
        Type type = field.getType();
        String name = field.getName().getPrefixedName();
        name = this.internalName(name);
        if (type.isSimpleType()) {
            state.setSingle(name, value);
        } else if (type.isComplexType()) {
            T childState = this.getChildForWrite(state, name, type);
            this.setValueComplex(childState, field, value);
        } else {
            ListType listType = (ListType)type;
            Type fieldType = listType.getFieldType();
            if (fieldType.isSimpleType()) {
                if (value instanceof List) {
                    value = ((List)value).toArray(new Object[0]);
                }
                state.setArray(name, value);
            } else {
                if (value != null && !(value instanceof List)) {
                    throw new PropertyException("Expected List value for: " + name + ", got " + value.getClass().getName() + " instead");
                }
                List values = value == null ? Collections.emptyList() : (List)value;
                this.updateList(state, name, values, listType.getField());
            }
        }
    }

    protected void setValueComplex(T state, Field field, Object value) throws PropertyException {
        ComplexType complexType = (ComplexType)field.getType();
        if (TypeConstants.isContentType((Type)complexType)) {
            if (value != null && !(value instanceof Blob)) {
                throw new PropertyException("Expected Blob value for: " + field.getName().getPrefixedName() + ", got " + value.getClass().getName() + " instead");
            }
            this.setValueBlob(state, (Blob)value);
            return;
        }
        if (value != null && !(value instanceof Map)) {
            throw new PropertyException("Expected Map value for: " + field.getName().getPrefixedName() + ", got " + value.getClass().getName() + " instead");
        }
        Map map = value == null ? Collections.emptyMap() : (Map)value;
        HashSet keys = new HashSet(map.keySet());
        for (Field f : complexType.getFields()) {
            String name = f.getName().getPrefixedName();
            keys.remove(name);
            value = map.get(name);
            this.setValueField(state, f, value);
        }
        if (!keys.isEmpty()) {
            throw new PropertyException("Unknown key: " + (String)keys.iterator().next() + " for " + field.getName().getPrefixedName());
        }
    }

    protected void setValueBlob(T state, Blob blob) throws PropertyException {
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        if (blob != null) {
            BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
            try {
                blobInfo.key = blobManager.writeBlob(blob, (Document)this);
            }
            catch (IOException e) {
                throw new PropertyException("Cannot get blob info for: " + blob, (Throwable)e);
            }
            blobInfo.filename = blob.getFilename();
            blobInfo.mimeType = blob.getMimeType();
            blobInfo.encoding = blob.getEncoding();
            blobInfo.digest = blob.getDigest();
            blobInfo.length = blob.getLength() == -1L ? null : Long.valueOf(blob.getLength());
        }
        this.setBlobInfo(state, blobInfo);
    }

    protected void readComplexProperty(T state, ComplexProperty complexProperty) throws PropertyException {
        if (state == null) {
            complexProperty.init(null);
            return;
        }
        if (complexProperty instanceof BlobProperty) {
            Blob blob = this.getValueBlob(state);
            complexProperty.init((Serializable)blob);
            return;
        }
        for (Property property : complexProperty) {
            String name = property.getField().getName().getPrefixedName();
            name = this.internalName(name);
            Type type = property.getType();
            if (type.isSimpleType()) {
                Object value = state.getSingle(name);
                if (value instanceof Delta) {
                    value = ((Delta)value).getFullValue();
                }
                property.init((Serializable)value);
                continue;
            }
            if (type.isComplexType()) {
                T childState = this.getChild(state, name, type);
                this.readComplexProperty(childState, (ComplexProperty)property);
                ((ComplexProperty)property).removePhantomFlag();
                continue;
            }
            ListType listType = (ListType)type;
            if (listType.getFieldType().isSimpleType()) {
                Object[] array = state.getArray(name);
                array = BaseDocument.typedArray(listType.getFieldType(), array);
                property.init((Serializable)array);
                continue;
            }
            Field listField = listType.getField();
            List<T> childStates = this.getChildAsList(state, name);
            ArrayList<Serializable> list = new ArrayList<Serializable>(childStates.size());
            for (StateAccessor childState : childStates) {
                ComplexProperty p = (ComplexProperty)complexProperty.getRoot().createProperty(property, listField, 0);
                this.readComplexProperty(childState, p);
                list.add(p.getValue());
            }
            property.init((Serializable)list);
        }
    }

    public Document.WriteContext getWriteContext() {
        return new BlobWriteContext();
    }

    protected boolean writeComplexProperty(T state, ComplexProperty complexProperty, Document.WriteContext writeContext) throws PropertyException {
        return this.writeComplexProperty(state, complexProperty, null, writeContext);
    }

    protected boolean writeComplexProperty(T state, ComplexProperty complexProperty, String xpath, Document.WriteContext wc) throws PropertyException {
        BlobWriteContext writeContext = (BlobWriteContext)wc;
        if (complexProperty instanceof BlobProperty) {
            Serializable value = ((BlobProperty)complexProperty).getValueForWrite();
            if (value != null && !(value instanceof Blob)) {
                throw new PropertyException("Cannot write a non-Blob value: " + value);
            }
            writeContext.recordBlob(state, (Blob)value, this);
            return true;
        }
        boolean changed = false;
        for (Property property : complexProperty) {
            if (!property.isDirty() && (!property.isPhantom() || property.getField().getDefaultValue() == null)) continue;
            String name = property.getField().getName().getPrefixedName();
            name = this.internalName(name);
            if (this.checkReadOnlyIgnoredWrite(property, state)) continue;
            String xp = xpath == null ? name : xpath + '/' + name;
            writeContext.recordChange(xp);
            changed = true;
            Type type = property.getType();
            if (type.isSimpleType()) {
                Serializable value = property.getValueForWrite();
                state.setSingle(name, value);
                if (!(value instanceof Delta)) continue;
                value = ((Delta)value).getFullValue();
                ((ScalarProperty)property).internalSetValue(value);
                continue;
            }
            if (type.isComplexType()) {
                T childState = this.getChildForWrite(state, name, type);
                this.writeComplexProperty(childState, (ComplexProperty)property, xp, writeContext);
                continue;
            }
            ListType listType = (ListType)type;
            if (listType.getFieldType().isSimpleType()) {
                Object[] value = property.getValueForWrite();
                if (value instanceof List) {
                    Object[] array;
                    List list = (List)value;
                    if (list.isEmpty()) {
                        array = new Object[]{};
                    } else {
                        Object[] klass = list.get(0).getClass();
                        array = (Object[])Array.newInstance(klass, list.size());
                    }
                    value = list.toArray(array);
                } else if (value instanceof Object[]) {
                    Object[] ar = value;
                    if (ar.length != 0) {
                        Object[] array;
                        Class klass = Object.class;
                        for (Object o : ar) {
                            if (o == null) continue;
                            klass = o.getClass();
                            break;
                        }
                        if (ar.getClass().getComponentType() == klass) {
                            array = ar;
                        } else {
                            array = (Object[])Array.newInstance(klass, ar.length);
                            System.arraycopy(ar, 0, array, 0, ar.length);
                        }
                        value = array;
                    }
                } else if (value != null) {
                    throw new IllegalStateException(value.toString());
                }
                state.setArray(name, value);
                continue;
            }
            List<T> childStates = this.updateList(state, name, property);
            int i = 0;
            for (Property childProperty : property.getChildren()) {
                String xpi;
                StateAccessor childState = (StateAccessor)childStates.get(i);
                boolean c = this.writeComplexProperty(childState, (ComplexProperty)childProperty, xpi = xp + '/' + i, writeContext);
                if (c) {
                    writeContext.recordChange(xpi);
                }
                ++i;
            }
        }
        return changed;
    }

    protected Map<String, Serializable> readPrefetch(T state, ComplexType complexType, Set<String> xpaths) throws PropertyException {
        HashSet<String> prefixes = new HashSet<String>();
        for (String xpath : xpaths) {
            int i;
            while (prefixes.add(xpath) && (i = xpath.lastIndexOf(47)) != -1) {
                xpath = xpath.substring(0, i);
            }
        }
        HashMap<String, Serializable> prefetch = new HashMap<String, Serializable>();
        this.readPrefetch(state, complexType, null, null, prefixes, prefetch);
        return prefetch;
    }

    protected void readPrefetch(T state, ComplexType complexType, String xpathGeneric, String xpath, Set<String> prefixes, Map<String, Serializable> prefetch) throws PropertyException {
        if (TypeConstants.isContentType((Type)complexType)) {
            if (!prefixes.contains(xpathGeneric)) {
                return;
            }
            Blob blob = this.getValueBlob(state);
            prefetch.put(xpath, (Serializable)blob);
            return;
        }
        for (Field field : complexType.getFields()) {
            this.readPrefetchField(state, field, xpathGeneric, xpath, prefixes, prefetch);
        }
    }

    protected void readPrefetchField(T state, Field field, String xpathGeneric, String xpath, Set<String> prefixes, Map<String, Serializable> prefetch) {
        String name = field.getName().getPrefixedName();
        Type type = field.getType();
        xpathGeneric = xpathGeneric == null ? name : xpathGeneric + '/' + name;
        String string = xpath = xpath == null ? name : xpath + '/' + name;
        if (!prefixes.contains(xpathGeneric)) {
            return;
        }
        if (type.isSimpleType()) {
            Object value = state.getSingle(name);
            prefetch.put(xpath, (Serializable)value);
        } else if (type.isComplexType()) {
            T childState = this.getChild(state, name, type);
            if (childState != null) {
                this.readPrefetch(childState, (ComplexType)type, xpathGeneric, xpath, prefixes, prefetch);
            }
        } else {
            ListType listType = (ListType)type;
            if (listType.getFieldType().isSimpleType()) {
                Object[] value = state.getArray(name);
                prefetch.put(xpath, (Serializable)value);
            } else {
                List<T> childStates = this.getChildAsList(state, name);
                Field listField = listType.getField();
                xpathGeneric = xpathGeneric + "/*";
                int i = 0;
                for (StateAccessor childState : childStates) {
                    this.readPrefetch(childState, (ComplexType)listField.getType(), xpathGeneric, xpath + '/' + i++, prefixes, prefetch);
                }
            }
        }
    }

    protected void visitBlobs(T state, Consumer<Document.BlobAccessor> blobVisitor, Runnable markDirty) throws PropertyException {
        Visit visit = new Visit(blobVisitor, markDirty);
        visit.visitBlobsComplex(state, (ComplexType)this.getType());
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (String facet : this.getFacets()) {
            CompositeType facetType = schemaManager.getFacet(facet);
            visit.visitBlobsComplex(state, (ComplexType)facetType);
        }
        if (this.getProxySchemas() != null) {
            for (Schema schema : this.getProxySchemas()) {
                visit.visitBlobsComplex(state, (ComplexType)schema);
            }
        }
    }

    public Lock getLock() {
        try {
            return this.getSession().getLockManager().getLock(this.getUUID());
        }
        catch (DocumentNotFoundException e) {
            return this.getDocumentLock();
        }
    }

    public Lock setLock(Lock lock) {
        if (lock == null) {
            throw new NullPointerException("Attempt to use null lock on: " + this.getUUID());
        }
        try {
            return this.getSession().getLockManager().setLock(this.getUUID(), lock);
        }
        catch (DocumentNotFoundException e) {
            return this.setDocumentLock(lock);
        }
    }

    public Lock removeLock(String owner) {
        try {
            return this.getSession().getLockManager().removeLock(this.getUUID(), owner);
        }
        catch (DocumentNotFoundException e) {
            return this.removeDocumentLock(owner);
        }
    }

    protected abstract Lock getDocumentLock();

    protected abstract Lock setDocumentLock(Lock var1);

    protected abstract Lock removeDocumentLock(String var1);

    protected class Visit {
        protected final Consumer<Document.BlobAccessor> blobVisitor;
        protected final Runnable markDirty;
        protected final Deque<String> path;

        public Visit(Consumer<Document.BlobAccessor> blobVisitor, Runnable markDirty) {
            this.blobVisitor = blobVisitor;
            this.markDirty = markDirty;
            this.path = new ArrayDeque<String>();
        }

        public void visitBlobsComplex(T state, ComplexType complexType) throws PropertyException {
            if (TypeConstants.isContentType((Type)complexType)) {
                this.blobVisitor.accept(new StateBlobAccessor(BaseDocument.this, this.path, state, this.markDirty));
                return;
            }
            for (Field field : complexType.getFields()) {
                this.visitBlobsField(state, field);
            }
        }

        protected void visitBlobsField(T state, Field field) throws PropertyException {
            Type type = field.getType();
            if (!type.isSimpleType()) {
                if (type.isComplexType()) {
                    String name = field.getName().getPrefixedName();
                    Object childState = BaseDocument.this.getChild(state, name, type);
                    if (childState != null) {
                        this.path.addLast(name);
                        this.visitBlobsComplex(childState, (ComplexType)type);
                        this.path.removeLast();
                    }
                } else {
                    Type fieldType = ((ListType)type).getFieldType();
                    if (!fieldType.isSimpleType()) {
                        String name = field.getName().getPrefixedName();
                        this.path.addLast(name);
                        int i = 0;
                        for (StateAccessor childState : BaseDocument.this.getChildAsList(state, name)) {
                            this.path.addLast(String.valueOf(i++));
                            this.visitBlobsComplex(childState, (ComplexType)fieldType);
                            this.path.removeLast();
                        }
                        this.path.removeLast();
                    }
                }
            }
        }
    }

    protected static class StateBlobAccessor
    implements Document.BlobAccessor {
        protected final Collection<String> path;
        protected final T state;
        protected final Runnable markDirty;
        final /* synthetic */ BaseDocument this$0;

        public StateBlobAccessor(Collection<String> path, T state, Runnable markDirty) {
            this.this$0 = this$0;
            this.path = path;
            this.state = state;
            this.markDirty = markDirty;
        }

        public String getXPath() {
            return StringUtils.join(this.path, (String)"/");
        }

        public Blob getBlob() throws PropertyException {
            return this.this$0.getValueBlob(this.state);
        }

        public void setBlob(Blob blob) throws PropertyException {
            this.markDirty.run();
            this.this$0.setValueBlob(this.state, blob);
        }
    }

    protected static class BlobWriteContext<T extends StateAccessor>
    implements Document.WriteContext {
        public final Map<BaseDocument<T>, List<Pair<T, Blob>>> blobWriteInfosPerDoc = new HashMap<BaseDocument<T>, List<Pair<T, Blob>>>();
        public final Set<String> xpaths = new HashSet<String>();

        protected BlobWriteContext() {
        }

        public void recordChange(String xpath) {
            this.xpaths.add(xpath);
        }

        public void recordBlob(T state, Blob blob, BaseDocument<T> doc) {
            List<Pair<T, Blob>> list = this.blobWriteInfosPerDoc.get(doc);
            if (list == null) {
                list = new ArrayList<Pair<T, Blob>>();
                this.blobWriteInfosPerDoc.put(doc, list);
            }
            list.add(Pair.of(state, (Object)blob));
        }

        public Set<String> getChanges() {
            return this.xpaths;
        }

        public void flush(Document baseDoc) {
            for (Map.Entry<BaseDocument<T>, List<Pair<T, Blob>>> en : this.blobWriteInfosPerDoc.entrySet()) {
                BaseDocument<StateAccessor> doc = en.getKey();
                for (Pair<T, Blob> pair : en.getValue()) {
                    StateAccessor state = (StateAccessor)pair.getLeft();
                    Blob blob = (Blob)pair.getRight();
                    doc.setValueBlob(state, blob);
                }
            }
            BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
            blobManager.notifyChanges(baseDoc, this.xpaths);
        }
    }
}

