/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public class Blobs {
    private Blobs() {
    }

    public static Blob createBlob(File file) throws IOException {
        return new FileBlob(file, null, null);
    }

    public static Blob createBlob(File file, String mimeType) throws IOException {
        return new FileBlob(file, mimeType, null);
    }

    public static Blob createBlob(File file, String mimeType, String encoding) throws IOException {
        return new FileBlob(file, mimeType, encoding);
    }

    public static Blob createBlob(File file, String mimeType, String encoding, String filename) throws IOException {
        return new FileBlob(file, mimeType, encoding, filename, null);
    }

    public static Blob createBlobWithExtension(String ext) throws IOException {
        return new FileBlob(ext);
    }

    public static Blob createBlob(InputStream in) throws IOException {
        return new FileBlob(in, null, null, null);
    }

    public static Blob createBlob(InputStream in, String mimeType) throws IOException {
        return new FileBlob(in, mimeType, null, null);
    }

    public static Blob createBlob(InputStream in, String mimeType, String encoding) throws IOException {
        return new FileBlob(in, mimeType, encoding, null);
    }

    public static Blob createBlob(InputStream in, String mimeType, String encoding, File tmpDir) throws IOException {
        return new FileBlob(in, mimeType, encoding, tmpDir);
    }

    public static Blob createBlob(byte[] bytes) {
        return new ByteArrayBlob(bytes, null, null);
    }

    public static Blob createBlob(byte[] bytes, String mimeType) throws IOException {
        return new ByteArrayBlob(bytes, mimeType, null);
    }

    public static Blob createBlob(byte[] bytes, String mimeType, String encoding) throws IOException {
        return new ByteArrayBlob(bytes, mimeType, encoding);
    }

    public static Blob createBlob(String string) {
        return new StringBlob(string);
    }

    public static Blob createBlob(String string, String mimeType) {
        return new StringBlob(string, mimeType);
    }

    public static Blob createBlob(String string, String mimeType, String encoding) {
        return new StringBlob(string, mimeType, encoding);
    }

    public static Blob createBlob(String string, String mimeType, String encoding, String filename) {
        return new StringBlob(string, mimeType, encoding, filename);
    }
}

