/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.jar.Manifest;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ReloadComponent
extends DefaultComponent
implements ReloadService {
    private static final Log log = LogFactory.getLog(ReloadComponent.class);
    protected static Bundle bundle;
    protected Long lastFlushed;

    public static BundleContext getBundleContext() {
        return bundle.getBundleContext();
    }

    public static Bundle getBundle() {
        return bundle;
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        bundle = context.getRuntimeContext().getBundle();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        bundle = null;
    }

    @Override
    public void reload() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting reload");
        }
        try {
            this.reloadProperties();
        }
        catch (IOException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
        this.triggerReloadWithNewTransaction("reload");
    }

    @Override
    public void reloadProperties() throws IOException {
        log.info((Object)"Reload runtime properties");
        Framework.getRuntime().reloadProperties();
    }

    @Override
    public void reloadRepository() {
        log.info((Object)"Reload repository");
        this.triggerReloadWithNewTransaction("reloadRepositories");
    }

    @Override
    public void reloadSeamComponents() {
        log.info((Object)"Reload Seam components");
        this.triggerReload("reloadSeamComponents");
    }

    @Override
    public void flush() {
        log.info((Object)"Flush caches");
        this.triggerReloadWithNewTransaction("flush");
    }

    @Override
    public void flushJaasCache() {
        log.info((Object)"Flush the JAAS cache");
        ((EventService)Framework.getLocalService(EventService.class)).sendEvent(new Event("usermanager", "user_changed", (Object)this, (Object)"Deployer"));
        this.setFlushedNow();
    }

    @Override
    public void flushSeamComponents() {
        log.info((Object)"Flush Seam components");
        this.triggerReload("flushSeamComponents");
    }

    @Override
    public String deployBundle(File file) throws BundleException {
        return this.deployBundle(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deployBundle(File file, boolean reloadResourceClasspath) throws BundleException {
        Bundle newBundle;
        String name = this.getOSGIBundleName(file);
        if (name == null) {
            log.error((Object)String.format("No Bundle-SymbolicName found in MANIFEST for jar at '%s'", file.getAbsolutePath()));
            return null;
        }
        String path = file.getAbsolutePath();
        log.info((Object)String.format("Before deploy bundle for file at '%s'\n%s", path, this.getRuntimeStatus()));
        if (reloadResourceClasspath) {
            URL url;
            try {
                url = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            Framework.reloadResourceLoader(Arrays.asList(url), null);
        }
        if ((newBundle = ReloadComponent.getBundleContext().installBundle(path)) == null) {
            throw new IllegalArgumentException("Could not find a valid bundle at path: " + path);
        }
        Transaction tx = TransactionHelper.suspendTransaction();
        try {
            newBundle.start();
        }
        finally {
            TransactionHelper.resumeTransaction((Transaction)tx);
        }
        log.info((Object)String.format("Deploy done for bundle with name '%s'.\n%s", newBundle.getSymbolicName(), this.getRuntimeStatus()));
        return newBundle.getSymbolicName();
    }

    @Override
    public void undeployBundle(File file, boolean reloadResources) throws BundleException {
        String name = this.getOSGIBundleName(file);
        String path = file.getAbsolutePath();
        if (name == null) {
            log.error((Object)String.format("No Bundle-SymbolicName found in MANIFEST for jar at '%s'", path));
            return;
        }
        this.undeployBundle(name);
        if (reloadResources) {
            URL url;
            try {
                url = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            Framework.reloadResourceLoader(null, Arrays.asList(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeployBundle(String bundleName) throws BundleException {
        if (bundleName == null) {
            return;
        }
        log.info((Object)String.format("Before undeploy bundle with name '%s'.\n%s", bundleName, this.getRuntimeStatus()));
        BundleContext ctx = ReloadComponent.getBundleContext();
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin srv = (PackageAdmin)ctx.getService(ref);
        try {
            for (Bundle b : srv.getBundles(bundleName, null)) {
                if (b == null || b.getState() != 32) continue;
                Transaction tx = TransactionHelper.suspendTransaction();
                try {
                    b.stop();
                    b.uninstall();
                }
                finally {
                    TransactionHelper.resumeTransaction((Transaction)tx);
                }
            }
        }
        finally {
            ctx.ungetService(ref);
        }
        log.info((Object)String.format("Undeploy done.\n%s", this.getRuntimeStatus()));
    }

    @Override
    public Long lastFlushed() {
        return this.lastFlushed;
    }

    protected void setFlushedNow() {
        this.lastFlushed = System.currentTimeMillis();
    }

    @Override
    @Deprecated
    public void installWebResources(File file) throws IOException {
        log.info((Object)"Install web resources");
        if (file.isDirectory()) {
            File war = new File(file, "web");
            if ((war = new File(war, "nuxeo.war")).isDirectory()) {
                FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
            } else {
                war = new File(file, "nuxeo.war");
                if (war.isDirectory()) {
                    FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
                }
            }
        } else if (file.isFile()) {
            File war = ReloadComponent.getWarDir();
            ZipUtils.unzip((String)"web/nuxeo.war", (File)file, (File)war);
            ZipUtils.unzip((String)"nuxeo.war", (File)file, (File)war);
        }
    }

    @Override
    public void runDeploymentPreprocessor() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start running deployment preprocessor");
        }
        String rootPath = Environment.getDefault().getHome().getAbsolutePath();
        File root = new File(rootPath);
        DeploymentPreprocessor processor = new DeploymentPreprocessor(root);
        processor.init();
        processor.predeploy();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment preprocessing done");
        }
    }

    protected static File getAppDir() {
        return Environment.getDefault().getConfig().getParentFile();
    }

    protected static File getWarDir() {
        return new File(ReloadComponent.getAppDir(), "nuxeo.war");
    }

    @Override
    public String getOSGIBundleName(File file) {
        Manifest mf = JarUtils.getManifest((File)file);
        if (mf == null) {
            return null;
        }
        String bundleName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bundleName == null) {
            return null;
        }
        int index = bundleName.indexOf(59);
        if (index > -1) {
            bundleName = bundleName.substring(0, index);
        }
        return bundleName;
    }

    protected String getRuntimeStatus() {
        StringBuilder msg = new StringBuilder();
        RuntimeService runtime = Framework.getRuntime();
        runtime.getStatusMessage(msg);
        return msg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerReload(String id) {
        final CountDownLatch reloadAchieved = new CountDownLatch(1);
        final Thread ownerThread = Thread.currentThread();
        try {
            final ServiceProvider next = DefaultServiceProvider.getProvider();
            DefaultServiceProvider.setProvider((ServiceProvider)new ServiceProvider(){

                public <T> T getService(Class<T> serviceClass) {
                    if (Thread.currentThread() != ownerThread) {
                        try {
                            reloadAchieved.await();
                        }
                        catch (InterruptedException cause) {
                            Thread.currentThread().interrupt();
                            throw new AssertionError(serviceClass + "was interruped while waiting for reloading", cause);
                        }
                    }
                    if (next != null) {
                        return (T)next.getService(serviceClass);
                    }
                    return (T)Framework.getRuntime().getService(serviceClass);
                }
            });
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("triggering reload(" + id + ")"));
                }
                ((EventService)Framework.getLocalService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", id, (Object)this, null));
                if (id.startsWith("flush") || "flushSeamComponents".equals(id)) {
                    this.setFlushedNow();
                }
            }
            finally {
                DefaultServiceProvider.setProvider((ServiceProvider)next);
            }
        }
        finally {
            reloadAchieved.countDown();
        }
    }

    protected void triggerReloadWithNewTransaction(String id) {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            throw new AssertionError((Object)"The calling transaction is marked rollback=");
        }
        if (TransactionHelper.isTransactionActive()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        try {
            try {
                this.triggerReload(id);
            }
            catch (RuntimeException cause) {
                TransactionHelper.setTransactionRollbackOnly();
                throw cause;
            }
        }
        finally {
            if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                boolean wasRollbacked = TransactionHelper.isTransactionMarkedRollback();
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
                if (wasRollbacked) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
            }
        }
    }
}

