/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntryAdaptor;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.PermissionDescriptor;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.ldap.DefaultLdapExceptionProcessor;
import org.nuxeo.ecm.directory.ldap.LDAPReference;
import org.nuxeo.ecm.directory.ldap.LDAPTreeReference;
import org.nuxeo.ecm.directory.ldap.LdapExceptionProcessor;
import org.nuxeo.ecm.directory.ldap.LdapScope;

@XObject(value="directory")
public class LDAPDirectoryDescriptor {
    public static final Log log = LogFactory.getLog(LDAPDirectoryDescriptor.class);
    public static final int defaultSearchScope = 1;
    public static final String defaultSearchClassesFilter = "(objectClass=*)";
    @XNode(value="@name")
    public String name;
    @XNode(value="server")
    public String serverName;
    @XNode(value="schema")
    public String schemaName;
    @XNode(value="searchBaseDn")
    public String searchBaseDn;
    @XNode(value="readOnly")
    public boolean readOnly = true;
    @XNode(value="cacheEntryName")
    public String cacheEntryName = null;
    @XNode(value="cacheEntryWithoutReferencesName")
    public String cacheEntryWithoutReferencesName = null;
    @XNode(value="negativeCaching")
    public Boolean negativeCaching;
    @XNodeMap(value="fieldMapping", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> fieldMapping = new HashMap<String, String>();
    public String[] searchClasses;
    public String searchClassesFilter;
    public String searchFilter;
    public int searchScope = 1;
    public String substringMatchType;
    @XNode(value="creationBaseDn")
    public String creationBaseDn;
    @XNodeList(value="creationClass", componentType=String.class, type=String[].class)
    public String[] creationClasses;
    @XNode(value="idField")
    public String idField;
    @XNode(value="rdnAttribute")
    public String rdnAttribute;
    @XNode(value="passwordField")
    public String passwordField;
    @XNode(value="passwordHashAlgorithm")
    public String passwordHashAlgorithm;
    @XNodeList(value="references/ldapReference", type=LDAPReference[].class, componentType=LDAPReference.class)
    private LDAPReference[] ldapReferences;
    @XNodeList(value="references/inverseReference", type=InverseReference[].class, componentType=InverseReference.class)
    private InverseReference[] inverseReferences;
    @XNodeList(value="references/ldapTreeReference", type=LDAPTreeReference[].class, componentType=LDAPTreeReference.class)
    private LDAPTreeReference[] ldapTreeReferences;
    @XNodeList(value="permissions/permission", type=PermissionDescriptor[].class, componentType=PermissionDescriptor.class)
    public PermissionDescriptor[] permissions = null;
    @XNode(value="emptyRefMarker")
    public String emptyRefMarker = "cn=emptyRef";
    @XNode(value="missingIdFieldCase")
    public String missingIdFieldCase = "unchanged";
    @XNode(value="idCase")
    public String idCase = "unchanged";
    @XNode(value="querySizeLimit")
    private int querySizeLimit = 200;
    @XNode(value="queryTimeLimit")
    private int queryTimeLimit = 0;
    @XNode(value="followReferrals")
    protected boolean followReferrals = true;
    protected EntryAdaptor entryAdaptor;
    @XNode(value="ldapExceptionHandler")
    protected Class<? extends LdapExceptionProcessor> exceptionProcessorClass;
    protected LdapExceptionProcessor exceptionProcessor;

    @XNode(value="entryAdaptor")
    public void setEntryAdaptor(EntryAdaptorDescriptor adaptorDescriptor) throws InstantiationException, IllegalAccessException {
        this.entryAdaptor = adaptorDescriptor.adaptorClass.newInstance();
        for (Map.Entry<String, String> paramEntry : adaptorDescriptor.parameters.entrySet()) {
            this.entryAdaptor.setParameter(paramEntry.getKey(), paramEntry.getValue());
        }
    }

    public String getRdnAttribute() {
        return this.rdnAttribute;
    }

    public String getCreationBaseDn() {
        return this.creationBaseDn;
    }

    public String[] getCreationClasses() {
        return this.creationClasses;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getIdCase() {
        return this.idCase;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSearchBaseDn() {
        return this.searchBaseDn;
    }

    @XNodeList(value="searchClass", componentType=String.class, type=String[].class)
    public void setSearchClasses(String[] searchClasses) {
        this.searchClasses = searchClasses;
        if (searchClasses == null) {
            this.searchClassesFilter = defaultSearchClassesFilter;
            return;
        }
        ArrayList<String> searchClassFilters = new ArrayList<String>();
        for (String searchClass : searchClasses) {
            searchClassFilters.add("(objectClass=" + searchClass + ')');
        }
        this.searchClassesFilter = StringUtils.join((Object[])searchClassFilters.toArray());
        if (searchClasses.length > 1) {
            this.searchClassesFilter = "(|" + this.searchClassesFilter + ')';
        }
    }

    public String[] getSearchClasses() {
        return this.searchClasses;
    }

    @XNode(value="searchFilter")
    public void setSearchFilter(String searchFilter) {
        if (searchFilter == null || searchFilter.equals(defaultSearchClassesFilter)) {
            this.searchFilter = null;
            return;
        }
        if (!searchFilter.startsWith("(") && !searchFilter.endsWith(")")) {
            searchFilter = '(' + searchFilter + ')';
        }
        this.searchFilter = searchFilter;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    @XNode(value="searchScope")
    public void setSearchScope(String searchScope) throws DirectoryException {
        if (null == searchScope) {
            this.searchScope = 1;
            return;
        }
        Integer scope = LdapScope.getIntegerScope(searchScope);
        if (null == scope) {
            throw new DirectoryException("Invalid search scope: " + searchScope + ". Valid options: object, onelevel, subtree");
        }
        this.searchScope = scope;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public String getSubstringMatchType() {
        return this.substringMatchType;
    }

    @XNode(value="substringMatchType")
    public void setSubstringMatchType(String substringMatchType) {
        if (substringMatchType == null) {
            this.substringMatchType = "subinitial";
        } else if ("subinitial".equals(substringMatchType) || "subfinal".equals(substringMatchType) || "subany".equals(substringMatchType)) {
            this.substringMatchType = substringMatchType;
        } else {
            log.error((Object)("Invalid substring match type: " + substringMatchType + ". Valid options: subinitial, subfinal, subany"));
            this.substringMatchType = "subinitial";
        }
    }

    public String getName() {
        return this.name;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getAggregatedSearchFilter() {
        if (this.searchFilter == null) {
            return this.searchClassesFilter;
        }
        return "(&" + this.searchClassesFilter + this.searchFilter + ')';
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public String getPasswordHashAlgorithmField() {
        return this.passwordHashAlgorithm;
    }

    public Map<String, String> getFieldMapping() {
        return this.fieldMapping;
    }

    public void setFieldMapping(Map<String, String> fieldMapping) {
        this.fieldMapping = fieldMapping;
    }

    public Reference[] getInverseReferences() {
        return this.inverseReferences;
    }

    public Reference[] getLdapReferences() {
        ArrayList<AbstractReference> refs = new ArrayList<AbstractReference>();
        if (this.ldapReferences != null) {
            refs.addAll(Arrays.asList(this.ldapReferences));
        }
        if (this.ldapTreeReferences != null) {
            refs.addAll(Arrays.asList(this.ldapTreeReferences));
        }
        return refs.toArray(new Reference[0]);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getEmptyRefMarker() {
        return this.emptyRefMarker;
    }

    public void setEmptyRefMarker(String emptyRefMarker) {
        this.emptyRefMarker = emptyRefMarker;
    }

    public int getQuerySizeLimit() {
        return this.querySizeLimit;
    }

    public void setQuerySizeLimit(int querySizeLimit) {
        this.querySizeLimit = querySizeLimit;
    }

    public void setQueryTimeLimit(int queryTimeLimit) {
        this.queryTimeLimit = queryTimeLimit;
    }

    public int getQueryTimeLimit() {
        return this.queryTimeLimit;
    }

    public EntryAdaptor getEntryAdaptor() {
        return this.entryAdaptor;
    }

    public LdapExceptionProcessor getExceptionProcessor() {
        if (this.exceptionProcessor == null) {
            if (this.exceptionProcessorClass == null) {
                this.exceptionProcessor = new DefaultLdapExceptionProcessor();
            } else {
                try {
                    this.exceptionProcessor = this.exceptionProcessorClass.newInstance();
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)"Unable to instanciate custom Exception handler", (Throwable)e);
                    this.exceptionProcessor = new DefaultLdapExceptionProcessor();
                }
            }
        }
        return this.exceptionProcessor;
    }

    @XObject(value="entryAdaptor")
    public static class EntryAdaptorDescriptor {
        @XNode(value="@class")
        public Class<? extends EntryAdaptor> adaptorClass;
        @XNodeMap(value="parameter", key="@name", type=HashMap.class, componentType=String.class)
        public Map<String, String> parameters;
    }
}

