/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.cache;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.convert.cache.ConversionCacheGCManager;
import org.nuxeo.ecm.core.convert.service.ConversionServiceImpl;

public class GCTask
implements Runnable {
    public boolean GCEnabled = true;
    private static final Log log = LogFactory.getLog(GCTask.class);

    @Override
    public void run() {
        log.debug((Object)"starting GC thread");
        while (this.GCEnabled) {
            ConversionCacheGCManager.gcIfNeeded();
            try {
                long gcInterval = ConversionServiceImpl.getGCIntervalInMinutes();
                if (gcInterval < 0L) {
                    log.debug((Object)("GC sleeps for " + -gcInterval));
                    Thread.sleep(-gcInterval);
                    continue;
                }
                log.debug((Object)("GC sleeps for " + gcInterval * 60L * 1000L));
                Thread.sleep(TimeUnit.MILLISECONDS.convert(gcInterval, TimeUnit.MINUTES));
            }
            catch (InterruptedException e) {
                this.GCEnabled = false;
                log.info((Object)"GCThread bruttaly interupted");
                Thread.currentThread().interrupt();
            }
        }
    }
}

