/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.Calendar;
import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.AddPermission", category="Document", label="Add Permission", description="Add Permission on the input document(s). Returns the document(s).", aliases={"Document.AddACL"})
public class AddPermission {
    public static final String ID = "Document.AddPermission";
    public static final String NOTIFY_KEY = "notify";
    public static final String COMMENT_KEY = "comment";
    @Context
    protected CoreSession session;
    @Param(name="username", alias={"user"}, description="ACE target user/group.")
    protected String user;
    @Param(name="permission", description="ACE permission.")
    String permission;
    @Param(name="acl", required=false, values={"local"}, description="ACL name.")
    String aclName = "local";
    @Param(name="begin", required=false, description="ACE begin date.")
    Calendar begin;
    @Param(name="end", required=false, description="ACE end date.")
    Calendar end;
    @Param(name="blockInheritance", required=false, description="Block inheritance or not.")
    boolean blockInheritance = false;
    @Param(name="notify", required=false, description="Notify the user or not")
    boolean notify = false;
    @Param(name="comment", required=false, description="Comment")
    String comment;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.addPermission(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        DocumentModel doc = this.session.getDocument(docRef);
        this.addPermission(doc);
        return doc;
    }

    protected void addPermission(DocumentModel doc) {
        ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put(NOTIFY_KEY, this.notify);
        contextData.put(COMMENT_KEY, this.comment);
        String creator = this.session.getPrincipal().getName();
        ACE ace = ACE.builder((String)this.user, (String)this.permission).creator(creator).begin(this.begin).end(this.end).contextData(contextData).build();
        boolean permissionChanged = false;
        if (this.blockInheritance) {
            permissionChanged = acp.blockInheritance(this.aclName, creator);
        }
        boolean bl = permissionChanged = acp.addACE(this.aclName, ace) || permissionChanged;
        if (permissionChanged) {
            doc.setACP(acp, true);
        }
    }
}

