/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deprecated
@Operation(id="Context.RunDocumentOperationInNewTx", category="Execution Flow", label="Run Document Chain in new Tx", description="Run an operation chain in a separate tx. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", deprecatedSince="6.0")
public class RunInNewTransaction {
    public static final String ID = "Context.RunDocumentOperationInNewTx";
    private static final Log log = LogFactory.getLog(RunInNewTransaction.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Context
    protected CoreSession session;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;
    @Param(name="rollbackGlobalOnError", required=false, values={"false"})
    protected boolean rollbackGlobalOnError = false;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters;
    @Param(name="timeout", required=false)
    protected Integer timeout = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() throws OperationException {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return;
        }
        TransactionHelper.commitOrRollbackTransaction();
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        int to = this.timeout == null ? 0 : this.timeout;
        TransactionHelper.startTransaction((int)to);
        boolean ok = false;
        try {
            OperationContext subctx = new OperationContext(this.session, vars);
            subctx.setInput(this.ctx.getInput());
            this.service.run(subctx, this.chainId, this.chainParameters);
            ok = true;
        }
        catch (OperationException e) {
            if (this.rollbackGlobalOnError) {
                throw e;
            }
            log.error((Object)("Error while executing operation " + this.chainId), (Throwable)e);
        }
        finally {
            if (!ok) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        if (!this.isolate) {
            for (String varName : vars.keySet()) {
                if (!this.ctx.getVars().containsKey(varName)) {
                    this.ctx.put(varName, vars.get(varName));
                    continue;
                }
                Object value = vars.get(varName);
                if (this.session != null && value != null && value instanceof DocumentModel) {
                    this.ctx.getVars().put(varName, this.session.getDocument(((DocumentModel)value).getRef()));
                    continue;
                }
                this.ctx.getVars().put(varName, value);
            }
        }
    }
}

