/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.select2;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.Locale;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.jaxrs.io.JsonHelper;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.ui.select2.common.Select2Common;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentIdCodec;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.jaxrs.coreiodelegate.RenderingContextWebUtils;
import org.nuxeo.runtime.api.Framework;

@Name(value="select2Actions")
@Scope(value=ScopeType.EVENT)
public class Select2ActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Select2ActionsBean.class);
    protected static final String SELECT2_RESOURCES_MARKER = "SELECT2_RESOURCES_MARKER";
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected transient CoreSession dedicatedSession = null;

    private static List<String> formatList(JSONArray array) {
        ArrayList<String> result = new ArrayList<String>();
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                result.add(array.getJSONObject(i).getString("displayLabel"));
            }
        }
        return result;
    }

    @Destroy
    public void destroy() {
        if (this.dedicatedSession != null) {
            this.dedicatedSession.close();
        }
    }

    private static Map<String, String> getDefaultFormattersMap(String suggestionFormatterName, String selectionFormatterName) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("suggestionFormatter", suggestionFormatterName);
        result.put("selectionFormatter", selectionFormatterName);
        return result;
    }

    protected static Map<String, String> getContextParameter(DocumentModel doc) {
        DocumentIdCodec documentIdCodec = new DocumentIdCodec();
        HashMap<String, String> contextParameters = new HashMap<String, String>();
        contextParameters.put("documentURL", documentIdCodec.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(doc)));
        return contextParameters;
    }

    public String encodeParametersForUserSuggestion(Widget widget, Map<String, Serializable> resolvedWidgetProperties) {
        Map<String, String> params = Select2ActionsBean.getDefaultFormattersMap("userEntryDefaultFormatter", "userSelectionDefaultFormatter");
        params.put("operationId", "UserGroup.Suggestion");
        return this.encodeParameters(widget, params, resolvedWidgetProperties);
    }

    public String encodeParametersForDirectory(Widget widget, Map<String, Serializable> resolvedWidgetProperties) {
        Map<String, String> params = Select2ActionsBean.getDefaultFormattersMap("dirEntryDefaultFormatter", "dirSelectionDefaultFormatter");
        params.put("operationId", "Directory.SuggestEntries");
        return this.encodeParameters(widget, params, resolvedWidgetProperties);
    }

    public String encodeParameters(Widget widget) {
        return this.encodeParameters(widget, null);
    }

    public String encodeParameters(Widget widget, Map<String, Serializable> resolvedWidgetProperties) {
        Map<String, String> params = Select2ActionsBean.getDefaultFormattersMap("docEntryDefaultFormatter", "docSelectionDefaultFormatter");
        params.put("operationId", "Repository.PageProvider");
        return this.encodeParameters(widget, params, resolvedWidgetProperties);
    }

    public String encodeParameters(Widget widget, Map<String, String> defaultParams, Map<String, Serializable> resolvedWidgetProperties) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)baos);
        try {
            JsonGenerator jg = JsonHelper.createJsonGenerator((OutputStream)out);
            jg.writeStartObject();
            jg.writeStringField("multiple", "" + this.isMultiSelection(widget));
            boolean isTranslated = widget.isTranslated();
            boolean readonly = !widget.getMode().equals("edit") && !widget.getMode().equals("create");
            jg.writeStringField("readonly", Boolean.toString(readonly));
            Map propertySet = null;
            propertySet = resolvedWidgetProperties != null ? resolvedWidgetProperties : widget.getProperties();
            boolean hasPlaceholder = false;
            boolean hasAjaxReRender = false;
            boolean hasWidth = false;
            boolean hasMinChars = false;
            for (Map.Entry entry : propertySet.entrySet()) {
                if (entry.getValue() == null) continue;
                if (defaultParams != null) {
                    defaultParams.remove(entry.getKey());
                }
                String value = ((Serializable)entry.getValue()).toString();
                if (((String)entry.getKey()).equals("placeholder")) {
                    hasPlaceholder = true;
                    if (isTranslated || Boolean.parseBoolean((String)propertySet.get("translatePlaceholder"))) {
                        value = this.messages.get(((Serializable)entry.getValue()).toString());
                    }
                } else if (((String)entry.getKey()).equals("ajaxReRender")) {
                    hasAjaxReRender = true;
                } else if (((String)entry.getKey()).equals("width")) {
                    hasWidth = true;
                } else if (((String)entry.getKey()).equals("minChars")) {
                    hasMinChars = true;
                }
                jg.writeStringField((String)entry.getKey(), value);
            }
            if (defaultParams != null) {
                for (Map.Entry<Object, Object> entry : defaultParams.entrySet()) {
                    jg.writeStringField((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!hasPlaceholder) {
                jg.writeStringField("placeholder", this.messages.get("label.vocabulary.selectValue"));
            }
            if (!hasWidth) {
                jg.writeStringField("width", "300");
            }
            if (!hasMinChars) {
                jg.writeNumberField("minChars", 3);
            }
            if (hasAjaxReRender) {
                jg.writeStringField("reRenderFunctionName", widget.getId() + "_reRender");
            }
            jg.writeEndObject();
            jg.flush();
            out.flush();
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            log.error((Object)"Could not encode parameters", (Throwable)e);
            return null;
        }
    }

    protected LayoutStore getLayoutStore() {
        return (LayoutStore)Framework.getService(LayoutStore.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JSONArray getMultipleDirectoryEntries(Object value, String directoryName, boolean localize, String keySeparator, boolean dbl10n, String labelFieldName) {
        JSONArray result = new JSONArray();
        if (value == null) {
            return result;
        }
        ArrayList<String> storedRefs = new ArrayList<String>();
        if (value instanceof List) {
            for (Object v : (List)value) {
                storedRefs.add(v.toString());
            }
        } else if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                storedRefs.add(v.toString());
            }
        }
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try {
            Directory directory = directoryService.getDirectory(directoryName);
            if (directory == null) {
                log.error((Object)("Could not find directory with name " + directoryName));
                return null;
            }
            try (Session session = directory.getSession();){
                String schemaName = directory.getSchema();
                SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
                Schema schema = schemaManager.getSchema(schemaName);
                java.util.Locale locale = Locale.instance();
                String label = Select2Common.getLabelFieldName(schema, dbl10n, labelFieldName, locale.getLanguage());
                for (String ref : storedRefs) {
                    JSONObject obj = this.resolveDirectoryEntry(ref, keySeparator, session, schema, label, localize, dbl10n);
                    if (obj == null) continue;
                    result.add((Object)obj);
                }
                JSONArray jSONArray = result;
                return jSONArray;
            }
        }
        catch (DirectoryException de) {
            log.error((Object)("An error occured while obtaining directory " + directoryName), (Throwable)de);
            return result;
        }
    }

    protected JSONArray getMultipleUserReference(Object value, boolean prefixed, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, boolean hideIcon) {
        if (value == null) {
            return null;
        }
        JSONArray result = new JSONArray();
        ArrayList<String> storedRefs = new ArrayList<String>();
        if (value instanceof List) {
            for (Object v : (List)value) {
                storedRefs.add(v.toString());
            }
        } else if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                storedRefs.add(v.toString());
            }
        }
        for (String ref : storedRefs) {
            JSONObject resolved = this.getSingleUserReference(ref, prefixed, firstLabelField, secondLabelField, thirdLabelField, hideFirstLabel, hideSecondLabel, hideThirdLabel, displayEmailInSuggestion, hideIcon);
            if (resolved == null || resolved.isEmpty()) continue;
            result.add((Object)resolved);
        }
        return result;
    }

    protected CoreSession getRepositorySession(String repoName) {
        if (repoName == null || repoName.isEmpty()) {
            RepositoryManager rm = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            repoName = rm.getDefaultRepositoryName();
        }
        if (this.documentManager != null && this.documentManager.getRepositoryName().equals(repoName)) {
            return this.documentManager;
        }
        this.dedicatedSession = CoreInstance.openCoreSession((String)repoName);
        return this.dedicatedSession;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JSONObject getSingleDirectoryEntry(String storedReference, String directoryName, boolean localize, String keySeparator, boolean dbl10n, String labelFieldName) {
        if (storedReference == null) return null;
        if (storedReference.isEmpty()) {
            return null;
        }
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try {
            Directory directory = directoryService.getDirectory(directoryName);
            if (directory == null) {
                log.error((Object)("Could not find directory with name " + directoryName));
                return null;
            }
            try (Session session = directory.getSession();){
                JSONObject obj;
                String schemaName = directory.getSchema();
                SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
                Schema schema = schemaManager.getSchema(schemaName);
                java.util.Locale locale = Locale.instance();
                String label = Select2Common.getLabelFieldName(schema, dbl10n, labelFieldName, locale.getLanguage());
                JSONObject jSONObject = obj = this.resolveDirectoryEntry(storedReference, keySeparator, session, schema, label, localize, dbl10n);
                return jSONObject;
            }
        }
        catch (DirectoryException de) {
            log.error((Object)("An error occured while obtaining directory " + directoryName), (Throwable)de);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JSONObject getSingleUserReference(String storedReference, boolean prefixed, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, boolean hideIcon) {
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        DirectoryService dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        JSONObject obj = new JSONObject();
        if (storedReference == null) return null;
        if (storedReference.isEmpty()) {
            return null;
        }
        DocumentModel user = null;
        DocumentModel group = null;
        Directory userDir = dirService.getDirectory(userManager.getUserDirectoryName());
        if (prefixed) {
            if (storedReference.startsWith("user:")) {
                user = userManager.getUserModel(storedReference.substring("user:".length()));
            } else {
                if (!storedReference.startsWith("group:")) {
                    log.warn((Object)("User reference is prefixed but prefix was not found on reference: " + storedReference));
                    return this.createNotFoundEntry(storedReference);
                }
                group = userManager.getGroupModel(storedReference.substring("group:".length()));
            }
        } else {
            user = userManager.getUserModel(storedReference);
            if (user == null) {
                group = userManager.getGroupModel(storedReference);
            }
        }
        if (user == null) {
            if (group == null) {
                log.warn((Object)("Could not resolve user or group reference: " + storedReference));
                return this.createNotFoundEntry(storedReference);
            }
            Schema schema = schemaManager.getSchema(userManager.getGroupSchemaName());
            Iterator userId = schema.getFields().iterator();
            while (true) {
                if (!userId.hasNext()) {
                    String groupId = group.getId();
                    Select2Common.computeGroupLabel(obj, groupId, userManager.getGroupLabelField(), hideFirstLabel);
                    obj.put((Object)"id", (Object)groupId);
                    obj.put((Object)"type", (Object)"GROUP_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("group:" + groupId));
                    Select2Common.computeUserGroupIcon(obj, hideIcon);
                    return obj;
                }
                Field field = (Field)userId.next();
                QName fieldName = field.getName();
                String key = fieldName.getLocalName();
                Serializable value = group.getPropertyValue(fieldName.getPrefixedName());
                obj.element(key, (Object)value);
            }
        }
        Schema schema = schemaManager.getSchema(userManager.getUserSchemaName());
        Iterator iterator = schema.getFields().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String userId = user.getId();
                obj.put((Object)"id", (Object)userId);
                obj.put((Object)"type", (Object)"USER_TYPE");
                obj.put((Object)"prefixed_id", (Object)("user:" + userId));
                Select2Common.computeUserLabel(obj, firstLabelField, secondLabelField, thirdLabelField, hideFirstLabel, hideSecondLabel, hideThirdLabel, displayEmailInSuggestion, userId);
                Select2Common.computeUserGroupIcon(obj, hideIcon);
                return obj;
            }
            Field field = (Field)iterator.next();
            QName fieldName = field.getName();
            String key = fieldName.getLocalName();
            Serializable value = user.getPropertyValue(fieldName.getPrefixedName());
            if (key.equals(userDir.getPasswordField())) continue;
            obj.element(key, (Object)value);
        }
    }

    public boolean isMultiSelection(Widget widget) {
        WidgetTypeConfiguration conf;
        WidgetTypeDefinition wtDef;
        String wtCat = widget.getTypeCategory();
        if (StringUtils.isBlank((String)wtCat)) {
            wtCat = "jsf";
        }
        if ((wtDef = this.getLayoutStore().getWidgetTypeDefinition(wtCat, widget.getType())) != null && (conf = wtDef.getConfiguration()) != null) {
            return conf.isList();
        }
        return false;
    }

    public boolean mustIncludeResources() {
        PhaseId currentPhaseId;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (currentPhaseId = FacesLifecycle.getPhaseId()).equals(PhaseId.RENDER_RESPONSE)) {
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            if (request.getAttribute(SELECT2_RESOURCES_MARKER) != null) {
                return false;
            }
            request.setAttribute(SELECT2_RESOURCES_MARKER, (Object)"done");
            return true;
        }
        return false;
    }

    protected JSONObject createNotFoundEntry(String id) {
        return this.createEntryWithWarnMessage(id, "entry not found");
    }

    protected JSONObject createEntryWithWarnMessage(String label, String warnMessage) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)label);
        obj.put((Object)"absoluteLabel", (Object)label);
        obj.put((Object)"displayLabel", (Object)label);
        obj.put((Object)"warn_message", (Object)warnMessage);
        return obj;
    }

    protected JSONObject resolveDirectoryEntry(String storedReference, String keySeparator, Session session, Schema schema, String label, boolean localize, boolean dbl10n) {
        String entryId;
        DocumentModel result;
        if (storedReference == null || storedReference.isEmpty()) {
            log.trace((Object)"No reference provided ");
            return null;
        }
        if (keySeparator == null || keySeparator.isEmpty()) {
            keySeparator = "/";
        }
        if ((result = session.getEntry(entryId = storedReference.substring(storedReference.lastIndexOf(keySeparator) + 1, storedReference.length()))) == null) {
            log.warn((Object)("Unable to resolve entry " + storedReference));
            return this.createNotFoundEntry(storedReference);
        }
        JSONObject obj = new JSONObject();
        for (Field field : schema.getFields()) {
            QName fieldName = field.getName();
            String key = fieldName.getLocalName();
            Serializable value = result.getPropertyValue(fieldName.getPrefixedName());
            if (label.equals(key)) {
                if (localize && !dbl10n) {
                    value = (Serializable)((Object)this.messages.get(value));
                }
                obj.element("displayLabel", (Object)value);
                obj.element("absoluteLabel", (Object)this.getParentAbsoluteLabel(storedReference, keySeparator, session, fieldName, localize, dbl10n));
                continue;
            }
            obj.element(key, (Object)value);
        }
        if (obj.containsKey((Object)"obsolete") && obj.getInt("obsolete") > 0) {
            obj.element("warn_message", (Object)this.messages.get("label.vocabulary.entry.obsolete"));
        }
        obj.element("computedId", (Object)storedReference);
        return obj;
    }

    protected String getParentAbsoluteLabel(String entryId, String keySeparator, Session session, QName labelFieldName, boolean localize, boolean dbl10n) throws PropertyException {
        String[] split = entryId.split(keySeparator);
        String result = "";
        for (int i = 0; i < split.length; ++i) {
            DocumentModel entry = session.getEntry(split[i]);
            if (entry == null) continue;
            Serializable value = entry.getPropertyValue(labelFieldName.getPrefixedName());
            if (localize && !dbl10n) {
                value = (Serializable)((Object)this.messages.get(value));
            }
            result = result + (i > 0 ? "/" : "") + value;
        }
        return result;
    }

    public String resolveMultipleDirectoryEntries(Object value, String directoryName, boolean localize, String keySeparator, boolean dbl10n, String labelFieldName) {
        JSONArray result = this.getMultipleDirectoryEntries(value, directoryName, localize, keySeparator, dbl10n, labelFieldName);
        if (result != null) {
            return result.toString();
        }
        return "[]";
    }

    public List<String> resolveMultipleDirectoryEntryLabels(Object value, String directoryName, boolean localize, String keySeparator, boolean dbl10n, String labelFieldName) {
        return Select2ActionsBean.formatList(this.getMultipleDirectoryEntries(value, directoryName, localize, keySeparator, dbl10n, labelFieldName));
    }

    public List<String> resolveMultipleReferenceLabels(Object value, String repo, String operationName, String idProperty, String label) {
        ArrayList<String> result = new ArrayList<String>();
        if (value == null) {
            return result;
        }
        ArrayList<String> storedRefs = new ArrayList<String>();
        if (value instanceof List) {
            for (Object v : (List)value) {
                storedRefs.add(v.toString());
            }
        } else if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                storedRefs.add(v.toString());
            }
        }
        for (String ref : storedRefs) {
            DocumentModel doc = this.resolveReference(repo, ref, operationName, idProperty);
            if (doc != null) {
                if (label != null && !label.isEmpty()) {
                    Serializable val = doc.getPropertyValue(label);
                    if (val == null) {
                        result.add("");
                        continue;
                    }
                    result.add(val.toString());
                    continue;
                }
                result.add(doc.getTitle());
                continue;
            }
            result.add(this.messages.get("label.documentSuggestion.docNotFoundOrNotVisible") + "(" + ref + ")");
        }
        return result;
    }

    public String resolveMultipleReferences(Object value, String repo, String operationName, String idProperty, String schemaNames) throws IOException {
        if (value == null) {
            return "[]";
        }
        ArrayList<String> storedRefs = new ArrayList<String>();
        if (value instanceof List) {
            for (Object v : (List)value) {
                storedRefs.add(v.toString());
            }
        } else if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                storedRefs.add(v.toString());
            }
        }
        if (storedRefs.isEmpty()) {
            return "[]";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)baos);
        JsonGenerator jg = JsonHelper.createJsonGenerator((OutputStream)out);
        jg.writeStartArray();
        DocumentModelJsonWriter writer = this.getDocumentModelWriter(schemaNames);
        for (String ref : storedRefs) {
            DocumentModel doc = this.resolveReference(repo, ref, operationName, idProperty);
            if (doc == null) {
                this.processDocumentNotFound(ref, jg);
                continue;
            }
            writer.write((Object)doc, jg);
            jg.flush();
        }
        jg.writeEndArray();
        out.flush();
        String json = new String(baos.toByteArray(), "UTF-8");
        if (json.isEmpty()) {
            return "[]";
        }
        if (json.startsWith("[") && !json.endsWith("]")) {
            json = json + "]";
        }
        return json;
    }

    public String resolveMultipleUserReference(Object value, boolean prefixed, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, boolean hideIcon) {
        if (value == null) {
            return "[]";
        }
        JSONArray result = new JSONArray();
        ArrayList<String> storedRefs = new ArrayList<String>();
        if (value instanceof List) {
            for (Object v : (List)value) {
                storedRefs.add(v.toString());
            }
        } else if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                storedRefs.add(v.toString());
            }
        }
        for (String ref : storedRefs) {
            String resolved = this.resolveSingleUserReference(ref, prefixed, firstLabelField, secondLabelField, thirdLabelField, hideFirstLabel, hideSecondLabel, hideThirdLabel, displayEmailInSuggestion, hideIcon);
            if (resolved == null || resolved.isEmpty()) continue;
            result.add((Object)resolved);
        }
        return result.toString();
    }

    public List<String> resolveMultipleUserReferenceLabels(Object value, boolean prefixed, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, boolean hideIcon) {
        return Select2ActionsBean.formatList(this.getMultipleUserReference(value, prefixed, firstLabelField, secondLabelField, thirdLabelField, hideFirstLabel, hideSecondLabel, hideThirdLabel, displayEmailInSuggestion, hideIcon));
    }

    protected DocumentModel resolveReference(String repo, String storedReference, String operationName, String idProperty) {
        if (storedReference == null || storedReference.isEmpty()) {
            log.trace((Object)"No reference provided ");
            return null;
        }
        DocumentModel doc = null;
        try {
            CoreSession session = this.getRepositorySession(repo);
            if (session == null) {
                log.error((Object)("Unable to get CoreSession for repo " + repo));
                return null;
            }
            if (operationName == null || operationName.isEmpty()) {
                Object ref = null;
                if (idProperty != null && !idProperty.isEmpty()) {
                    String query = " select * from Document where " + idProperty + "='" + storedReference + "'";
                    DocumentModelList docs = session.query(query);
                    if (docs.size() > 0) {
                        return (DocumentModel)docs.get(0);
                    }
                    log.warn((Object)("Unable to resolve doc using property " + idProperty + " and value " + storedReference));
                    return null;
                }
                ref = storedReference.startsWith("/") ? new PathRef(storedReference) : new IdRef(storedReference);
                if (session.exists((DocumentRef)ref)) {
                    doc = session.getDocument((DocumentRef)ref);
                } else {
                    log.warn((Object)("Unable to resolve reference on " + ref));
                }
            } else {
                AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
                OperationContext ctx = new OperationContext(session);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("value", storedReference);
                params.put("xpath", idProperty);
                params.put("lang", Locale.instance().getLanguage());
                Object result = as.run(ctx, operationName, params);
                if (result == null) {
                    log.warn((Object)("Unable to resolve reference " + storedReference + " using property " + idProperty + " and operation" + operationName));
                    doc = null;
                } else if (result instanceof DocumentModel) {
                    doc = (DocumentModel)result;
                } else if (result instanceof DocumentModelList) {
                    DocumentModelList docs = (DocumentModelList)result;
                    if (docs.size() > 0) {
                        doc = (DocumentModel)docs.get(0);
                    } else {
                        log.warn((Object)"No document found");
                    }
                }
            }
            return doc;
        }
        catch (InvalidChainException e) {
            log.error((Object)"Unable to resolve reference", (Throwable)e);
        }
        catch (OperationException e) {
            log.error((Object)"Unable to resolve reference", (Throwable)e);
        }
        return doc;
    }

    protected void processDocumentNotFound(String id, JsonGenerator jg) {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        try {
            jg.writeStartObject();
            jg.writeStringField("id", id);
            jg.writeStringField("title", this.messages.get("label.documentSuggestion.docNotFoundOrNotVisible"));
            jg.writeStringField("warn_message", id);
            jg.writeEndObject();
            jg.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error while writing not found message ", (Throwable)e);
        }
    }

    public String resolveSingleDirectoryEntry(String storedReference, String directoryName, boolean localize, String keySeparator, boolean dbl10n, String labelFieldName) {
        JSONObject result = this.getSingleDirectoryEntry(storedReference, directoryName, localize, keySeparator, dbl10n, labelFieldName);
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    public String resolveSingleDirectoryEntryLabel(String storedReference, String directoryName, boolean localize, String keySeparator, boolean dbl10n, String labelFieldName) {
        JSONObject obj = this.getSingleDirectoryEntry(storedReference, directoryName, localize, keySeparator, dbl10n, labelFieldName);
        if (obj == null) {
            return "";
        }
        return obj.optString("displayLabel");
    }

    public String resolveSingleReference(String storedReference, String repo, String operationName, String idProperty, String schemaNames) throws IOException {
        DocumentModel doc = this.resolveReference(repo, storedReference, operationName, idProperty);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)baos);
        JsonGenerator jg = JsonHelper.createJsonGenerator((OutputStream)out);
        if (doc == null) {
            this.processDocumentNotFound(storedReference, jg);
        } else {
            this.getDocumentModelWriter(schemaNames).write((Object)doc, jg);
        }
        jg.flush();
        return new String(baos.toByteArray(), "UTF-8");
    }

    public String resolveSingleReferenceLabel(String storedReference, String repo, String operationName, String idProperty, String label) {
        DocumentModel doc = this.resolveReference(repo, storedReference, operationName, idProperty);
        if (doc == null) {
            return this.messages.get("label.documentSuggestion.docNotFoundOrNotVisible") + "(" + doc + ")";
        }
        if (label != null && !label.isEmpty()) {
            Serializable val = doc.getPropertyValue(label);
            if (val == null) {
                return "";
            }
            return val.toString();
        }
        return doc.getTitle();
    }

    public String resolveSingleUserReference(String storedReference, boolean prefixed, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, boolean hideIcon) {
        JSONObject result = this.getSingleUserReference(storedReference, prefixed, firstLabelField, secondLabelField, thirdLabelField, hideFirstLabel, hideSecondLabel, hideThirdLabel, displayEmailInSuggestion, hideIcon);
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    public String resolveUserReferenceLabel(String storedReference, boolean prefixed, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, boolean hideIcon) {
        JSONObject obj = this.getSingleUserReference(storedReference, prefixed, firstLabelField, secondLabelField, thirdLabelField, hideFirstLabel, hideSecondLabel, hideThirdLabel, displayEmailInSuggestion, hideIcon);
        if (obj == null) {
            return "";
        }
        return obj.optString("displayLabel");
    }

    protected DocumentModelJsonWriter getDocumentModelWriter(String schemaNames) {
        MarshallerRegistry registry = (MarshallerRegistry)Framework.getService(MarshallerRegistry.class);
        String[] schemas = Select2Common.getSchemas(schemaNames);
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        RenderingContext ctx = RenderingContextWebUtils.getBuilder((ServletRequest)request).properties(schemas).enrichDoc(new String[]{"documentURL"}).get();
        return (DocumentModelJsonWriter)registry.getInstance(ctx, DocumentModelJsonWriter.class);
    }
}

