/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;
import org.nuxeo.runtime.api.Framework;

public class LazyBinary
extends Binary {
    private static final long serialVersionUID = 1L;
    protected boolean hasLength;
    protected transient CachingBinaryManager cbm;

    public LazyBinary(String digest, String repoName, CachingBinaryManager cbm) {
        super(digest, repoName);
        this.cbm = cbm;
    }

    protected CachingBinaryManager getCachingBinaryManager() {
        if (this.cbm == null) {
            if (this.blobProviderId == null) {
                throw new UnsupportedOperationException("Cannot find binary manager, no blob provider id");
            }
            BlobManager bm = (BlobManager)Framework.getService(BlobManager.class);
            BlobProvider bp = bm.getBlobProvider(this.blobProviderId);
            this.cbm = (CachingBinaryManager)bp.getBinaryManager();
        }
        return this.cbm;
    }

    @Override
    public InputStream getStream() throws IOException {
        File file = this.getFile();
        return file == null ? null : new FileInputStream(file);
    }

    @Override
    public File getFile() {
        if (this.file == null) {
            try {
                this.file = this.getCachingBinaryManager().getFile(this.digest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.file != null) {
                this.length = this.file.length();
                this.hasLength = true;
            }
        }
        return this.file;
    }

    @Override
    public long getLength() {
        if (!this.hasLength) {
            Long len;
            try {
                len = this.getCachingBinaryManager().getLength(this.digest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.length = len == null ? 0L : len;
            this.hasLength = true;
        }
        return this.length;
    }
}

