/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.security.Principal;
import java.util.Arrays;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class LockSecurityPolicy
extends AbstractSecurityPolicy {
    @Override
    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        if (resolvedPermissions == null || !Arrays.asList(resolvedPermissions).contains("Write")) {
            return access;
        }
        String username = principal.getName();
        Lock lock = doc.getLock();
        if (lock != null && !username.equals(lock.getOwner())) {
            access = Access.DENY;
        }
        return access;
    }

    @Override
    public boolean isRestrictingPermission(String permission) {
        assert (permission.equals("Browse"));
        return false;
    }

    @Override
    public boolean isExpressibleInQuery() {
        return true;
    }

    @Override
    public SQLQuery.Transformer getQueryTransformer() {
        return SQLQuery.Transformer.IDENTITY;
    }
}

