/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class UpdateACEStatusWork
extends AbstractWork {
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final String ID = "updateACEStatus";
    public static final String CATEGORY = "updateACEStatus";
    public static final String QUERY = "SELECT ecm:uuid FROM Document WHERE (ecm:acl/*1/status = 0 AND ecm:acl/*1/begin <= TIMESTAMP '%s') OR (ecm:acl/*1/status = 1 AND ecm:acl/*1/end <= TIMESTAMP '%s')";
    public static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected int batchSize = 20;

    public UpdateACEStatusWork() {
        super("updateACEStatus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        this.setStatus("Updating ACE status");
        this.initSession();
        Date now = new Date();
        String formattedDate = FORMATTER.format(now);
        ArrayList<String> docIds = new ArrayList<String>();
        try (IterableQueryResult result = this.session.queryAndFetch(String.format(QUERY, formattedDate, formattedDate), "NXQL", new Object[0]);){
            for (Map map : result) {
                docIds.add((String)map.get("ecm:uuid"));
            }
        }
        int acpUpdatedCount = 0;
        ArrayList<DocumentRef> processedDocIds = new ArrayList<DocumentRef>();
        for (String docId : docIds) {
            try {
                IdRef ref = new IdRef(docId);
                ACP acp = this.session.getACP((DocumentRef)ref);
                this.session.setACP((DocumentRef)ref, acp, true);
                processedDocIds.add((DocumentRef)ref);
                if (++acpUpdatedCount % this.batchSize != 0) continue;
                this.fireACEStatusUpdatedEvent(processedDocIds);
                this.commitOrRollbackTransaction();
                this.startTransaction();
                processedDocIds.clear();
            }
            catch (TransactionRuntimeException e) {
                if (e.getMessage().contains("Transaction timeout")) {
                    this.batchSize = 1;
                }
                throw e;
            }
        }
        this.fireACEStatusUpdatedEvent(processedDocIds);
        this.setStatus(null);
    }

    protected void fireACEStatusUpdatedEvent(List<DocumentRef> docRefs) {
        EventContextImpl eventContext = new EventContextImpl(this.session, this.session.getPrincipal());
        eventContext.setProperty("documentRefs", (Serializable)((Object)docRefs));
        eventContext.setProperty("repositoryName", (Serializable)((Object)this.session.getRepositoryName()));
        ((EventService)Framework.getService(EventService.class)).fireEvent("ACEStatusUpdated", (EventContext)eventContext);
    }

    public String getCategory() {
        return "updateACEStatus";
    }

    public String getTitle() {
        return "Updating ACE status";
    }

    public int getRetryCount() {
        return 10;
    }
}

