/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.trash.TrashInfo;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class TrashServiceImpl
extends DefaultComponent
implements TrashService {
    private static final Log log = LogFactory.getLog(TrashServiceImpl.class);
    protected static final Pattern TRASHED_PATTERN = Pattern.compile("(.*)\\._[0-9]{13,}_\\.trashed");
    protected static final Pattern COLLISION_PATTERN = Pattern.compile("(.*)\\.[0-9]{13,}");

    @Override
    public boolean folderAllowsDelete(DocumentModel folder) {
        return folder.getCoreSession().hasPermission(folder.getRef(), "RemoveChildren");
    }

    @Override
    public boolean checkDeletePermOnParents(List<DocumentModel> docs) {
        if (docs.isEmpty()) {
            return false;
        }
        CoreSession session = docs.get(0).getCoreSession();
        for (DocumentModel doc : docs) {
            if (!session.hasPermission(doc.getParentRef(), "RemoveChildren")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDelete(List<DocumentModel> docs, Principal principal, boolean checkProxies) {
        if (docs.isEmpty()) {
            return false;
        }
        TrashInfo info = this.getInfo(docs, principal, checkProxies, false);
        return info.docs.size() > 0;
    }

    @Override
    public boolean canPurgeOrUndelete(List<DocumentModel> docs, Principal principal) {
        if (docs.isEmpty()) {
            return false;
        }
        TrashInfo info = this.getInfo(docs, principal, false, true);
        return info.docs.size() == docs.size();
    }

    public boolean canUndelete(List<DocumentModel> docs) {
        if (docs.isEmpty()) {
            return false;
        }
        TrashInfo info = this.getInfo(docs, null, false, true);
        return info.docs.size() > 0;
    }

    protected TrashInfo getInfo(List<DocumentModel> docs, Principal principal, boolean checkProxies, boolean checkDeleted) {
        TrashInfo info = new TrashInfo();
        info.docs = new ArrayList<DocumentModel>(docs.size());
        if (docs.isEmpty()) {
            return info;
        }
        CoreSession session = docs.get(0).getCoreSession();
        for (DocumentModel doc : docs) {
            if (checkDeleted && !"deleted".equals(doc.getCurrentLifeCycleState())) {
                ++info.forbidden;
                continue;
            }
            if (doc.getParentRef() == null) {
                if (doc.isVersion() && !session.getProxies(doc.getRef(), null).isEmpty()) {
                    ++info.forbidden;
                    continue;
                }
            } else if (!session.hasPermission(doc.getParentRef(), "RemoveChildren")) {
                ++info.forbidden;
                continue;
            }
            if (!session.hasPermission(doc.getRef(), "Remove")) {
                ++info.forbidden;
                continue;
            }
            if (checkProxies && doc.isProxy()) {
                ++info.proxies;
                continue;
            }
            if (doc.isLocked()) {
                String locker = TrashServiceImpl.getDocumentLocker(doc);
                if (principal == null || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator() || principal.getName().equals(locker)) {
                    info.docs.add(doc);
                    continue;
                }
                ++info.locked;
                continue;
            }
            info.docs.add(doc);
        }
        return info;
    }

    protected static String getDocumentLocker(DocumentModel doc) {
        Lock lock = doc.getLockInfo();
        return lock == null ? null : lock.getOwner();
    }

    @Override
    public TrashInfo getTrashInfo(List<DocumentModel> docs, Principal principal, boolean checkProxies, boolean checkDeleted) {
        TrashInfo info = this.getInfo(docs, principal, checkProxies, checkDeleted);
        Collections.sort(info.docs, PathComparator.INSTANCE);
        LinkedList<DocumentModel> roots = new LinkedList<DocumentModel>();
        info.rootPaths = new HashSet<Path>();
        info.rootRefs = new LinkedList<DocumentRef>();
        info.rootParentRefs = new HashSet<DocumentRef>();
        Path previousPath = null;
        for (DocumentModel doc : info.docs) {
            if (previousPath != null && previousPath.isPrefixOf(doc.getPath())) continue;
            roots.add(doc);
            Path path = doc.getPath();
            info.rootPaths.add(path);
            info.rootRefs.add(doc.getRef());
            if (doc.getParentRef() != null) {
                info.rootParentRefs.add(doc.getParentRef());
            }
            previousPath = path;
        }
        return info;
    }

    @Override
    public DocumentModel getAboveDocument(DocumentModel doc, Set<Path> rootPaths) {
        CoreSession session = doc.getCoreSession();
        while (TrashServiceImpl.underOneOf(doc.getPath(), rootPaths)) {
            doc = session.getParentDocument(doc.getRef());
        }
        return doc;
    }

    protected static boolean underOneOf(Path testedPath, Set<Path> paths) {
        for (Path path : paths) {
            if (path == null || !path.isPrefixOf(testedPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trashDocuments(List<DocumentModel> docs) {
        if (docs.isEmpty()) {
            return;
        }
        CoreSession session = docs.get(0).getCoreSession();
        for (DocumentModel doc : docs) {
            DocumentRef docRef = doc.getRef();
            if (session.getAllowedStateTransitions(docRef).contains("delete") && !doc.isProxy()) {
                if (!session.canRemoveDocument(docRef)) {
                    throw new DocumentSecurityException("User " + session.getPrincipal().getName() + " does not have the permission to remove the document " + doc.getId() + " (" + doc.getPath() + ")");
                }
                this.trashDocument(session, doc);
                continue;
            }
            if (session.getCurrentLifeCycleState(docRef).equals("deleted")) {
                log.warn((Object)("Document " + doc.getId() + " of type " + doc.getType() + " in state " + doc.getCurrentLifeCycleState() + " is already in state " + "deleted" + ", nothing to do"));
                return;
            }
            log.warn((Object)("Document " + doc.getId() + " of type " + doc.getType() + " in state " + doc.getCurrentLifeCycleState() + " does not support transition " + "delete" + ", it will be deleted immediately"));
            session.removeDocument(docRef);
        }
        session.save();
    }

    @Override
    public void purgeDocuments(CoreSession session, List<DocumentRef> docRefs) {
        if (docRefs.isEmpty()) {
            return;
        }
        session.removeDocuments(docRefs.toArray(new DocumentRef[docRefs.size()]));
        session.save();
    }

    @Override
    public Set<DocumentRef> undeleteDocuments(List<DocumentModel> docs) {
        HashSet<DocumentRef> undeleted = new HashSet<DocumentRef>();
        if (docs.isEmpty()) {
            return undeleted;
        }
        CoreSession session = docs.get(0).getCoreSession();
        Set<DocumentRef> docRefs = this.undeleteDocumentList(session, docs);
        undeleted.addAll(docRefs);
        for (DocumentRef docRef : docRefs) {
            this.undeleteAncestors(session, docRef, undeleted);
        }
        session.save();
        HashSet<DocumentRef> parentRefs = new HashSet<DocumentRef>();
        for (DocumentRef docRef : undeleted) {
            parentRefs.add(session.getParentDocumentRef(docRef));
        }
        for (DocumentModel doc : docs) {
            if (!doc.isFolder()) continue;
            this.notifyEvent(session, "documentUndeleted", doc);
        }
        return parentRefs;
    }

    protected void notifyEvent(CoreSession session, String eventId, DocumentModel doc) {
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), doc);
        ctx.setCategory("eventDocumentCategory");
        ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)session.getSessionId()));
        Event event = ctx.newEvent(eventId);
        event.setInline(false);
        event.setImmediate(true);
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        eventService.fireEvent(event);
    }

    protected Set<DocumentRef> undeleteDocumentList(CoreSession session, List<DocumentModel> docs) {
        HashSet<DocumentRef> undeleted = new HashSet<DocumentRef>();
        for (DocumentModel doc : docs) {
            DocumentRef docRef = doc.getRef();
            if (session.getAllowedStateTransitions(docRef).contains("undelete")) {
                this.undeleteDocument(session, doc);
                undeleted.add(docRef);
                continue;
            }
            log.debug((Object)("Impossible to undelete document " + docRef + " as it does not support transition " + "undelete"));
        }
        return undeleted;
    }

    protected void undeleteAncestors(CoreSession session, DocumentRef docRef, Set<DocumentRef> undeleted) {
        for (DocumentRef ancestorRef : session.getParentDocumentRefs(docRef)) {
            if (session.hasPermission(ancestorRef, "ReadLifeCycle") && session.hasPermission(ancestorRef, "WriteLifeCycle")) {
                if (!session.getAllowedStateTransitions(ancestorRef).contains("undelete")) break;
            } else {
                log.debug((Object)("Stopping to restore ancestors because " + ancestorRef.toString() + " is not readable"));
                break;
            }
            DocumentModel ancestor = session.getDocument(ancestorRef);
            this.undeleteDocument(session, ancestor);
            undeleted.add(ancestorRef);
        }
    }

    @Override
    public String mangleName(DocumentModel doc) {
        return doc.getName() + "._" + System.currentTimeMillis() + "_.trashed";
    }

    @Override
    public String unmangleName(DocumentModel doc) {
        CoreSession session;
        String name = doc.getName();
        Matcher matcher = TRASHED_PATTERN.matcher(name);
        if (matcher.matches() && matcher.group(1).length() > 0 && (matcher = COLLISION_PATTERN.matcher(name = matcher.group(1))).matches() && matcher.group(1).length() > 0 && (session = doc.getCoreSession()) != null) {
            String newPath;
            String orig = matcher.group(1);
            String parentPath = session.getDocument(doc.getParentRef()).getPathAsString();
            if (parentPath.equals("/")) {
                parentPath = "";
            }
            if (!session.exists((DocumentRef)new PathRef(newPath = parentPath + "/" + orig))) {
                name = orig;
            }
        }
        return name;
    }

    protected void trashDocument(CoreSession session, DocumentModel doc) {
        String name = this.mangleName(doc);
        session.move(doc.getRef(), doc.getParentRef(), name);
        session.followTransition(doc, "delete");
    }

    protected void undeleteDocument(CoreSession session, DocumentModel doc) {
        String name = doc.getName();
        String newName = this.unmangleName(doc);
        if (!newName.equals(name)) {
            session.move(doc.getRef(), doc.getParentRef(), newName);
        }
        session.followTransition(doc, "undelete");
    }

    @Override
    public DocumentModelList getDocuments(DocumentModel currentDoc) {
        CoreSession session = currentDoc.getCoreSession();
        DocumentModelList docs = session.query(String.format("SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState = 'deleted' AND ecm:parentId = '%s'", currentDoc.getId()));
        return docs;
    }

    protected static class PathComparator
    implements Comparator<DocumentModel>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static PathComparator INSTANCE = new PathComparator();

        protected PathComparator() {
        }

        @Override
        public int compare(DocumentModel doc1, DocumentModel doc2) {
            return doc1.getPathAsString().replace("/", "\u0000").compareTo(doc2.getPathAsString().replace("/", "\u0000"));
        }
    }
}

