/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectoryRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class MultiDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    private static final String NAME = "org.nuxeo.ecm.directory.multi.MultiDirectoryFactory";
    protected MultiDirectoryRegistry directories;

    public Directory getDirectory(String name) {
        return this.directories.getDirectory(name);
    }

    public String getName() {
        return NAME;
    }

    public void activate(ComponentContext context) {
        this.directories = new MultiDirectoryRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.directories = null;
    }

    public void registerExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        for (Object contrib : contribs) {
            MultiDirectoryDescriptor descriptor = (MultiDirectoryDescriptor)contrib;
            this.directories.addContribution(descriptor);
            String name = descriptor.name;
            if (this.directories.getDirectory(name) != null) {
                dirService.registerDirectory(name, (DirectoryFactory)this);
                continue;
            }
            dirService.unregisterDirectory(name, (DirectoryFactory)this);
        }
    }

    public void unregisterExtension(Extension extension) throws DirectoryException {
        Object[] contribs = extension.getContributions();
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        for (Object contrib : contribs) {
            MultiDirectoryDescriptor descriptor = (MultiDirectoryDescriptor)contrib;
            String directoryName = descriptor.name;
            dirService.unregisterDirectory(directoryName, (DirectoryFactory)this);
            this.directories.removeContribution(descriptor);
        }
    }

    public void shutdown() throws DirectoryException {
        for (Directory directory : this.directories.getDirectories()) {
            directory.shutdown();
        }
    }

    public List<Directory> getDirectories() {
        return new ArrayList<Directory>(this.directories.getDirectories());
    }
}

