/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryFactoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryFactoryProxy;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.localconfiguration.DirectoryConfiguration;
import org.nuxeo.ecm.directory.memory.MemoryDirectoryFactory;
import org.nuxeo.ecm.directory.registry.DirectoryFactoryMapper;
import org.nuxeo.ecm.directory.registry.DirectoryFactoryMapperRegistry;
import org.nuxeo.ecm.directory.registry.DirectoryFactoryRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DirectoryServiceImpl
extends DefaultComponent
implements DirectoryService {
    protected static final String DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX = "_";
    private static final Log log = LogFactory.getLog(DirectoryServiceImpl.class);
    protected DirectoryFactoryRegistry factories;
    protected DirectoryFactoryMapperRegistry factoriesByDirectoryName;

    public void applicationStarted(ComponentContext context) {
        if (Framework.isTestModeSet()) {
            return;
        }
        for (Directory dir : this.getDirectories()) {
            dir.getSession().close();
        }
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected DirectoryConfiguration getDirectoryConfiguration(DocumentModel documentContext) {
        LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        if (localConfigurationService == null) {
            log.info((Object)"Local configuration not deployed, will use default configuration");
            return null;
        }
        return (DirectoryConfiguration)localConfigurationService.getConfiguration(DirectoryConfiguration.class, "DirectoryLocalConfiguration", documentContext);
    }

    protected String getWaitingLocalDirectoryName(String directoryName, DirectoryConfiguration configuration) {
        if (directoryName == null) {
            return null;
        }
        if (configuration != null && configuration.getDirectorySuffix() != null) {
            String suffix = configuration.getDirectorySuffix().trim();
            if (!"".equals(suffix)) {
                return directoryName + DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX + suffix;
            }
            log.warn((Object)"The local configuration detected is an empty value, we consider it as no configuration set.");
            log.debug((Object)("Directory Local Configuration is on : " + configuration.getDocumentRef()));
        }
        return directoryName;
    }

    public Directory getDirectory(String directoryName) throws DirectoryException {
        if (directoryName == null) {
            return null;
        }
        List<String> factoryNames = this.factoriesByDirectoryName.getFactoriesForDirectory(directoryName);
        if (factoryNames == null || factoryNames.isEmpty()) {
            return null;
        }
        for (String factoryName : factoryNames) {
            DirectoryFactory targetFactory = this.factories.getFactory(factoryName);
            if (targetFactory == null) continue;
            return targetFactory.getDirectory(directoryName);
        }
        return null;
    }

    public Directory getDirectory(String name, DocumentModel documentContext) throws DirectoryException {
        if (name == null) {
            return null;
        }
        String localDirectoryName = this.getWaitingLocalDirectoryName(name, this.getDirectoryConfiguration(documentContext));
        Directory directory = this.getDirectory(localDirectoryName);
        if (directory == null && !name.equals(localDirectoryName)) {
            log.debug((Object)String.format("The local directory named '%s' was not found. Look for the default one named: %s", localDirectoryName, name));
            directory = this.getDirectory(name);
        }
        return directory;
    }

    private Directory getDirectoryOrFail(String name) throws DirectoryException {
        return this.getDirectoryOrFail(name, null);
    }

    private Directory getDirectoryOrFail(String name, DocumentModel documentContext) throws DirectoryException {
        Directory dir = this.getDirectory(name, documentContext);
        if (null == dir) {
            throw new DirectoryException(String.format("no directory registered with name '%s'", name));
        }
        return dir;
    }

    public List<Directory> getDirectories() throws DirectoryException {
        ArrayList<Directory> directoryList = new ArrayList<Directory>();
        for (DirectoryFactory factory : this.factories.getFactories()) {
            List list = factory.getDirectories();
            directoryList.addAll(list);
        }
        return directoryList;
    }

    public void activate(ComponentContext context) {
        this.factories = new DirectoryFactoryRegistry();
        this.factoriesByDirectoryName = new DirectoryFactoryMapperRegistry();
    }

    public void deactivate(ComponentContext context) {
        for (DirectoryFactory factory : this.factories.getFactories()) {
            factory.shutdown();
        }
        this.factories = null;
        this.factoriesByDirectoryName = null;
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contrib;
            String factoryName = factoryDescriptor.getFactoryName();
            this.factories.addContribution(new DirectoryFactoryProxy(factoryName));
            log.debug((Object)("registered factory: " + factoryName));
        }
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contrib;
            String factoryName = factoryDescriptor.getFactoryName();
            DirectoryFactory factoryToRemove = this.factories.getFactory(factoryName);
            if (factoryToRemove == null) {
                log.warn((Object)String.format("Factory '%s' was not registered", factoryName));
                return;
            }
            factoryToRemove.shutdown();
            this.factories.removeContribution(factoryToRemove);
            log.debug((Object)("unregistered factory: " + factoryName));
        }
    }

    public void registerDirectory(String directoryName, DirectoryFactory factory) {
        if (factory instanceof MemoryDirectoryFactory) {
            this.factories.addContribution(factory);
        }
        DirectoryFactoryMapper contrib = new DirectoryFactoryMapper(directoryName, factory.getName());
        this.factoriesByDirectoryName.addContribution(contrib);
    }

    public void unregisterDirectory(String directoryName, DirectoryFactory factory) {
        DirectoryFactoryMapper contrib = new DirectoryFactoryMapper(directoryName, factory.getName());
        this.factoriesByDirectoryName.removeContribution(contrib);
    }

    public List<String> getDirectoryNames() throws DirectoryException {
        List<Directory> directories = this.getDirectories();
        ArrayList<String> directoryNames = new ArrayList<String>();
        for (Directory directory : directories) {
            directoryNames.add(directory.getName());
        }
        return directoryNames;
    }

    public String getDirectorySchema(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getSchema();
    }

    public String getDirectoryIdField(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getIdField();
    }

    public String getDirectoryPasswordField(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getPasswordField();
    }

    public Session open(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getSession();
    }

    public Session open(String directoryName, DocumentModel documentContext) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName, documentContext).getSession();
    }

    public String getParentDirectoryName(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getParentDirectory();
    }
}

