/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.events;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.runtime.management.counters.CounterHelper;

public class EventCounterListener
implements PostCommitEventListener {
    public static final String EVENT_CREATE_COUNTER = "org.nuxeo.event.create";
    public static final String EVENT_UPDATE_COUNTER = "org.nuxeo.event.update";
    public static final String EVENT_REMOVE_COUNTER = "org.nuxeo.event.remove";
    protected static final List<String> createEvents = Arrays.asList("documentCreated", "documentCreatedByCopy", "documentImported", "documentProxyPublished", "documentProxyUpdated");
    protected static final List<String> updateEvents = Arrays.asList("documentCheckedIn", "documentCheckedOut", "childrenOrderChanged", "documentLocked", "documentMoved", "documentPublished", "documentSecurityUpdated", "documentUnlocked", "documentModified", "lifecycle_transition_event");
    protected static final List<String> removeEvents = Arrays.asList("documentRemoved", "versionRemoved");

    public void handleEvent(EventBundle events) {
        if (events instanceof ReconnectedEventBundleImpl) {
            ReconnectedEventBundleImpl bundle = (ReconnectedEventBundleImpl)events;
            this.updateCounters(bundle.getEventNames());
        }
    }

    protected void updateCounters(List<String> eventNames) {
        int created = 0;
        int updated = 0;
        int removed = 0;
        for (String eventName : eventNames) {
            if (createEvents.contains(eventName)) {
                ++created;
                continue;
            }
            if (updateEvents.contains(eventName)) {
                ++updated;
                continue;
            }
            if (!removeEvents.contains(eventName)) continue;
            ++removed;
        }
        if (created > 0) {
            CounterHelper.increaseCounter((String)EVENT_CREATE_COUNTER, (long)created);
        }
        if (updated > 0) {
            CounterHelper.increaseCounter((String)EVENT_UPDATE_COUNTER, (long)updated);
        }
        if (removed > 0) {
            CounterHelper.increaseCounter((String)EVENT_REMOVE_COUNTER, (long)removed);
        }
    }
}

