/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentTreeIterator;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentReaderFactory;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.DocumentWriterFactory;
import org.nuxeo.ecm.core.io.DocumentsExporter;
import org.nuxeo.ecm.core.io.DocumentsImporter;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;
import org.nuxeo.ecm.core.io.impl.IODocumentManagerImpl;
import org.nuxeo.ecm.platform.io.api.IOManager;
import org.nuxeo.ecm.platform.io.api.IOResourceAdapter;
import org.nuxeo.ecm.platform.io.api.IOResources;

public class IOManagerImpl
implements IOManager {
    private static final long serialVersionUID = 5789086884484295921L;
    private static final Log log = LogFactory.getLog(IOManagerImpl.class);
    protected final Map<String, IOResourceAdapter> adaptersRegistry = new HashMap<String, IOResourceAdapter>();

    public IOResourceAdapter getAdapter(String name) {
        return this.adaptersRegistry.get(name);
    }

    public void addAdapter(String name, IOResourceAdapter adapter) {
        if ("documents".equals(name)) {
            log.error((Object)"Cannot register adapter with name documents");
            return;
        }
        this.adaptersRegistry.put(name, adapter);
    }

    public void removeAdapter(String name) {
        this.adaptersRegistry.remove(name);
    }

    public void exportDocumentsAndResources(OutputStream out, String repo, final String format, Collection<String> ioAdapters, final DocumentReader customDocReader) throws IOException {
        DocumentsExporter docsExporter = new DocumentsExporter(){

            public DocumentTranslationMap exportDocs(OutputStream out) throws IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                DocumentTranslationMap map = docManager.exportDocuments(out, customDocReader, format);
                return map;
            }
        };
        this.exportDocumentsAndResources(out, repo, docsExporter, ioAdapters);
    }

    public void exportDocumentsAndResources(OutputStream out, final String repo, final Collection<DocumentRef> sources, final boolean recurse, final String format, Collection<String> ioAdapters) throws IOException {
        DocumentsExporter docsExporter = new DocumentsExporter(){

            public DocumentTranslationMap exportDocs(OutputStream out) throws IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                DocumentTranslationMap map = docManager.exportDocuments(out, repo, sources, recurse, format);
                return map;
            }
        };
        this.exportDocumentsAndResources(out, repo, docsExporter, ioAdapters);
    }

    void exportDocumentsAndResources(OutputStream out, String repo, DocumentsExporter docsExporter, Collection<String> ioAdapters) throws IOException {
        ArrayList<String> doneAdapters = new ArrayList<String>();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        ByteArrayOutputStream docsZip = new ByteArrayOutputStream();
        DocumentTranslationMap map = docsExporter.exportDocs((OutputStream)docsZip);
        ZipEntry docsEntry = new ZipEntry("documents.zip");
        zip.putNextEntry(docsEntry);
        zip.write(docsZip.toByteArray());
        zip.closeEntry();
        docsZip.close();
        doneAdapters.add("documents");
        Set allSources = map.getDocRefMap().keySet();
        if (ioAdapters != null && !ioAdapters.isEmpty()) {
            for (String adapterName : ioAdapters) {
                String filename = adapterName + ".xml";
                IOResourceAdapter adapter = this.getAdapter(adapterName);
                if (adapter == null) {
                    log.warn((Object)("Adapter " + adapterName + " not found"));
                    continue;
                }
                if (doneAdapters.contains(adapterName)) {
                    log.warn((Object)("Export for adapter " + adapterName + " already done"));
                    continue;
                }
                IOResources resources = adapter.extractResources(repo, allSources);
                resources = adapter.translateResources(repo, resources, map);
                ByteArrayOutputStream adapterOut = new ByteArrayOutputStream();
                adapter.getResourcesAsXML((OutputStream)adapterOut, resources);
                ZipEntry adapterEntry = new ZipEntry(filename);
                zip.putNextEntry(adapterEntry);
                zip.write(adapterOut.toByteArray());
                zip.closeEntry();
                doneAdapters.add(adapterName);
                adapterOut.close();
            }
        }
        try {
            zip.close();
        }
        catch (ZipException zipException) {
            // empty catch block
        }
    }

    public void importDocumentsAndResources(InputStream in, final String repo, final DocumentRef root) throws IOException {
        DocumentsImporter docsImporter = new DocumentsImporter(){

            public DocumentTranslationMap importDocs(InputStream sourceStream) throws IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                return docManager.importDocuments(sourceStream, repo, root);
            }
        };
        this.importDocumentsAndResources(docsImporter, in, repo);
    }

    public void importDocumentsAndResources(InputStream in, String repo, DocumentRef root, final DocumentWriter customDocWriter) throws IOException {
        DocumentsImporter docsImporter = new DocumentsImporter(){

            public DocumentTranslationMap importDocs(InputStream sourceStream) throws IOException {
                IODocumentManagerImpl docManager = new IODocumentManagerImpl();
                return docManager.importDocuments(sourceStream, customDocWriter);
            }
        };
        this.importDocumentsAndResources(docsImporter, in, repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importDocumentsAndResources(DocumentsImporter docsImporter, InputStream in, String repo) throws IOException {
        ZipInputStream zip = new ZipInputStream(in);
        ZipEntry zentry = zip.getNextEntry();
        String docZipFilename = "documents.zip";
        if (zentry == null || !docZipFilename.equals(zentry.getName())) {
            zip.close();
            throw new NuxeoException("Invalid archive");
        }
        File temp = File.createTempFile("nuxeo-import-adapters-", ".zip");
        try (FileOutputStream outDocs = new FileOutputStream(temp);){
            FileUtils.copy((InputStream)zip, (OutputStream)outDocs);
        }
        zip.closeEntry();
        FileInputStream tempIn = new FileInputStream(temp.getPath());
        DocumentTranslationMap map = docsImporter.importDocs((InputStream)tempIn);
        ((InputStream)tempIn).close();
        temp.delete();
        while ((zentry = zip.getNextEntry()) != null) {
            String entryName = zentry.getName();
            if (entryName.endsWith(".xml")) {
                String ioAdapterName = entryName.substring(0, entryName.length() - 4);
                IOResourceAdapter adapter = this.getAdapter(ioAdapterName);
                if (adapter == null) {
                    log.warn((Object)("Adapter " + ioAdapterName + " not available. Unable to import associated resources."));
                    continue;
                }
                IOResources resources = adapter.loadResourcesFromXML((InputStream)zip);
                IOResources newResources = adapter.translateResources(repo, resources, map);
                log.info((Object)("store resources with adapter " + ioAdapterName));
                adapter.storeResources(newResources);
            } else {
                log.warn((Object)("skip entry: " + entryName));
            }
            try {
                zip.closeEntry();
            }
            catch (IOException e) {
                log.error((Object)("Please check code handling entry " + entryName), (Throwable)e);
            }
        }
        zip.close();
    }

    public Collection<DocumentRef> copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, DocumentLocation targetLocation, Collection<String> ioAdapters) {
        if (sources == null || sources.isEmpty()) {
            return null;
        }
        String newRepo = targetLocation.getServerName();
        if (!repo.equals(newRepo)) {
            throw new NuxeoException("Cannot copy to different server");
        }
        ArrayList<DocumentRef> roots = new ArrayList<DocumentRef>();
        try (CoreSession session = CoreInstance.openCoreSession((String)repo);){
            for (DocumentRef source : sources) {
                DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(repo, repo);
                DocumentModel sourceDoc = session.getDocument(source);
                DocumentModel destDoc = session.copy(source, targetLocation.getDocRef(), null);
                roots.add(destDoc.getRef());
                DocumentTreeIterator sourceIt = new DocumentTreeIterator(session, sourceDoc);
                DocumentTreeIterator destIt = new DocumentTreeIterator(session, destDoc);
                while (sourceIt.hasNext()) {
                    DocumentModel sourceItem = sourceIt.next();
                    DocumentRef sourceRef = sourceItem.getRef();
                    if (!destIt.hasNext()) {
                        map.put(sourceRef, null);
                        continue;
                    }
                    DocumentModel destItem = destIt.next();
                    DocumentRef destRef = destItem.getRef();
                    map.put(sourceRef, destRef);
                }
                Set allSources = map.getDocRefMap().keySet();
                if (ioAdapters != null && !ioAdapters.isEmpty()) {
                    for (String adapterName : ioAdapters) {
                        IOResourceAdapter adapter = this.getAdapter(adapterName);
                        if (adapter == null) {
                            log.warn((Object)("Adapter " + adapterName + " not found"));
                            continue;
                        }
                        IOResources resources = adapter.extractResources(repo, allSources);
                        IOResources newResources = adapter.translateResources(repo, resources, (DocumentTranslationMap)map);
                        adapter.storeResources(newResources);
                    }
                }
                session.save();
            }
        }
        return roots;
    }

    private static DocumentWriter createDocWriter(String docWriterFactoryName, Map<String, Object> factoryParams) {
        Object factoryObj;
        try {
            Class<?> clazz = Class.forName(docWriterFactoryName);
            factoryObj = clazz.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("cannot instantiate factory " + docWriterFactoryName, (Throwable)e);
        }
        if (!(factoryObj instanceof DocumentWriterFactory)) {
            throw new NuxeoException("bad class type: " + factoryObj);
        }
        DocumentWriter customDocWriter = ((DocumentWriterFactory)factoryObj).createDocWriter(factoryParams);
        if (customDocWriter == null) {
            throw new NuxeoException("null DocumentWriter created by " + docWriterFactoryName);
        }
        return customDocWriter;
    }

    private static DocumentReader createDocReader(String docReaderFactoryName, Map<String, Object> factoryParams) {
        Object factoryObj;
        try {
            Class<?> clazz = Class.forName(docReaderFactoryName);
            factoryObj = clazz.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("cannot instantiate factory " + docReaderFactoryName, (Throwable)e);
        }
        if (!(factoryObj instanceof DocumentReaderFactory)) {
            throw new NuxeoException("bad class type: " + factoryObj);
        }
        DocumentReader customDocReader = ((DocumentReaderFactory)factoryObj).createDocReader(factoryParams);
        if (customDocReader == null) {
            throw new NuxeoException("null DocumentReader created by " + docReaderFactoryName);
        }
        return customDocReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromStream(InputStream in, DocumentLocation targetLocation, String docReaderFactoryClassName, Map<String, Object> rFactoryParams, String docWriterFactoryClassName, Map<String, Object> wFactoryParams) {
        DocumentWriter customDocWriter = IOManagerImpl.createDocWriter(docWriterFactoryClassName, wFactoryParams);
        DocumentReader customDocReader = null;
        try {
            if (rFactoryParams == null) {
                rFactoryParams = new HashMap<String, Object>();
            }
            rFactoryParams.put("source_stream", in);
            customDocReader = IOManagerImpl.createDocReader(docReaderFactoryClassName, rFactoryParams);
            IODocumentManagerImpl docManager = new IODocumentManagerImpl();
            DocumentTranslationMap documentTranslationMap = docManager.importDocuments(customDocReader, customDocWriter);
        }
        finally {
            if (customDocReader != null) {
                customDocReader.close();
            }
            customDocWriter.close();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

