/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.operation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentPipe;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.ecm.core.io.impl.plugins.SingleDocumentReader;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentTreeWriter;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentWriter;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.Export", category="Services", label="Document Export", description="Export the given document.")
public class ExportDocument {
    public static final String ID = "Document.Export";
    @Param(name="exportAsTree", description="Export the document and all its children", required=false)
    protected boolean exportAsTree = false;
    @Param(name="exportAsZip", description="Create a ZIP of the export. If 'exportAsTree' is true, exportAsZip is force to true", required=false)
    protected boolean exportAsZip = false;
    @Context
    protected CoreSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run(DocumentModel doc) throws IOException {
        if (this.exportAsTree) {
            this.exportAsZip = true;
        }
        File tempFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        Framework.trackFile((File)tempFile, (Object)tempFile);
        DocumentReader documentReader = null;
        DocumentWriter documentWriter = null;
        try {
            documentReader = this.makeDocumentReader(this.session, doc, this.exportAsTree, this.exportAsZip);
            documentWriter = this.makeDocumentWriter(new FileOutputStream(tempFile), this.exportAsTree, this.exportAsZip);
            DocumentPipe pipe = this.makePipe(this.exportAsTree);
            pipe.setReader(documentReader);
            pipe.setWriter(documentWriter);
            pipe.run();
        }
        finally {
            if (documentReader != null) {
                documentReader.close();
            }
            if (documentWriter != null) {
                documentWriter.close();
            }
        }
        String filename = this.exportAsZip ? "export.zip" : "document.xml";
        String mimeType = this.exportAsZip ? "application/zip" : "text/xml";
        return Blobs.createBlob((File)tempFile, (String)mimeType, null, (String)filename);
    }

    protected DocumentPipe makePipe(boolean exportAsTree) {
        if (exportAsTree) {
            return new DocumentPipeImpl(10);
        }
        return new DocumentPipeImpl();
    }

    protected DocumentReader makeDocumentReader(CoreSession session, DocumentModel doc, boolean exportAsTree, boolean exportAsZip) {
        SingleDocumentReader documentReader;
        if (exportAsTree) {
            documentReader = new DocumentTreeReader(session, doc, false);
            if (!exportAsZip) {
                ((DocumentTreeReader)documentReader).setInlineBlobs(true);
            }
        } else {
            documentReader = new SingleDocumentReader(session, doc);
        }
        return documentReader;
    }

    protected DocumentWriter makeDocumentWriter(OutputStream outputStream, boolean exportAsTree, boolean exportAsZip) throws IOException {
        Object documentWriter = exportAsZip ? new NuxeoArchiveWriter(outputStream) : (exportAsTree ? new XMLDocumentTreeWriter(outputStream) : new XMLDocumentWriter(outputStream));
        return documentWriter;
    }
}

