/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelJsonReader
extends EntityJsonReader<DocumentModel> {
    public static final String LEGACY_MODE_READER = "DocumentModelLegacyModeReader";

    public DocumentModelJsonReader() {
        super("document");
    }

    @Override
    public DocumentModel read(Class<?> clazz, Type genericType, MediaType mediaType, InputStream in) throws IOException {
        Reader reader = (Reader)this.ctx.getParameter(LEGACY_MODE_READER);
        if (reader != null) {
            DocumentModel doc = (DocumentModel)reader.read(clazz, genericType, mediaType, in);
            return doc;
        }
        return (DocumentModel)super.read(clazz, genericType, mediaType, in);
    }

    @Override
    protected DocumentModel readEntity(JsonNode jn) throws IOException {
        JsonNode propsNode;
        String type;
        SimpleDocumentModel simpleDoc = new SimpleDocumentModel();
        String name = this.getStringField(jn, "name");
        if (StringUtils.isNotBlank((String)name)) {
            simpleDoc.setPathInfo(null, name);
        }
        if (StringUtils.isNotBlank((String)(type = this.getStringField(jn, "type")))) {
            simpleDoc.setType(type);
        }
        if ((propsNode = jn.get("properties")) != null && !propsNode.isNull() && propsNode.isObject()) {
            ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
            List properties = (List)this.readEntity(List.class, genericType, propsNode);
            for (Property property : properties) {
                String propertyName = property.getName();
                if (!propertyName.contains(":")) {
                    propertyName = property.getField().getDeclaringType().getName() + ":" + propertyName;
                }
                simpleDoc.setPropertyValue(propertyName, property.getValue());
            }
        }
        SimpleDocumentModel doc = null;
        String uid = this.getStringField(jn, "uid");
        if (StringUtils.isNotBlank((String)uid)) {
            try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(null);){
                doc = wrapper.getSession().getDocument((DocumentRef)new IdRef(uid));
            }
            DocumentModelJsonReader.applyPropertyValues((DocumentModel)simpleDoc, (DocumentModel)doc);
        } else {
            doc = simpleDoc;
        }
        return doc;
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst) {
        for (String schema : src.getSchemas()) {
            DataModelImpl dataModel = (DataModelImpl)dst.getDataModel(schema);
            DataModelImpl fromDataModel = (DataModelImpl)src.getDataModel(schema);
            for (String field : fromDataModel.getDirtyFields()) {
                Serializable data = (Serializable)fromDataModel.getData(field);
                try {
                    if (!(dataModel.getDocumentPart().get(field) instanceof BlobProperty)) {
                        dataModel.setData(field, (Object)data);
                        continue;
                    }
                    dataModel.setData(field, (Object)DocumentModelJsonReader.decodeBlob(data));
                }
                catch (PropertyNotFoundException e) {}
            }
        }
    }

    private static Serializable decodeBlob(Serializable data) {
        if (data instanceof Blob) {
            return data;
        }
        return null;
    }
}

