/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLRepository
implements Repository {
    private static final Log log = LogFactory.getLog(SQLRepository.class);
    public final RepositoryImpl repository;
    private final String name;

    public SQLRepository(RepositoryDescriptor descriptor) {
        this.repository = new RepositoryImpl(descriptor);
        this.name = descriptor.name;
    }

    public String getName() {
        return this.name;
    }

    public Session getSession() {
        return new SQLSession(this.repository.getConnection(), this);
    }

    public void shutdown() {
        try {
            this.repository.close();
        }
        catch (NuxeoException e) {
            log.error((Object)"Cannot close repository", (Throwable)e);
        }
    }

    public int getActiveSessionsCount() {
        return this.repository.getActiveSessionsCount();
    }

    public void markReferencedBinaries() {
        this.repository.markReferencedBinaries();
    }
}

