/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBQueryBuilder;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class MongoDBRepository
extends DBSRepositoryBase {
    private static final Log log = LogFactory.getLog(MongoDBRepository.class);
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    private static final Long MINUS_ONE = -11L;
    public static final String DB_DEFAULT = "nuxeo";
    public static final String MONGODB_ID = "_id";
    public static final String MONGODB_INC = "$inc";
    public static final String MONGODB_SET = "$set";
    public static final String MONGODB_UNSET = "$unset";
    public static final String MONGODB_PUSH = "$push";
    public static final String MONGODB_EACH = "$each";
    public static final String MONGODB_META = "$meta";
    public static final String MONGODB_TEXT_SCORE = "textScore";
    private static final String MONGODB_INDEX_TEXT = "text";
    private static final String MONGODB_INDEX_NAME = "name";
    private static final String MONGODB_LANGUAGE_OVERRIDE = "language_override";
    private static final String FULLTEXT_INDEX_NAME = "fulltext";
    private static final String LANGUAGE_FIELD = "__language";
    protected static final String COUNTER_NAME_UUID = "ecm:id";
    protected static final String COUNTER_FIELD = "seq";
    protected MongoClient mongoClient;
    protected DBCollection coll;
    protected DBCollection countersColl;
    protected DBObject binaryKeys;
    protected static final DBObject LOCK_FIELDS = new BasicDBObject();
    protected static final DBObject UNSET_LOCK_UPDATE;

    public MongoDBRepository(MongoDBRepositoryDescriptor descriptor) {
        super(descriptor.name, descriptor.getFulltextDisabled());
        try {
            this.mongoClient = MongoDBRepository.newMongoClient(descriptor);
            this.coll = MongoDBRepository.getCollection(descriptor, this.mongoClient);
            this.countersColl = MongoDBRepository.getCountersCollection(descriptor, this.mongoClient);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.initRepository();
    }

    public void shutdown() {
        super.shutdown();
        this.mongoClient.close();
    }

    public static MongoClient newMongoClient(MongoDBRepositoryDescriptor descriptor) throws UnknownHostException {
        String server = descriptor.server;
        if (StringUtils.isBlank((String)server)) {
            throw new NuxeoException("Missing <server> in MongoDB repository descriptor");
        }
        if (server.startsWith("mongodb://")) {
            return new MongoClient(new MongoClientURI(server));
        }
        return new MongoClient(new ServerAddress(server));
    }

    protected static DBCollection getCollection(MongoClient mongoClient, String dbname, String collection) {
        if (StringUtils.isBlank((String)dbname)) {
            dbname = DB_DEFAULT;
        }
        DB db = mongoClient.getDB(dbname);
        return db.getCollection(collection);
    }

    public static DBCollection getCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.dbname, descriptor.name);
    }

    public static DBCollection getCountersCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.dbname, descriptor.name + ".counters");
    }

    protected Object valueToBson(Object value) {
        if (value instanceof State) {
            return this.stateToBson((State)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            return this.listToBson(values);
        }
        if (value instanceof Object[]) {
            return this.listToBson(Arrays.asList((Object[])value));
        }
        return this.serializableToBson(value);
    }

    protected DBObject stateToBson(State state) {
        BasicDBObject ob = new BasicDBObject();
        for (Map.Entry en : state.entrySet()) {
            Object val = this.valueToBson(en.getValue());
            if (val == null) continue;
            ob.put((String)en.getKey(), val);
        }
        return ob;
    }

    protected List<Object> listToBson(List<Object> values) {
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (Object value : values) {
            objects.add(this.valueToBson(value));
        }
        return objects;
    }

    protected State bsonToState(DBObject ob) {
        if (ob == null) {
            return null;
        }
        State state = new State(ob.keySet().size());
        for (String key : ob.keySet()) {
            Object[] value;
            Object val = ob.get(key);
            if (val instanceof List) {
                List list = (List)val;
                if (list.isEmpty()) {
                    value = null;
                } else if (list.get(0) instanceof DBObject) {
                    ArrayList<State> l = new ArrayList<State>(list.size());
                    for (Object el : list) {
                        l.add(this.bsonToState((DBObject)el));
                    }
                    value = l;
                } else {
                    Class klass = Object.class;
                    for (Object o : list) {
                        if (o == null) continue;
                        klass = o.getClass();
                        break;
                    }
                    Object[] ar = (Object[])Array.newInstance(klass, list.size());
                    int i = 0;
                    for (Object el : list) {
                        ar[i++] = this.scalarToSerializable(el);
                    }
                    value = ar;
                }
            } else if (val instanceof DBObject) {
                value = this.bsonToState((DBObject)val);
            } else {
                if (MONGODB_ID.equals(key)) continue;
                value = this.scalarToSerializable(val);
            }
            state.put(key, (Serializable)value);
        }
        return state;
    }

    protected List<DBObject> diffToBson(State.StateDiff diff) {
        Updates updates = new Updates();
        this.diffToUpdates(diff, null, updates);
        UpdateListBuilder builder = new UpdateListBuilder();
        for (Map.Entry en : updates.set.entrySet()) {
            builder.update(MONGODB_SET, (String)en.getKey(), en.getValue());
        }
        for (Map.Entry en : updates.unset.entrySet()) {
            builder.update(MONGODB_UNSET, (String)en.getKey(), en.getValue());
        }
        for (Map.Entry en : updates.push.entrySet()) {
            builder.update(MONGODB_PUSH, (String)en.getKey(), en.getValue());
        }
        for (Map.Entry en : updates.inc.entrySet()) {
            builder.update(MONGODB_INC, (String)en.getKey(), en.getValue());
        }
        return builder.updateList;
    }

    protected void diffToUpdates(State.StateDiff diff, String prefix, Updates updates) {
        String elemPrefix = prefix == null ? "" : prefix + '.';
        for (Map.Entry en : diff.entrySet()) {
            String name = elemPrefix + (String)en.getKey();
            Serializable value = (Serializable)en.getValue();
            if (value instanceof State.StateDiff) {
                this.diffToUpdates((State.StateDiff)value, name, updates);
                continue;
            }
            if (value instanceof State.ListDiff) {
                this.diffToUpdates((State.ListDiff)value, name, updates);
                continue;
            }
            if (value instanceof Delta) {
                this.diffToUpdates((Delta)value, name, updates);
                continue;
            }
            updates.set.put(name, this.valueToBson(value));
        }
    }

    protected void diffToUpdates(State.ListDiff listDiff, String prefix, Updates updates) {
        if (listDiff.diff != null) {
            String elemPrefix = prefix == null ? "" : prefix + '.';
            int i = 0;
            for (Object value : listDiff.diff) {
                String name = elemPrefix + i;
                if (value instanceof State.StateDiff) {
                    this.diffToUpdates((State.StateDiff)value, name, updates);
                } else if (value != State.NOP) {
                    updates.set.put(name, this.valueToBson(value));
                }
                ++i;
            }
        }
        if (listDiff.rpush != null) {
            Object pushed = listDiff.rpush.size() == 1 ? this.valueToBson(listDiff.rpush.get(0)) : new BasicDBObject(MONGODB_EACH, this.listToBson(listDiff.rpush));
            updates.push.put(prefix, pushed);
        }
    }

    protected void diffToUpdates(Delta delta, String prefix, Updates updates) {
        Object inc = this.valueToBson(delta.getDeltaValue());
        updates.inc.put(prefix, inc);
    }

    protected Object serializableToBson(Object value) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return value;
    }

    protected Serializable scalarToSerializable(Object val) {
        if (val instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)val);
            return cal;
        }
        return (Serializable)val;
    }

    protected void initRepository() {
        BasicDBObject query;
        this.coll.createIndex((DBObject)new BasicDBObject(COUNTER_NAME_UUID, (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:parentId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:ancestorIds", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:versionSeriesId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:proxyTargetId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:proxyVersionSeriesId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:racl", (Object)ONE));
        BasicDBObject parentChild = new BasicDBObject();
        parentChild.put("ecm:parentId", (Object)ONE);
        parentChild.put("ecm:name", (Object)ONE);
        this.coll.createIndex((DBObject)parentChild);
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:primaryType", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:lifeCycleState", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:fulltextJobId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:acp.acl.user", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:acp.acl.status", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("dc:modified", (Object)MINUS_ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("rend:renditionName", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("drv:subscriptions.enabled", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("collectionMember:collectionIds", (Object)ONE));
        if (!this.fulltextDisabled) {
            BasicDBObject indexKeys = new BasicDBObject();
            indexKeys.put("ecm:fulltextSimple", (Object)MONGODB_INDEX_TEXT);
            indexKeys.put("ecm:fulltextBinary", (Object)MONGODB_INDEX_TEXT);
            BasicDBObject indexOptions = new BasicDBObject();
            indexOptions.put(MONGODB_INDEX_NAME, (Object)FULLTEXT_INDEX_NAME);
            indexOptions.put(MONGODB_LANGUAGE_OVERRIDE, (Object)LANGUAGE_FIELD);
            this.coll.createIndex((DBObject)indexKeys, (DBObject)indexOptions);
        }
        if (this.coll.findOne((DBObject)(query = new BasicDBObject(COUNTER_NAME_UUID, (Object)this.getRootId())), this.justPresenceField()) != null) {
            return;
        }
        this.initRoot();
    }

    protected Long getNextUuidSeq() {
        BasicDBObject query = new BasicDBObject(MONGODB_ID, (Object)COUNTER_NAME_UUID);
        BasicDBObject update = new BasicDBObject(MONGODB_INC, (Object)new BasicDBObject(COUNTER_FIELD, (Object)ONE));
        boolean returnNew = true;
        DBObject idCounter = this.countersColl.findAndModify((DBObject)query, null, null, false, (DBObject)update, returnNew, false);
        if (idCounter == null) {
            throw new RuntimeException("Repository id counter not initialized");
        }
        return (Long)idCounter.get(COUNTER_FIELD);
    }

    public String generateNewId() {
        return UUID.randomUUID().toString();
    }

    public void createState(State state) {
        DBObject ob = this.stateToBson(state);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: CREATE " + ob));
        }
        this.coll.insert(new DBObject[]{ob});
    }

    public State readState(String id) {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        return this.findOne((DBObject)query);
    }

    public List<State> readStates(List<String> ids) {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)new BasicDBObject("$in", ids));
        return this.findAll((DBObject)query, ids.size());
    }

    public void updateState(String id, State.StateDiff diff) {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        for (DBObject update : this.diffToBson(diff)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("MongoDB: UPDATE " + id + ": " + update));
            }
            this.coll.update((DBObject)query, update);
        }
    }

    public void deleteStates(Set<String> ids) {
        WriteResult w;
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)new BasicDBObject("$in", ids));
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: REMOVE " + ids));
        }
        if ((w = this.coll.remove((DBObject)query)).getN() != ids.size()) {
            log.error((Object)("Removed " + w.getN() + " docs for " + ids.size() + " ids: " + ids));
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        return this.findOne(query);
    }

    protected void logQuery(String id, DBObject fields) {
        this.logQuery((DBObject)new BasicDBObject(COUNTER_NAME_UUID, (Object)id), fields);
    }

    protected void logQuery(DBObject query, DBObject fields) {
        if (fields == null) {
            log.trace((Object)("MongoDB: QUERY " + query));
        } else {
            log.trace((Object)("MongoDB: QUERY " + query + " KEYS " + fields));
        }
    }

    protected void logQuery(DBObject query, DBObject fields, DBObject orderBy, int limit, int offset) {
        log.trace((Object)("MongoDB: QUERY " + query + " KEYS " + fields + (orderBy == null ? "" : " ORDER BY " + orderBy) + " OFFSET " + offset + " LIMIT " + limit));
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        if (log.isTraceEnabled()) {
            this.logQuery(query, this.justPresenceField());
        }
        return this.coll.findOne(query, this.justPresenceField()) != null;
    }

    protected DBObject getChildQuery(String parentId, String name, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject();
        query.put("ecm:parentId", (Object)parentId);
        query.put("ecm:name", (Object)name);
        this.addIgnoredIds((DBObject)query, ignored);
        return query;
    }

    protected void addIgnoredIds(DBObject query, Set<String> ignored) {
        if (!ignored.isEmpty()) {
            BasicDBObject notInIds = new BasicDBObject("$nin", new ArrayList<String>(ignored));
            query.put(COUNTER_NAME_UUID, (Object)notInIds);
        }
    }

    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, value);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.findAll((DBObject)query, 0);
    }

    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key1, value1);
        query.put(key2, value2);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.findAll((DBObject)query, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKeyValueArray(String key, Object value, Set<String> ids, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies) {
        BasicDBObject query = new BasicDBObject(key, value);
        BasicDBObject fields = new BasicDBObject();
        fields.put(MONGODB_ID, (Object)ZERO);
        fields.put(COUNTER_NAME_UUID, (Object)ONE);
        fields.put("ecm:isProxy", (Object)ONE);
        fields.put("ecm:proxyTargetId", (Object)ONE);
        fields.put("ecm:proxyIds", (Object)ONE);
        if (log.isTraceEnabled()) {
            this.logQuery((DBObject)query, (DBObject)fields);
        }
        try (DBCursor cursor = this.coll.find((DBObject)query, (DBObject)fields);){
            for (DBObject ob : cursor) {
                Object[] proxyIds;
                String id = (String)ob.get(COUNTER_NAME_UUID);
                ids.add(id);
                if (proxyTargets != null && Boolean.TRUE.equals(ob.get("ecm:isProxy"))) {
                    String targetId = (String)ob.get("ecm:proxyTargetId");
                    proxyTargets.put(id, targetId);
                }
                if (targetProxies == null || (proxyIds = (Object[])ob.get("ecm:proxyIds")) == null) continue;
                targetProxies.put(id, proxyIds);
            }
        }
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, (Object)value);
        this.addIgnoredIds((DBObject)query, ignored);
        if (log.isTraceEnabled()) {
            this.logQuery((DBObject)query, this.justPresenceField());
        }
        return this.coll.findOne((DBObject)query, this.justPresenceField()) != null;
    }

    protected State findOne(DBObject query) {
        if (log.isTraceEnabled()) {
            this.logQuery(query, null);
        }
        return this.bsonToState(this.coll.findOne(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<State> findAll(DBObject query, int sizeHint) {
        if (log.isTraceEnabled()) {
            this.logQuery(query, null);
        }
        HashSet<String> seen = new HashSet<String>();
        try (DBCursor cursor = this.coll.find(query);){
            ArrayList<State> list = new ArrayList<State>(sizeHint);
            for (DBObject ob : cursor) {
                if (!seen.add((String)ob.get(COUNTER_NAME_UUID))) continue;
                list.add(this.bsonToState(ob));
            }
            ArrayList<State> arrayList = list;
            return arrayList;
        }
    }

    protected DBObject justPresenceField() {
        return new BasicDBObject(MONGODB_ID, (Object)ONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartialList<State> queryAndFetch(Expression expression, SelectClause selectClause, OrderByClause orderByClause, int limit, int offset, int countUpTo, DBSExpressionEvaluator evaluator, boolean deepCopy) {
        long totalSize;
        ArrayList<State> list;
        MongoDBQueryBuilder builder = new MongoDBQueryBuilder(expression, selectClause, orderByClause, evaluator.pathResolver);
        builder.walk();
        if (builder.hasFulltext && this.fulltextDisabled) {
            throw new RuntimeException("Fulltext disabled by configuration");
        }
        DBObject query = builder.getQuery();
        this.addPrincipals(query, evaluator.principals);
        DBObject orderBy = builder.getOrderBy();
        DBObject keys = builder.getProjection();
        if (log.isTraceEnabled()) {
            this.logQuery(query, keys, orderBy, limit, offset);
        }
        try (DBCursor cursor = this.coll.find(query, keys).skip(offset).limit(limit);){
            if (orderBy != null) {
                cursor = cursor.sort(orderBy);
            }
            list = new ArrayList<State>();
            for (DBObject ob : cursor) {
                list.add(this.bsonToState(ob));
            }
            if (countUpTo == -1) {
                totalSize = limit == 0 ? (long)list.size() : (long)cursor.count();
            } else if (countUpTo == 0) {
                totalSize = -1L;
            } else {
                totalSize = limit == 0 ? (long)list.size() : (long)cursor.copy().limit(countUpTo + 1).count();
                if (totalSize > (long)countUpTo) {
                    totalSize = -2L;
                }
            }
        }
        if (log.isTraceEnabled() && list.size() != 0) {
            log.trace((Object)("MongoDB:    -> " + list.size()));
        }
        return new PartialList(list, totalSize);
    }

    protected void addPrincipals(DBObject query, Set<String> principals) {
        if (principals != null) {
            BasicDBObject inPrincipals = new BasicDBObject("$in", new ArrayList<String>(principals));
            query.put("ecm:racl", (Object)inPrincipals);
        }
    }

    protected void initBlobsPaths() {
        MongoDBBlobFinder finder = new MongoDBBlobFinder();
        finder.visit();
        this.binaryKeys = finder.binaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markReferencedBinaries() {
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        if (log.isTraceEnabled()) {
            this.logQuery((DBObject)new BasicDBObject(), this.binaryKeys);
        }
        try (DBCursor cursor = this.coll.find((DBObject)new BasicDBObject(), this.binaryKeys);){
            for (DBObject ob : cursor) {
                this.markReferencedBinaries(ob, blobManager);
            }
        }
    }

    protected void markReferencedBinaries(DBObject ob, BlobManager blobManager) {
        for (String key : ob.keySet()) {
            Object value = ob.get(key);
            if (value instanceof List) {
                List list = (List)value;
                for (Object v : list) {
                    if (v instanceof DBObject) {
                        this.markReferencedBinaries((DBObject)v, blobManager);
                        continue;
                    }
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof DBObject) {
                this.markReferencedBinaries((DBObject)value, blobManager);
                continue;
            }
            this.markReferencedBinary(value, blobManager);
        }
    }

    protected void markReferencedBinary(Object value, BlobManager blobManager) {
        if (!(value instanceof String)) {
            return;
        }
        String key = (String)value;
        blobManager.markReferencedBinary(key, this.repositoryName);
    }

    public Lock getLock(String id) {
        DBObject res;
        if (log.isTraceEnabled()) {
            this.logQuery(id, LOCK_FIELDS);
        }
        if ((res = this.coll.findOne((DBObject)new BasicDBObject(COUNTER_NAME_UUID, (Object)id), LOCK_FIELDS)) == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)res.get("ecm:lockOwner");
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)this.scalarToSerializable(res.get("ecm:lockCreated"));
        return new Lock(owner, created);
    }

    public Lock setLock(String id, Lock lock) {
        DBObject old;
        DBObject res;
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        query.put("ecm:lockOwner", null);
        BasicDBObject setLock = new BasicDBObject();
        setLock.put("ecm:lockOwner", (Object)lock.getOwner());
        setLock.put("ecm:lockCreated", this.serializableToBson(lock.getCreated()));
        BasicDBObject setLockUpdate = new BasicDBObject(MONGODB_SET, (Object)setLock);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: FINDANDMODIFY " + query + " UPDATE " + setLockUpdate));
        }
        if ((res = this.coll.findAndModify((DBObject)query, null, null, false, (DBObject)setLockUpdate, false, false)) != null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            this.logQuery(id, LOCK_FIELDS);
        }
        if ((old = this.coll.findOne((DBObject)new BasicDBObject(COUNTER_NAME_UUID, (Object)id), LOCK_FIELDS)) == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get("ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.scalarToSerializable(old.get("ecm:lockCreated"));
        if (oldOwner != null) {
            return new Lock(oldOwner, oldCreated);
        }
        throw new ConcurrentUpdateException("Lock " + id);
    }

    public Lock removeLock(String id, String owner) {
        DBObject old;
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        if (owner != null) {
            List<String> ownerOrNull = Arrays.asList(owner, null);
            query.put("ecm:lockOwner", (Object)new BasicDBObject("$in", ownerOrNull));
        }
        if ((old = this.coll.findAndModify((DBObject)query, null, null, false, UNSET_LOCK_UPDATE, false, false)) != null) {
            String oldOwner = (String)old.get("ecm:lockOwner");
            if (oldOwner == null) {
                return null;
            }
            Calendar oldCreated = (Calendar)this.scalarToSerializable(old.get("ecm:lockCreated"));
            return new Lock(oldOwner, oldCreated);
        }
        if (log.isTraceEnabled()) {
            this.logQuery(id, LOCK_FIELDS);
        }
        if ((old = this.coll.findOne((DBObject)new BasicDBObject(COUNTER_NAME_UUID, (Object)id), LOCK_FIELDS)) == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get("ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.scalarToSerializable(old.get("ecm:lockCreated"));
        if (oldOwner != null) {
            if (!LockManager.canLockBeRemoved((String)oldOwner, (String)owner)) {
                return new Lock(oldOwner, oldCreated, true);
            }
            throw new ConcurrentUpdateException("Unlock " + id);
        }
        throw new ConcurrentUpdateException("Unlock " + id);
    }

    public void closeLockManager() {
    }

    public void clearLockManagerCaches() {
    }

    static /* synthetic */ Long access$000() {
        return ZERO;
    }

    static {
        LOCK_FIELDS.put("ecm:lockOwner", (Object)ONE);
        LOCK_FIELDS.put("ecm:lockCreated", (Object)ONE);
        UNSET_LOCK_UPDATE = new BasicDBObject(MONGODB_UNSET, (Object)LOCK_FIELDS);
    }

    protected static class MongoDBBlobFinder
    extends DBSRepositoryBase.BlobFinder {
        protected DBObject binaryKeys = new BasicDBObject("_id", (Object)MongoDBRepository.access$000());

        protected MongoDBBlobFinder() {
        }

        protected void recordBlobPath() {
            this.path.addLast("data");
            this.binaryKeys.put(StringUtils.join((Collection)this.path, (String)"."), (Object)ONE);
            this.path.removeLast();
        }
    }

    protected static class UpdateListBuilder {
        protected List<DBObject> updateList = new ArrayList<DBObject>(1);
        protected DBObject update;
        protected List<String> keys;

        protected UpdateListBuilder() {
            this.newUpdate();
        }

        protected void newUpdate() {
            this.update = new BasicDBObject();
            this.updateList.add(this.update);
            this.keys = new ArrayList<String>();
        }

        protected void update(String op, String key, Object value) {
            if (this.conflicts(key, this.keys)) {
                this.newUpdate();
            }
            this.keys.add(key);
            DBObject map = (DBObject)this.update.get(op);
            if (map == null) {
                map = new BasicDBObject();
                this.update.put(op, (Object)map);
            }
            map.put(key, value);
        }

        protected boolean conflicts(String key, List<String> previousKeys) {
            String keydot = key + '.';
            for (String prev : previousKeys) {
                if (!prev.equals(key) && !prev.startsWith(keydot) && !key.startsWith(prev + '.')) continue;
                return true;
            }
            return false;
        }
    }

    public static class Updates {
        public BasicDBObject set = new BasicDBObject();
        public BasicDBObject unset = new BasicDBObject();
        public BasicDBObject push = new BasicDBObject();
        public BasicDBObject inc = new BasicDBObject();
    }
}

