/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.model.TaskCompletionRequest;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="task")
@Produces(value={"application/json"})
public class TaskObject
extends DefaultObject {
    public static final String BASE_QUERY = String.format("SELECT * FROM Document WHERE ecm:mixinType = '%s' AND ecm:currentLifeCycleState = '%s'", "Task", "opened");

    @PUT
    @Path(value="{taskId}/reassign")
    @Consumes
    public Response reassignTask(@PathParam(value="taskId") String taskId, @QueryParam(value="actors") List<String> actors, @QueryParam(value="comment") String comment) {
        ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).reassignTask(this.getContext().getCoreSession(), taskId, actors, comment);
        return Response.ok().status(Response.Status.OK).build();
    }

    @PUT
    @Path(value="{taskId}/delegate")
    @Consumes
    public Response delegateTask(@PathParam(value="taskId") String taskId, @QueryParam(value="delegatedActors") List<String> delegatedActors, @QueryParam(value="comment") String comment) {
        ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).delegateTask(this.getContext().getCoreSession(), taskId, delegatedActors, comment);
        return Response.ok().status(Response.Status.OK).build();
    }

    @PUT
    @Path(value="{taskId}/{taskAction}")
    @Consumes(value={"application/json", "application/json+nxentity"})
    @Produces(value={"application/json"})
    public Response completeTask(@PathParam(value="taskId") String taskId, @PathParam(value="taskAction") String action, TaskCompletionRequest taskCompletionRequest) {
        Map<String, Object> data = taskCompletionRequest.getDataMap();
        CoreSession session = this.getContext().getCoreSession();
        ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).endTask(session, (Task)session.getDocument((DocumentRef)new IdRef(taskId)).getAdapter(Task.class), data, action);
        Task completedTask = (Task)session.getDocument((DocumentRef)new IdRef(taskId)).getAdapter(Task.class);
        return Response.ok((Object)completedTask).status(Response.Status.OK).build();
    }

    @GET
    public List<Task> getUserRelatedWorkflowTasks(@QueryParam(value="userId") String userId, @QueryParam(value="workflowInstanceId") String workflowInstanceId, @QueryParam(value="workflowModelName") String workflowModelName) {
        return ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getTasks(null, userId, workflowInstanceId, workflowModelName, this.getContext().getCoreSession());
    }

    @GET
    @Path(value="{taskId}")
    public Task getTaskById(@PathParam(value="taskId") String taskId) {
        DocumentModel docModel = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(taskId));
        return (Task)docModel.getAdapter(Task.class);
    }
}

