/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class Prefetch
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Serializable> values = new HashMap<String, Serializable>();
    public Map<String, List<String>> keysBySchema = new HashMap<String, List<String>>();
    public Map<String, Map<String, String>> keysBySchemaAndName = new HashMap<String, Map<String, String>>();

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public void put(String prefixedName, String schemaName, String name, Serializable value) {
        this.values.put(prefixedName, value);
        if (schemaName != null) {
            Map<String, String> keysByName = this.keysBySchemaAndName.get(schemaName);
            if (keysByName == null) {
                keysByName = new HashMap<String, String>();
                this.keysBySchemaAndName.put(schemaName, keysByName);
            }
            keysByName.put(name, prefixedName);
            List<String> keys = this.keysBySchema.get(schemaName);
            if (keys == null) {
                keys = new LinkedList<String>();
                this.keysBySchema.put(schemaName, keys);
            }
            keys.add(prefixedName);
        }
    }

    public Serializable get(String xpath) {
        if (this.values.containsKey(xpath = ComplexTypeImpl.canonicalXPath(xpath))) {
            return this.cloned(this.values.get(xpath));
        }
        return ObjectUtils.NULL;
    }

    public Serializable get(String schemaName, String name) {
        String prefixedName;
        Map<String, String> keysByName = this.keysBySchemaAndName.get(schemaName);
        if (keysByName != null && (prefixedName = keysByName.get(name)) != null && this.values.containsKey(prefixedName)) {
            return this.cloned(this.values.get(prefixedName));
        }
        return ObjectUtils.NULL;
    }

    protected Serializable cloned(Serializable value) {
        if (value instanceof Object[]) {
            value = (Serializable)((Object[])value).clone();
        }
        return value;
    }

    public boolean isPrefetched(String xpath) {
        xpath = ComplexTypeImpl.canonicalXPath(xpath);
        return this.values.containsKey(xpath);
    }

    public boolean isPrefetched(String schemaName, String name) {
        Map<String, String> keysByName = this.keysBySchemaAndName.get(schemaName);
        if (keysByName == null) {
            return false;
        }
        String prefixedName = keysByName.get(name);
        if (prefixedName == null) {
            return false;
        }
        return this.values.containsKey(prefixedName);
    }

    public void clearPrefetch(String schemaName) {
        this.keysBySchemaAndName.remove(schemaName);
        List<String> keys = this.keysBySchema.remove(schemaName);
        if (keys != null) {
            for (String prefixedName : keys) {
                this.values.remove(prefixedName);
            }
        }
    }

    public String getXPathSchema(String xpath, DocumentType type) {
        int i = (xpath = ComplexTypeImpl.canonicalXPath(xpath)).indexOf(47);
        String prop = i == -1 ? xpath : xpath.substring(0, i);
        int p = prop.indexOf(58);
        if (p == -1) {
            for (Schema schema : type.getSchemas()) {
                if (!schema.hasField(prop)) continue;
                return schema.getName();
            }
            return null;
        }
        String prefix = prop.substring(0, p);
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = schemaManager.getSchemaFromPrefix(prefix);
        if (schema == null) {
            schema = schemaManager.getSchema(prefix);
        }
        return schema == null ? null : schema.getName();
    }
}

