/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.schema.types.constraints.AbstractConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public class PatternConstraint
extends AbstractConstraint {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "PatternConstraint";
    private static final String PNAME_PATTERN = "Pattern";
    protected final Pattern pattern;

    public PatternConstraint(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean validate(Object object) {
        if (object == null) {
            return true;
        }
        return this.pattern.matcher(object.toString()).matches();
    }

    @Override
    public Constraint.Description getDescription() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(PNAME_PATTERN, (Serializable)((Object)this.pattern.pattern()));
        return new Constraint.Description(NAME, params);
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    @Override
    public String getErrorMessage(Object invalidValue, Locale locale) {
        ArrayList<String> pathTokens = new ArrayList<String>();
        pathTokens.add("label.schema.constraint.violation");
        pathTokens.add(NAME);
        String key = StringUtils.join(pathTokens, (char)'.');
        Object[] params = new Object[]{this.getPattern()};
        Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
        String message = PatternConstraint.getMessageString("messages", key, params, computedLocale);
        if (message != null && !message.trim().isEmpty() && !key.equals(message)) {
            return message;
        }
        return super.getErrorMessage(invalidValue, computedLocale);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.pattern().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternConstraint other = (PatternConstraint)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.pattern().equals(other.pattern.pattern()));
    }
}

