/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.FileVersion;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.update.Entry;
import org.nuxeo.connect.update.task.update.JarUtils;
import org.nuxeo.connect.update.task.update.RegistrySerializer;
import org.nuxeo.connect.update.task.update.RollbackOptions;
import org.nuxeo.connect.update.task.update.UpdateOptions;
import org.nuxeo.connect.update.task.update.Version;

public class UpdateManager {
    private static final Log log = LogFactory.getLog(UpdateManager.class);
    public static final String STUDIO_SNAPSHOT_VERSION = "0.0.0-SNAPSHOT";
    protected Task task;
    protected Map<String, Entry> registry;
    protected File file;
    protected File backupRoot;
    protected File serverRoot;

    public UpdateManager(File serverRoot, File regFile) {
        this.file = regFile;
        this.backupRoot = new File(this.file.getParentFile(), "backup");
        this.backupRoot.mkdirs();
        this.serverRoot = serverRoot;
    }

    public File getServerRoot() {
        return this.serverRoot;
    }

    public File getBackupRoot() {
        return this.backupRoot;
    }

    public Task getTask() {
        return this.task;
    }

    public Map<String, Entry> getRegistry() {
        return this.registry;
    }

    public synchronized void load() throws PackageException {
        if (!this.file.isFile()) {
            this.registry = new HashMap<String, Entry>();
            return;
        }
        try {
            this.registry = RegistrySerializer.load(this.file);
        }
        catch (PackageException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PackageException("IOException while trying to load the registry", (Throwable)e);
        }
    }

    public synchronized void store() throws PackageException {
        try {
            RegistrySerializer.store(this.registry, this.file);
        }
        catch (IOException e) {
            throw new PackageException("IOException while trying to write the registry", (Throwable)e);
        }
    }

    public String getVersionPath(UpdateOptions opt) {
        return this.getServerRelativePath(opt.getTargetFile());
    }

    public String getKey(UpdateOptions opt) {
        String key = this.getServerRelativePath(opt.getTargetDir());
        key = key.endsWith(File.separator) ? key.concat(opt.nameWithoutVersion) : key.concat(File.separator).concat(opt.nameWithoutVersion);
        return key;
    }

    public RollbackOptions update(UpdateOptions opt) throws PackageException {
        JarUtils.Match<File> currentJar;
        UpdateOptions optToUpdate;
        Version v;
        boolean newVersion;
        String key = this.getKey(opt);
        Entry entry = this.registry.get(key);
        if (entry == null) {
            entry = this.createEntry(key);
        }
        boolean bl = newVersion = (v = entry.getVersion(opt.version)) == null;
        if (v == null) {
            v = entry.addVersion(new Version(opt.getVersion()));
            v.setPath(this.getVersionPath(opt));
        }
        v.addPackage(opt);
        if (newVersion || opt.isSnapshotVersion()) {
            this.backupFile(opt.getFile(), v.getPath());
        }
        if ((optToUpdate = this.shouldUpdate(key, opt, currentJar = this.findInstalledJar(key))) != null) {
            File currentFile = currentJar != null ? (File)currentJar.object : null;
            this.doUpdate(currentFile, optToUpdate);
        }
        return new RollbackOptions(key, opt);
    }

    protected UpdateOptions shouldUpdate(String key, UpdateOptions opt, JarUtils.Match<File> currentJar) throws PackageException {
        Version greatestVersion;
        log.debug((Object)("Look for updating " + opt.file.getName()));
        if (opt.upgradeOnly && currentJar == null) {
            log.debug((Object)"=> don't update (upgradeOnly)");
            return null;
        }
        if (opt.allowDowngrade) {
            log.debug((Object)"=> update (allowDowngrade)");
            return opt;
        }
        UpdateOptions optToUpdate = null;
        Version packageVersion = this.registry.get(key).getVersion(opt.version);
        optToUpdate = packageVersion.equals(greatestVersion = this.registry.get(key).getGreatestVersion()) ? opt : UpdateOptions.newInstance(opt.pkgId, new File(this.backupRoot, greatestVersion.path), opt.targetDir);
        FileVersion greatestFileVersion = greatestVersion.getFileVersion();
        if (currentJar == null) {
            log.debug((Object)("=> update (new) " + greatestFileVersion));
            return optToUpdate;
        }
        FileVersion currentVersion = new FileVersion(currentJar.version);
        log.debug((Object)("=> comparing " + greatestFileVersion + " with " + currentVersion));
        if (greatestFileVersion.greaterThan(currentVersion)) {
            log.debug((Object)"=> update (greater)");
            return optToUpdate;
        }
        if (greatestFileVersion.equals((Object)currentVersion)) {
            if (greatestFileVersion.isSnapshot()) {
                UpdateOptions updateOptions;
                FileInputStream is2;
                FileInputStream is1;
                block11: {
                    is1 = null;
                    is2 = null;
                    is1 = new FileInputStream(new File(this.backupRoot, greatestVersion.path));
                    is2 = new FileInputStream((File)currentJar.object);
                    if (!IOUtils.contentEquals((InputStream)is1, (InputStream)is2)) break block11;
                    log.debug((Object)"=> don't update (already installed)");
                    UpdateOptions updateOptions2 = null;
                    IOUtils.closeQuietly((InputStream)is1);
                    IOUtils.closeQuietly((InputStream)is2);
                    return updateOptions2;
                }
                try {
                    log.debug((Object)"=> update (newer SNAPSHOT)");
                    updateOptions = optToUpdate;
                }
                catch (IOException e) {
                    try {
                        throw new PackageException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is1);
                        IOUtils.closeQuietly(is2);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is1);
                IOUtils.closeQuietly((InputStream)is2);
                return updateOptions;
            }
            log.debug((Object)"=> don't update (already installed)");
            return null;
        }
        log.debug((Object)"Don't update (lower)");
        return null;
    }

    public File getRollbackTarget(RollbackOptions opt) {
        String entryKey = opt.getKey();
        JarUtils.Match<File> m = this.findInstalledJar(entryKey);
        if (m != null) {
            return (File)m.object;
        }
        log.trace((Object)("Could not find jar with key: " + entryKey));
        return null;
    }

    public void rollback(RollbackOptions opt) throws PackageException {
        boolean includeUpgradeOnly;
        Version versionToRollback;
        Entry entry = this.registry.get(opt.getKey());
        if (entry == null) {
            log.debug((Object)("Key not found in registry for: " + opt));
            return;
        }
        Version v = entry.getVersion(opt.getVersion());
        if (v == null) {
            v = entry.getVersion(STUDIO_SNAPSHOT_VERSION);
        }
        if (v == null) {
            log.debug((Object)("Version not found in registry for: " + opt));
            return;
        }
        Version lastVersion = entry.getLastVersion();
        boolean removeBackup = false;
        v.removePackage(opt.getPackageId());
        if (!v.hasPackages()) {
            entry.removeVersion(v);
            removeBackup = true;
        }
        if ((versionToRollback = entry.getLastVersion(includeUpgradeOnly = entry.hasBaseVersion() || entry.getLastVersion(false) != null)) == null) {
            if (entry.isEmpty()) {
                this.registry.remove(entry.getKey());
            }
            this.rollbackBaseVersion(entry, opt);
        } else if (versionToRollback != lastVersion) {
            this.rollbackVersion(entry, versionToRollback, opt);
        } else {
            Version greatest;
            JarUtils.Match<File> m = this.findInstalledJar(opt.getKey());
            if (m != null && entry.getVersion(m.version) == null && (greatest = entry.getGreatestVersion()) != null) {
                this.rollbackVersion(entry, greatest, opt);
            }
        }
        if (removeBackup) {
            this.removeBackup(v.getPath());
        }
    }

    protected void rollbackBaseVersion(Entry entry, RollbackOptions opt) throws PackageException {
        Version base = entry.getBaseVersion();
        if (base != null) {
            this.rollbackVersion(entry, base, opt);
            this.removeBackup(base.getPath());
        } else {
            JarUtils.Match<File> m = JarUtils.findJar(this.serverRoot, entry.getKey());
            if (m != null) {
                if (opt.isDeleteOnExit()) {
                    ((File)m.object).deleteOnExit();
                } else {
                    ((File)m.object).delete();
                }
            }
        }
    }

    protected void rollbackVersion(Entry entry, Version version, RollbackOptions opt) throws PackageException {
        File versionFile = this.getBackup(version.getPath());
        if (!versionFile.isFile()) {
            log.error((Object)("Could not rollback version " + version.getPath() + " since the backup file was not found"));
            return;
        }
        JarUtils.Match<File> m = this.findInstalledJar(entry.getKey());
        File oldFile = m != null ? (File)m.object : null;
        File targetFile = this.getTargetFile(version.getPath());
        this.deleteOldFile(targetFile, oldFile, opt.deleteOnExit);
        this.copy(versionFile, targetFile);
    }

    public String getServerRelativePath(File someFile) {
        String serverPath;
        String path;
        try {
            path = someFile.getCanonicalPath();
            serverPath = this.serverRoot.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get a canonical path. Fall back to absolute paths...", (Throwable)e);
            path = someFile.getAbsolutePath();
            serverPath = this.serverRoot.getAbsolutePath();
        }
        if (!serverPath.endsWith(File.separator)) {
            serverPath = serverPath.concat(File.separator);
        }
        if (path.startsWith(serverPath)) {
            return path.substring(serverPath.length());
        }
        return path;
    }

    public Entry createEntry(String key) throws PackageException {
        Entry entry = new Entry(key);
        JarUtils.Match<File> m = JarUtils.findJar(this.serverRoot, key);
        if (m != null) {
            String path = this.getServerRelativePath((File)m.object);
            Version base = new Version(m.version);
            base.setPath(path);
            entry.setBaseVersion(base);
            this.backupFile((File)m.object, path);
        }
        this.registry.put(key, entry);
        return entry;
    }

    protected void backupFile(File fileToBackup, String path) throws PackageException {
        try {
            File dst = new File(this.backupRoot, path);
            this.copy(fileToBackup, dst);
        }
        catch (PackageException e) {
            throw new PackageException("Failed to backup file: " + path, (Throwable)e);
        }
    }

    protected void removeBackup(String path) {
        File dst = new File(this.backupRoot, path);
        if (!dst.delete()) {
            dst.deleteOnExit();
        }
    }

    protected File getBackup(String path) {
        return new File(this.backupRoot, path);
    }

    protected File getTargetFile(String path) {
        return new File(this.serverRoot, path);
    }

    protected void copy(File src, File dst) throws PackageException {
        try {
            dst.getParentFile().mkdirs();
            File tmp = new File(dst.getPath() + ".tmp");
            FileUtils.copy((File)src, (File)tmp);
            if (!tmp.renameTo(dst)) {
                tmp.delete();
                FileUtils.copy((File)src, (File)dst);
            }
        }
        catch (IOException e) {
            throw new PackageException("Failed to copy file: " + src + " to " + dst, (Throwable)e);
        }
    }

    protected void deleteOldFile(File targetFile, File oldFile, boolean deleteOnExit) {
        if (oldFile == null || !oldFile.exists()) {
            return;
        }
        if (deleteOnExit) {
            if (targetFile.getName().equals(oldFile.getName())) {
                oldFile.delete();
            } else {
                oldFile.deleteOnExit();
            }
        } else {
            oldFile.delete();
        }
    }

    public JarUtils.Match<File> findInstalledJar(String key) {
        return JarUtils.findJar(this.serverRoot, key);
    }

    public JarUtils.Match<File> findBackupJar(String key) {
        return JarUtils.findJar(this.backupRoot, key);
    }

    public void doUpdate(File oldFile, UpdateOptions opt) throws PackageException {
        this.deleteOldFile(opt.targetFile, oldFile, opt.deleteOnExit);
        this.copy(opt.file, opt.targetFile);
        log.trace((Object)("Updated " + opt.targetFile));
    }
}

