/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable;
        if (throwable != null) {
            cause = throwable.getCause();
            while ((throwable = cause.getCause()) != null) {
                cause = throwable;
            }
        }
        return cause;
    }

    public static void checkInterrupt(Exception e) {
        if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (Thread.currentThread().isInterrupted()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static Exception unwrapInvoke(Exception e) {
        if (e instanceof InvocationTargetException) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            e = cause instanceof Exception ? (Exception)cause : new RuntimeException(cause);
        }
        ExceptionUtils.checkInterrupt(e);
        return e;
    }

    public static RuntimeException runtimeException(Exception e) {
        if ((e = ExceptionUtils.unwrapInvoke(e)) instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }
}

