/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter.base;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.PreviewAdapterManager;
import org.nuxeo.ecm.platform.preview.adapter.base.AbstractHtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.NothingToPreviewException;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.runtime.api.Framework;

public class ConverterBasedHtmlPreviewAdapter
extends AbstractHtmlPreviewAdapter {
    private static final Log log = LogFactory.getLog(ConverterBasedHtmlPreviewAdapter.class);
    protected String defaultFieldXPath;
    protected MimetypeRegistry mimeTypeService;

    public ConversionService getConversionService() {
        return (ConversionService)Framework.getService(ConversionService.class);
    }

    @Override
    protected PreviewAdapterManager getPreviewManager() {
        return (PreviewAdapterManager)Framework.getService(PreviewAdapterManager.class);
    }

    protected static String getMimeType(Blob blob) {
        if (blob == null) {
            return null;
        }
        String srcMT = blob.getMimeType();
        if (srcMT == null || srcMT.startsWith("application/octet-stream")) {
            try {
                MimetypeRegistry mtr = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                srcMT = mtr.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, "application/octet-stream");
                log.debug((Object)("mime type service returned " + srcMT));
            }
            catch (MimetypeDetectionException e) {
                log.warn((Object)"error while calling Mimetype service", (Throwable)e);
            }
        }
        return srcMT;
    }

    protected String getDefaultPreviewFieldXPath() {
        return this.defaultFieldXPath;
    }

    public void setDefaultPreviewFieldXPath(String xPath) {
        this.defaultFieldXPath = xPath;
    }

    @Override
    public List<Blob> getPreviewBlobs() throws PreviewException {
        return this.getPreviewBlobs(this.getDefaultPreviewFieldXPath());
    }

    @Override
    public List<Blob> getPreviewBlobs(String xpath) throws PreviewException {
        BlobHolder blobHolder2preview = this.getBlobHolder2preview(xpath);
        Blob blob2Preview = this.getBlob2preview(blobHolder2preview);
        ArrayList<Blob> blobResults = new ArrayList();
        String srcMT = ConverterBasedHtmlPreviewAdapter.getMimeType(blob2Preview);
        log.debug((Object)("Source type for HTML preview =" + srcMT));
        MimeTypePreviewer mtPreviewer = this.getPreviewManager().getPreviewer(srcMT);
        if (mtPreviewer != null) {
            blobResults = mtPreviewer.getPreview(blob2Preview, this.adaptedDoc);
            return blobResults;
        }
        String converterName = this.getConversionService().getConverterName(srcMT, "text/html");
        if (converterName == null) {
            log.debug((Object)"No dedicated converter found, using generic");
            converterName = "any2html";
        }
        try {
            BlobHolder result = this.getConversionService().convert(converterName, blobHolder2preview, null);
            this.setMimeType(result);
            return result.getBlobs();
        }
        catch (ConversionException e) {
            throw new PreviewException(e.getMessage(), e);
        }
    }

    private Blob getBlob2preview(BlobHolder blobHolder2preview) throws PreviewException {
        Blob blob2Preview = blobHolder2preview.getBlob();
        if (blob2Preview == null) {
            throw new NothingToPreviewException("Can not preview a document without blob");
        }
        return blob2Preview;
    }

    private BlobHolder getBlobHolder2preview(String xpath) {
        if (xpath == null || "default".equals(xpath)) {
            return (BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class);
        }
        return new DocumentBlobHolder(this.adaptedDoc, xpath);
    }

    protected void setMimeType(BlobHolder result) {
        for (Blob blob : result.getBlobs()) {
            if (blob.getMimeType() != null && !blob.getMimeType().startsWith("application/octet-stream") || !blob.getFilename().endsWith("html")) continue;
            String mimeTpye = ConverterBasedHtmlPreviewAdapter.getMimeType(blob);
            blob.setMimeType(mimeTpye);
        }
    }

    public String getMimeType(File file) throws ConversionException {
        try {
            return this.getMimeTypeService().getMimetypeFromFile(file);
        }
        catch (ConversionException e) {
            throw new ConversionException("Could not get MimeTypeRegistry");
        }
        catch (MimetypeNotFoundException e) {
            return "application/octet-stream";
        }
        catch (MimetypeDetectionException e) {
            return "application/octet-stream";
        }
    }

    public MimetypeRegistry getMimeTypeService() throws ConversionException {
        if (this.mimeTypeService == null) {
            this.mimeTypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return this.mimeTypeService;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean cachable() {
        return true;
    }

    @Override
    public boolean hasBlobToPreview() throws PreviewException {
        Blob blob2Preview;
        String xpath = this.getDefaultPreviewFieldXPath();
        try {
            blob2Preview = this.getBlob2preview(this.getBlobHolder2preview(xpath));
        }
        catch (NothingToPreviewException e) {
            return false;
        }
        return blob2Preview != null;
    }
}

