/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.preview.adapter.base.AbstractHtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class PreprocessedHtmlPreviewAdapter
extends AbstractHtmlPreviewAdapter {
    private static final Log log = LogFactory.getLog(PreprocessedHtmlPreviewAdapter.class);
    protected List<String> storedPreviewFieldsPaths = new ArrayList<String>();

    public PreprocessedHtmlPreviewAdapter(List<String> fieldsPaths) {
        this.storedPreviewFieldsPaths = fieldsPaths;
    }

    @Override
    public List<Blob> getPreviewBlobs() throws PreviewException {
        ArrayList<Blob> resultBlobs = new ArrayList<Blob>();
        for (String xpath : this.storedPreviewFieldsPaths) {
            try {
                Property prop = this.adaptedDoc.getProperty(xpath);
                if (prop.isComplex()) {
                    Blob blob = (Blob)prop.getValue();
                    try {
                        blob.getStream().reset();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                    resultBlobs.add(blob);
                    continue;
                }
                String data = (String)((Object)prop.getValue());
                resultBlobs.add(Blobs.createBlob((String)data));
            }
            catch (PropertyException e) {
                throw new PreviewException("Unable to get property " + xpath, e);
            }
        }
        return resultBlobs;
    }

    @Override
    public List<Blob> getPreviewBlobs(String xpath) throws PreviewException {
        return this.getPreviewBlobs();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean cachable() {
        return false;
    }

    @Override
    public boolean hasBlobToPreview() throws PreviewException {
        return this.getPreviewBlobs().size() > 0;
    }
}

