/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.helper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class PreviewHelper {
    public static final String PREVIEWURL_PREFIX = "restAPI/preview/";
    public static final String PREVIEWURL_DEFAULTXPATH = "default";
    protected static final String PDF_MIMETYPE = "application/pdf";
    protected static final String PDF_EXTENSION = ".pdf";
    protected static final Map<String, Boolean> hasPreviewByType = new ConcurrentHashMap<String, Boolean>();

    private PreviewHelper() {
    }

    public static String getPreviewURL(DocumentModel doc) {
        return PreviewHelper.getPreviewURL(doc, PREVIEWURL_DEFAULTXPATH);
    }

    public static String getPreviewURL(DocumentModel doc, String xpath) {
        if (xpath == null) {
            xpath = PREVIEWURL_DEFAULTXPATH;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PREVIEWURL_PREFIX);
        sb.append(doc.getRepositoryName());
        sb.append("/");
        sb.append(doc.getId());
        sb.append("/");
        sb.append(xpath);
        sb.append("/");
        return sb.toString();
    }

    public static DocumentRef getDocumentRefFromPreviewURL(String url) {
        if (url == null) {
            return null;
        }
        String[] urlParts = url.split(PREVIEWURL_PREFIX);
        String[] parts = urlParts[1].split("/");
        String strRef = parts[1];
        return new IdRef(strRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean typeSupportsPreview(DocumentModel doc) {
        String docType = doc.getType();
        if (hasPreviewByType.containsKey(docType)) {
            return hasPreviewByType.get(docType);
        }
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)doc.getAdapter(HtmlPreviewAdapter.class);
        if (adapter == null) {
            Map<String, Boolean> map = hasPreviewByType;
            synchronized (map) {
                hasPreviewByType.put(docType, false);
                return false;
            }
        }
        Map<String, Boolean> map = hasPreviewByType;
        synchronized (map) {
            hasPreviewByType.put(docType, true);
            return true;
        }
    }

    public static boolean docHasBlobToPreview(DocumentModel document) throws PreviewException {
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)document.getAdapter(HtmlPreviewAdapter.class);
        return adapter == null ? false : adapter.hasBlobToPreview();
    }

    public static String getViewerURL(DocumentModel doc, String xpath, Blob blob, String baseURL) {
        baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
        String fileURL = String.format("%s/api/v1/id/%s/@blob/%s", baseURL, doc.getId(), PreviewHelper.isBlobHolder(doc, xpath) ? "blobholder:0" : xpath);
        StringBuilder sb = new StringBuilder();
        sb.append("viewer/web/viewer.html?file=");
        sb.append(fileURL);
        if (!PreviewHelper.isPDF(blob)) {
            sb.append("/@convert?");
            sb.append(URIUtils.quoteURIPathToken((String)"format=pdf"));
        }
        return sb.toString();
    }

    public static boolean isPDF(Blob blob) {
        String mimeType = blob.getMimeType();
        if (StringUtils.isNotBlank((String)mimeType) && PDF_MIMETYPE.equals(mimeType)) {
            return true;
        }
        String filename = blob.getFilename();
        return StringUtils.isNotBlank((String)filename) && filename.endsWith(PDF_EXTENSION);
    }

    private static boolean isBlobHolder(DocumentModel doc, String xpath) {
        DocumentBlobHolder bh = (DocumentBlobHolder)doc.getAdapter(BlobHolder.class);
        return bh != null && bh.getXpath().equals(xpath);
    }
}

