/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.logging.JavaUtilLoggingHelper;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.RuntimeExtension;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentManagerImpl;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.osgi.framework.Bundle;

public abstract class AbstractRuntimeService
implements RuntimeService {
    public static final String REDIRECT_JUL = "org.nuxeo.runtime.redirectJUL";
    public static final String REDIRECT_JUL_THRESHOLD = "org.nuxeo.runtime.redirectJUL.threshold";
    private static final Log log = LogFactory.getLog(RuntimeService.class);
    protected boolean isStarted = false;
    protected boolean isShuttingDown = false;
    protected File workingDir;
    protected CryptoProperties properties = new CryptoProperties(System.getProperties());
    protected ComponentManager manager;
    protected final RuntimeContext context;
    protected final List<RuntimeExtension> extensions = new ArrayList<RuntimeExtension>();
    protected final List<String> warnings = new ArrayList<String>();

    protected AbstractRuntimeService(DefaultRuntimeContext context) {
        this(context, null);
    }

    protected AbstractRuntimeService(DefaultRuntimeContext context, Map<String, String> properties) {
        String errs;
        this.context = context;
        context.setRuntime(this);
        if (properties != null) {
            this.properties.putAll(properties);
        }
        if ((errs = System.getProperty("org.nuxeo.runtime.deployment.errors")) != null) {
            this.warnings.addAll(Arrays.asList(errs.split("\n")));
            System.clearProperty("org.nuxeo.runtime.deployment.errors");
        }
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    protected ComponentManager createComponentManager() {
        return new ComponentManagerImpl(this);
    }

    protected static URL getBuiltinFeatureURL() {
        return Thread.currentThread().getContextClassLoader().getResource("org/nuxeo/runtime/nx-feature.xml");
    }

    @Override
    public synchronized void start() {
        if (!this.isStarted) {
            if (Boolean.parseBoolean(this.getProperty(REDIRECT_JUL, "false"))) {
                Level threshold = Level.parse(this.getProperty(REDIRECT_JUL_THRESHOLD, "INFO").toUpperCase());
                JavaUtilLoggingHelper.redirectToApacheCommons((Level)threshold);
            }
            log.info((Object)("Starting Nuxeo Runtime service " + this.getName() + "; version: " + this.getVersion()));
            this.manager = this.createComponentManager();
            Framework.sendEvent(new RuntimeServiceEvent(0, this));
            this.doStart();
            this.startExtensions();
            this.isStarted = true;
            Framework.sendEvent(new RuntimeServiceEvent(1, this));
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isShuttingDown = true;
        try {
            log.info((Object)("Stopping Nuxeo Runtime service " + this.getName() + "; version: " + this.getVersion()));
            Framework.sendEvent(new RuntimeServiceEvent(2, this));
            try {
                this.stopExtensions();
                this.doStop();
                this.manager.shutdown();
            }
            finally {
                this.isStarted = false;
                Framework.sendEvent(new RuntimeServiceEvent(3, this));
                this.manager = null;
            }
            JavaUtilLoggingHelper.reset();
        }
        finally {
            this.isShuttingDown = false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    @Override
    public File getHome() {
        return this.workingDir;
    }

    public void setHome(File home) {
        this.workingDir = home;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    public CryptoProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    @Override
    public String getProperty(String name, String defValue) {
        String value = this.properties.getProperty(name, defValue);
        if (value == null || ("${" + name + "}").equals(value)) {
            return value;
        }
        return this.expandVars(value);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.setProperty(name, value.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getName()).append(" version ").append(this.getVersion().toString()).toString();
    }

    @Override
    public Object getComponent(String name) {
        ComponentInstance co = this.getComponentInstance(name);
        return co != null ? co.getInstance() : null;
    }

    @Override
    public Object getComponent(ComponentName name) {
        ComponentInstance co = this.getComponentInstance(name);
        return co != null ? co.getInstance() : null;
    }

    @Override
    public ComponentInstance getComponentInstance(String name) {
        return this.manager.getComponent(new ComponentName(name));
    }

    @Override
    public ComponentInstance getComponentInstance(ComponentName name) {
        return this.manager.getComponent(name);
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.manager;
    }

    @Override
    public RuntimeContext getContext() {
        return this.context;
    }

    protected void startExtensions() {
        for (RuntimeExtension ext : this.extensions) {
            ext.start();
        }
    }

    protected void stopExtensions() {
        for (RuntimeExtension ext : this.extensions) {
            ext.stop();
        }
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        return this.manager.getService(serviceClass);
    }

    @Override
    public String expandVars(String expression) {
        return new TextTemplate((Properties)this.properties).processText(expression);
    }

    @Override
    public File getBundleFile(Bundle bundle) {
        return null;
    }

    @Override
    public Bundle getBundle(String symbolicName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean getStatusMessage(StringBuilder msg) {
        String hr = "======================================================================";
        if (!this.warnings.isEmpty()) {
            msg.append(hr).append("\n= Component Loading Errors:\n");
            for (String warning : this.warnings) {
                msg.append("  * ").append(warning).append('\n');
            }
        }
        Map<ComponentName, Set<ComponentName>> pendingRegistrations = this.manager.getPendingRegistrations();
        Collection<ComponentName> unstartedRegistrations = this.manager.getActivatingRegistrations();
        unstartedRegistrations.addAll(this.manager.getStartFailureRegistrations());
        msg.append(hr).append("\n= Component Loading Status: Pending: ").append(pendingRegistrations.size()).append(" / Unstarted: ").append(unstartedRegistrations.size()).append(" / Total: ").append(this.manager.getRegistrations().size()).append('\n');
        for (Map.Entry<ComponentName, Set<ComponentName>> e : pendingRegistrations.entrySet()) {
            msg.append("  * ").append(e.getKey()).append(" requires ").append(e.getValue()).append('\n');
        }
        for (ComponentName componentName : unstartedRegistrations) {
            msg.append("  - ").append(componentName).append('\n');
        }
        msg.append(hr);
        return this.warnings.isEmpty() && pendingRegistrations.isEmpty() && unstartedRegistrations.isEmpty();
    }
}

