/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.util.IllegalFormatException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class OSGiComponentLoader
implements SynchronousBundleListener {
    private static final Log log = LogFactory.getLog(OSGiComponentLoader.class);
    private final OSGiRuntimeService runtime;

    public OSGiComponentLoader(OSGiRuntimeService runtime) {
        this.runtime = runtime;
        this.install();
    }

    public void install() {
        BundleContext ctx = this.runtime.getBundleContext();
        ctx.addBundleListener((BundleListener)this);
        Bundle[] bundles = ctx.getBundles();
        int mask = 40;
        for (Bundle bundle : bundles) {
            String name = bundle.getSymbolicName();
            this.runtime.bundles.put(name, bundle);
            int state = bundle.getState();
            OSGiComponentLoader.bundleDebug("Install bundle: %s " + OSGiComponentLoader.bundleStateAsString(state), name);
            if ((state & mask) != 0) {
                if (OSGiRuntimeService.getComponentsList(bundle) != null) {
                    OSGiComponentLoader.bundleDebug("Install bundle: %s component list: " + OSGiRuntimeService.getComponentsList(bundle), name);
                    try {
                        this.runtime.createContext(bundle);
                    }
                    catch (RuntimeException e) {
                        log.warn((Object)("Failed to load components for bundle: " + name), (Throwable)e);
                    }
                    continue;
                }
                OSGiComponentLoader.bundleDebug("Install bundle: %s has no components", name);
                continue;
            }
            OSGiComponentLoader.bundleDebug("Install bundle: %s is not STARTING or ACTIVE, so no context was created", name);
        }
    }

    public void uninstall() {
        this.runtime.getBundleContext().removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        String name = event.getBundle().getSymbolicName();
        int type = event.getType();
        OSGiComponentLoader.bundleDebug("Bundle changed: %s " + OSGiComponentLoader.bundleEventAsString(type), name);
        try {
            Bundle bundle = event.getBundle();
            String componentsList = OSGiRuntimeService.getComponentsList(bundle);
            switch (type) {
                case 1: {
                    this.runtime.bundles.put(bundle.getSymbolicName(), bundle);
                    break;
                }
                case 16: {
                    this.runtime.bundles.remove(bundle.getSymbolicName());
                    break;
                }
                case 128: 
                case 512: {
                    if (componentsList != null) {
                        OSGiComponentLoader.bundleDebug("Bundle changed: %s STARTING with components: " + componentsList, name);
                        this.runtime.createContext(bundle);
                        break;
                    }
                    OSGiComponentLoader.bundleDebug("Bundle changed: %s STARTING with no components", name);
                    break;
                }
                case 4: 
                case 64: {
                    if (componentsList != null) {
                        OSGiComponentLoader.bundleDebug("Bundle changed: %s STOPPING with components: " + componentsList, name);
                        this.runtime.destroyContext(bundle);
                        break;
                    }
                    OSGiComponentLoader.bundleDebug("Bundle changed: %s STOPPING with no components", name);
                }
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String bundleStateAsString(int state) {
        LinkedList<String> list = new LinkedList<String>();
        if ((state & 1) != 0) {
            list.add("UNINSTALLED");
        }
        if ((state & 2) != 0) {
            list.add("INSTALLED");
        }
        if ((state & 4) != 0) {
            list.add("RESOLVED");
        }
        if ((state & 8) != 0) {
            list.add("STARTING");
        }
        if ((state & 0x10) != 0) {
            list.add("STOPPING");
        }
        if ((state & 0x20) != 0) {
            list.add("ACTIVE");
        }
        return '[' + StringUtils.join(list, (char)',') + ']';
    }

    public static String bundleEventAsString(int eventType) {
        switch (eventType) {
            case 1: {
                return "INSTALLED";
            }
            case 2: {
                return "STARTED";
            }
            case 128: {
                return "STARTING";
            }
            case 4: {
                return "STOPPED";
            }
            case 16: {
                return "UNINSTALLED";
            }
            case 8: {
                return "UPDATED";
            }
            case 512: {
                return "LAZY_ACTIVATION";
            }
            case 32: {
                return "RESOLVED";
            }
            case 64: {
                return "UNRESOLVED";
            }
            case 256: {
                return "STOPPING";
            }
        }
        return "UNKNOWN_OSGI_EVENT_TYPE_" + eventType;
    }

    public static void bundleDebug(String msg, String name) {
        if (log.isDebugEnabled()) {
            try {
                msg = String.format(msg, name);
            }
            catch (IllegalFormatException illegalFormatException) {
                // empty catch block
            }
            log.debug((Object)msg);
        }
    }
}

