/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.EvaluationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class MetaValueExpression
extends ValueExpression
implements Serializable {
    private static final long serialVersionUID = -2721042412903607760L;
    private static final Log log = LogFactory.getLog(MetaValueExpression.class);
    private ValueExpression originalValueExpression;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;

    public MetaValueExpression(ValueExpression originalValueExpression) {
        this(originalValueExpression, null, null);
    }

    public MetaValueExpression(ValueExpression originalValueExpression, FunctionMapper fnMapper, VariableMapper varMapper) {
        this.originalValueExpression = originalValueExpression;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaValueExpression)) {
            return false;
        }
        MetaValueExpression other = (MetaValueExpression)obj;
        return this.originalValueExpression.equals((Object)other.originalValueExpression);
    }

    public int hashCode() {
        return this.originalValueExpression.hashCode();
    }

    public String getExpressionString() {
        return this.originalValueExpression.getExpressionString();
    }

    public boolean isLiteralText() {
        return this.originalValueExpression.isLiteralText();
    }

    public Class<?> getExpectedType() {
        return this.originalValueExpression.getExpectedType();
    }

    private ELContext getLocalContext(ELContext context) {
        if (this.fnMapper == null && this.varMapper == null) {
            return context;
        }
        return new EvaluationContext(context, this.fnMapper, this.varMapper);
    }

    public Class<?> getType(ELContext context) {
        ELContext nxcontext = this.getLocalContext(context);
        return this.originalValueExpression.getType(nxcontext);
    }

    public Object getValue(ELContext context) {
        ELContext nxcontext = this.getLocalContext(context);
        Object res = null;
        if (this.originalValueExpression != null && (res = this.originalValueExpression.getValue(nxcontext)) instanceof String) {
            String expression = (String)res;
            if (ComponentTagUtils.isValueReference(expression)) {
                FacesContext faces = FacesContext.getCurrentInstance();
                Application app = faces.getApplication();
                ExpressionFactory factory = app.getExpressionFactory();
                ValueExpression newExpr = factory.createValueExpression(nxcontext, expression, Object.class);
                try {
                    res = newExpr.getValue(nxcontext);
                }
                catch (ELException err) {
                    log.error((Object)String.format("Error processing expression %s: %s", new Object[]{expression, err}));
                    res = null;
                }
            } else {
                res = expression;
            }
        }
        return res;
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public void setValue(ELContext context, Object value) {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.originalValueExpression = (ValueExpression)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.originalValueExpression);
    }
}

