/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.component.UISelectItems;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItemComparator;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItemsFactory;

public class UIDirectorySelectItems
extends UISelectItems {
    private static final Log log = LogFactory.getLog(UIDirectorySelectItems.class);
    public static final String COMPONENT_TYPE = UIDirectorySelectItems.class.getName();

    public Long getItemOrdering() {
        return (Long)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.itemOrdering));
    }

    public void setItemOrdering(Long itemOrdering) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.itemOrdering), (Object)itemOrdering);
    }

    public String getKeySeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.keySeparator), (Object)"/");
    }

    public void setKeySeparator(String keySeparator) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.keySeparator), (Object)keySeparator);
    }

    public String getDirectoryName() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.directoryName));
    }

    public void setDirectoryName(String directoryName) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.directoryName), (Object)directoryName);
    }

    public SelectItem[] getAllValues() {
        return (SelectItem[])this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.allValues));
    }

    public void setAllValues(SelectItem[] allValues) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.allValues), (Object)allValues);
    }

    public boolean isDisplayAll() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.displayAll), (Object)Boolean.TRUE);
    }

    public void setDisplayAll(boolean displayAll) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.displayAll), (Object)displayAll);
    }

    public boolean isDisplayObsoleteEntries() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.displayObsoleteEntries), (Object)Boolean.FALSE);
    }

    public void setDisplayObsoleteEntries(boolean displayObsoleteEntries) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.displayObsoleteEntries), (Object)displayObsoleteEntries);
    }

    public String getFilter() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.filter));
    }

    public void setFilter(String filter) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.filter), (Object)filter);
    }

    @Override
    public boolean isLocalize() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.localize), (Object)Boolean.FALSE);
    }

    @Override
    public void setLocalize(boolean localize) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.localize), (Object)localize);
    }

    @Override
    public boolean isdbl10n() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)DirPropertyKeys.dbl10n), (Object)Boolean.FALSE);
    }

    @Override
    public void setdbl10n(boolean dbl10n) {
        this.getStateHelper().put((Serializable)((Object)DirPropertyKeys.dbl10n), (Object)dbl10n);
    }

    @Override
    public Object getValue() {
        List<DirectorySelectItem> items;
        DirectorySelectItemsFactory f = new DirectorySelectItemsFactory(){

            @Override
            protected String getVar() {
                return UIDirectorySelectItems.this.getVar();
            }

            @Override
            protected DirectorySelectItem createSelectItem(String label, Long ordering) {
                return UIDirectorySelectItems.this.createSelectItem(label, ordering);
            }

            @Override
            protected String getDirectoryName() {
                return UIDirectorySelectItems.this.getDirectoryName();
            }

            @Override
            protected boolean isDisplayObsoleteEntries() {
                return UIDirectorySelectItems.this.isDisplayObsoleteEntries();
            }

            @Override
            protected String getFilter() {
                return UIDirectorySelectItems.this.getFilter();
            }

            @Override
            protected String[] retrieveSelectEntryId() {
                return UIDirectorySelectItems.this.retrieveSelectEntryId();
            }

            @Override
            protected Object retrieveItemLabel() {
                return UIDirectorySelectItems.this.getItemLabel();
            }

            @Override
            protected String retrieveLabelFromEntry(DocumentModel directoryEntry) {
                return UIDirectorySelectItems.this.retrieveLabelFromEntry(directoryEntry);
            }

            @Override
            protected Long retrieveOrderingFromEntry(DocumentModel directoryEntry) {
                return UIDirectorySelectItems.this.retrieveOrderingFromEntry(directoryEntry);
            }
        };
        if (this.isDisplayAll()) {
            items = f.createAllDirectorySelectItems();
        } else {
            Object value = this.getStateHelper().eval((Serializable)((Object)UISelectItems.PropertyKeys.value));
            items = f.createDirectorySelectItems(value, this.getKeySeparator());
        }
        String ordering = this.getOrdering();
        boolean caseSensitive = this.isCaseSensitive();
        if (!StringUtils.isBlank((String)ordering)) {
            Collections.sort(items, new DirectorySelectItemComparator(ordering, caseSensitive));
        }
        SelectItem[] res = items.toArray(new DirectorySelectItem[0]);
        if (this.isDisplayAll()) {
            this.setAllValues(res);
        }
        return res;
    }

    protected DirectorySelectItem createSelectItem(String label, Long ordering) {
        String labelSuffix;
        String labelPrefix;
        String value;
        if (!this.isItemRendered()) {
            return null;
        }
        Object valueObject = this.getItemValue();
        String string = value = valueObject == null ? null : valueObject.toString();
        if (this.isDisplayIdAndLabel() && label != null) {
            label = value + this.getDisplayIdAndLabelSeparator() + label;
        }
        if (StringUtils.isBlank((String)label)) {
            label = value;
        }
        if (!StringUtils.isBlank((String)(labelPrefix = this.getItemLabelPrefix()))) {
            label = labelPrefix + this.getItemLabelPrefixSeparator() + label;
        }
        if (!StringUtils.isBlank((String)(labelSuffix = this.getItemLabelSuffix()))) {
            label = label + this.getItemLabelSuffixSeparator() + labelSuffix;
        }
        return new DirectorySelectItem(value, label, ordering == null ? 0L : ordering, this.isItemDisabled(), this.isItemEscaped());
    }

    protected String[] retrieveSelectEntryId() {
        String id;
        Object itemValue = this.getItemValue();
        String string = id = itemValue != null ? itemValue.toString() : null;
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        String keySeparator = this.getKeySeparator();
        if (!StringUtils.isBlank((String)keySeparator)) {
            String[] split = id.split(keySeparator);
            return split;
        }
        return new String[]{id};
    }

    protected String retrieveLabelFromEntry(DocumentModel docEntry) {
        if (docEntry == null) {
            return null;
        }
        String schema = docEntry.getSchemas()[0];
        Object labelObject = this.getItemLabel();
        String label = labelObject != null ? labelObject.toString() : null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        Locale locale = ctx.getViewRoot().getLocale();
        if (StringUtils.isBlank((String)label)) {
            if (this.isLocalize() && this.isdbl10n()) {
                String defaultPattern = "label_en";
                String pattern = "label_" + locale.getLanguage();
                label = (String)docEntry.getProperty(schema, pattern);
                if (StringUtils.isBlank((String)label)) {
                    label = (String)docEntry.getProperty(schema, defaultPattern);
                }
                if (StringUtils.isBlank((String)label)) {
                    label = docEntry.getId();
                    log.warn((Object)("Could not find label column for entry " + label + " (falling back on entry id)"));
                }
            } else {
                label = (String)docEntry.getProperties(schema).get("label");
                if (this.isLocalize()) {
                    label = this.translate(ctx, locale, label);
                }
            }
        } else if (this.isLocalize()) {
            label = this.translate(ctx, locale, label);
        }
        return label;
    }

    protected Long retrieveOrderingFromEntry(DocumentModel docEntry) {
        Long ordering = this.getItemOrdering();
        if (ordering != null) {
            return ordering;
        }
        if (docEntry == null) {
            return null;
        }
        String schema = docEntry.getSchemas()[0];
        try {
            ordering = (Long)docEntry.getProperties(schema).get("ordering");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return ordering;
    }

    @Override
    protected String translate(FacesContext context, Locale locale, String label) {
        if (StringUtils.isBlank((String)label)) {
            return label;
        }
        String bundleName = context.getApplication().getMessageBundle();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }

    protected static enum DirPropertyKeys {
        directoryName,
        keySeparator,
        itemOrdering,
        allValues,
        displayAll,
        displayObsoleteEntries,
        filter,
        localize,
        dbl10n;

    }
}

