/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.Serializable;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="selectionActions")
@Scope(value=ScopeType.EVENT)
public class SelectionActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SelectionActionsBean.class);
    @RequestParameter
    protected String leftSelect;
    @RequestParameter
    protected String leftItems;
    @RequestParameter
    protected String rightSelect;
    @RequestParameter
    protected String rightItems;
    @RequestParameter
    protected String submittedList;
    @RequestParameter
    protected String selectorId;
    @RequestParameter
    protected String valueHolderId;
    @RequestParameter
    protected Integer lookupLevel;
    protected String lookupLevelValue;
    @RequestParameter
    protected String selectedValue;
    protected String selectedValueHolder;

    public String getLookupLevelValue() {
        return this.lookupLevelValue;
    }

    public void setLookupLevelValue(String lookupLevelValue) {
        this.lookupLevelValue = lookupLevelValue;
    }

    protected int computeLookupLevel() {
        if (this.lookupLevel != null) {
            return this.lookupLevel;
        }
        String setValue = this.getLookupLevelValue();
        if (setValue != null) {
            return Integer.valueOf(setValue);
        }
        return 1;
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public String getSelectedValueHolder() {
        return this.selectedValueHolder;
    }

    public void setSelectedValueHolder(String selectedValueHolder) {
        this.selectedValueHolder = selectedValueHolder;
    }

    public SelectItem[] getEmptySelection() {
        return new SelectItem[0];
    }

    protected boolean checkRightComponents() {
        String logPrefix = "Check right components: ";
        if (this.rightSelect == null) {
            log.error((Object)(logPrefix + "No select component name"));
            return false;
        }
        if (this.rightItems == null) {
            log.error((Object)(logPrefix + "No items component name"));
            return false;
        }
        return true;
    }

    protected boolean checkLeftComponents() {
        String logPrefix = "Check left components: ";
        if (this.leftSelect == null) {
            log.error((Object)(logPrefix + "No select component name"));
            return false;
        }
        if (this.leftItems == null) {
            log.error((Object)(logPrefix + "No items component name"));
            return false;
        }
        return true;
    }

    protected boolean checkSubmittedList() {
        String logPrefix = "Check submitted list: ";
        if (this.submittedList == null) {
            log.error((Object)(logPrefix + "No component name"));
            return false;
        }
        return true;
    }

    public void shiftSelected(ShiftType stype, ActionEvent event) {
        if (!this.checkRightComponents() || !this.checkSubmittedList()) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent rightSelectComp = eventComp.findComponent(this.rightSelect);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (rightSelectComp instanceof UISelectMany && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems targetItems = (UISelectItems)rightItemsComp;
            UISelectMany targetComp = (UISelectMany)rightSelectComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            switch (stype) {
                case UP: {
                    ComponentUtils.shiftItemsUp(targetComp, targetItems, hiddenTargetList);
                    break;
                }
                case DOWN: {
                    ComponentUtils.shiftItemsDown(targetComp, targetItems, hiddenTargetList);
                    break;
                }
                case FIRST: {
                    ComponentUtils.shiftItemsFirst(targetComp, targetItems, hiddenTargetList);
                    break;
                }
                case LAST: {
                    ComponentUtils.shiftItemsLast(targetComp, targetItems, hiddenTargetList);
                }
            }
        }
    }

    public void shiftSelectedUp(ActionEvent event) {
        this.shiftSelected(ShiftType.UP, event);
    }

    public void shiftSelectedDown(ActionEvent event) {
        this.shiftSelected(ShiftType.DOWN, event);
    }

    public void shiftSelectedFirst(ActionEvent event) {
        this.shiftSelected(ShiftType.FIRST, event);
    }

    public void shiftSelectedLast(ActionEvent event) {
        this.shiftSelected(ShiftType.LAST, event);
    }

    public void addToSelection(ActionEvent event) {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftSelectComp = eventComp.findComponent(this.leftSelect);
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftSelectComp instanceof UISelectMany && leftItemsComp instanceof UISelectItems && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectMany sourceSelect = (UISelectMany)leftSelectComp;
            UISelectItems sourceItems = (UISelectItems)leftItemsComp;
            UISelectItems targetItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveItems(sourceSelect, sourceItems, targetItems, hiddenTargetList, true);
        }
    }

    public void removeFromSelection(ActionEvent event) {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightSelectComp = eventComp.findComponent(this.rightSelect);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftItemsComp instanceof UISelectItems && rightSelectComp instanceof UISelectMany && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems leftItems = (UISelectItems)leftItemsComp;
            UISelectMany rightSelect = (UISelectMany)rightSelectComp;
            UISelectItems rightItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveItems(rightSelect, rightItems, leftItems, hiddenTargetList, false);
        }
    }

    public void addAllToSelection(ActionEvent event) {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftItemsComp instanceof UISelectItems && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems sourceItems = (UISelectItems)leftItemsComp;
            UISelectItems targetItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveAllItems(sourceItems, targetItems, hiddenTargetList, true);
        }
    }

    public UISelectMany getSourceSelectComponent(ActionEvent event) {
        if (this.leftSelect == null) {
            log.warn((Object)"Unable to find leftSelect component. Param 'leftSelect' not sent in request");
            return null;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftSelectComp = eventComp.findComponent(this.leftSelect);
        if (leftSelectComp instanceof UISelectMany) {
            return (UISelectMany)leftSelectComp;
        }
        return null;
    }

    public UISelectItems getSourceSelectItems(ActionEvent event) {
        if (this.leftItems == null) {
            log.warn((Object)"Unable to find leftItems component. Param 'leftItems' not sent in request");
            return null;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        if (leftItemsComp instanceof UISelectItems) {
            return (UISelectItems)leftItemsComp;
        }
        return null;
    }

    public void removeAllFromSelection(ActionEvent event) {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftItemsComp instanceof UISelectItems && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems leftItems = (UISelectItems)leftItemsComp;
            UISelectItems rightItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveAllItems(rightItems, leftItems, hiddenTargetList, false);
        }
    }

    @Deprecated
    public void onSelection(ActionEvent event) {
        log.warn((Object)String.format("The method #onSelection(ActionEvent) on component 'selectionActions' at '%s' is deprecated, please use #onSelection(AjaxBehaviorEvent) instead", this.getClass().getName()));
        this.onSelection((FacesEvent)event);
    }

    public void onSelection(AjaxBehaviorEvent event) {
        this.onSelection((FacesEvent)event);
    }

    protected void onSelection(FacesEvent event) {
        UIComponent component = event.getComponent();
        Object value = this.retrieveSourceComponentValue(component, this.selectorId);
        UIComponent base = ComponentUtils.getBase(component);
        ValueHolder valueHolderComp = ComponentUtils.getComponent(base, this.valueHolderId, ValueHolder.class);
        this.setTargetComponentValue(valueHolderComp, value);
    }

    @Deprecated
    public void onClick(ActionEvent event) {
        log.warn((Object)String.format("The method #onClick(ActionEvent) on component 'selectionActions' at '%s' is deprecated, please use #onClick(AjaxBehaviorEvent) instead", this.getClass().getName()));
        this.onClick((FacesEvent)event);
    }

    public void onClick(AjaxBehaviorEvent event) {
        this.onClick((FacesEvent)event);
    }

    protected void onClick(FacesEvent event) {
        String selectedValueHolder;
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        EditableValueHolder hiddenSelector = null;
        UIComponent base = this.retrieveBase(component, this.computeLookupLevel());
        if (this.valueHolderId != null) {
            hiddenSelector = ComponentUtils.getComponent(base, this.valueHolderId, EditableValueHolder.class);
        }
        if (hiddenSelector == null && (selectedValueHolder = this.getSelectedValueHolder()) != null) {
            hiddenSelector = ComponentUtils.getComponent(base, selectedValueHolder, EditableValueHolder.class);
        }
        if (hiddenSelector != null) {
            String selectedValue = this.getSelectedValue();
            this.setTargetComponentValue((ValueHolder)hiddenSelector, selectedValue);
        }
    }

    protected UIComponent retrieveBase(UIComponent anchor, int lookupLevel) {
        UIComponent base = ComponentUtils.getBase(anchor);
        if (lookupLevel > 1) {
            for (int i = 0; i < lookupLevel - 1; ++i) {
                base = ComponentUtils.getBase(base);
            }
        }
        return base;
    }

    public void setValueFromComponent(AjaxBehaviorEvent event) {
        this.setValueFromComponent((FacesEvent)event);
    }

    public void setValueFromComponent(ActionEvent event) {
        this.setValueFromComponent((FacesEvent)event);
    }

    protected void setValueFromComponent(FacesEvent event) {
        UIComponent anchor = event.getComponent();
        String sourceCompId = this.getStringAttribute(anchor, "sourceComponentId", true);
        Object value = this.retrieveSourceComponentValue(anchor, sourceCompId);
        String targetCompId = this.getStringAttribute(anchor, "targetComponentId", true);
        ValueHolder targetComp = ComponentUtils.getComponent(anchor, targetCompId, ValueHolder.class);
        this.setTargetComponentValue(targetComp, value);
    }

    public void setStaticValue(AjaxBehaviorEvent event) {
        this.setStaticValue((FacesEvent)event);
    }

    public void setStaticValue(ActionEvent event) {
        this.setStaticValue((FacesEvent)event);
    }

    protected void setStaticValue(FacesEvent event) {
        UIComponent anchor = event.getComponent();
        Object value = anchor.getAttributes().get("selectedValue");
        String targetCompId = this.getStringAttribute(anchor, "targetComponentId", true);
        ValueHolder targetComp = ComponentUtils.getComponent(anchor, targetCompId, ValueHolder.class);
        this.setTargetComponentValue(targetComp, value);
    }

    protected String getStringAttribute(UIComponent component, String name, boolean required) {
        Object value = component.getAttributes().get(name);
        if (required && value == null) {
            throw new IllegalArgumentException(String.format("Component attribute with name '%s' cannot be null: %s", name, value));
        }
        if (value == null || value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException(String.format("Component attribute with name '%s' is not a String: %s", name, value));
    }

    protected Object retrieveSourceComponentValue(UIComponent base, String targetId) {
        ValueHolder selectComp = ComponentUtils.getComponent(base, targetId, ValueHolder.class);
        if (selectComp != null) {
            Object value;
            if (selectComp instanceof EditableValueHolder) {
                value = ((EditableValueHolder)selectComp).getSubmittedValue();
                if (value == null) {
                    value = selectComp.getValue();
                }
            } else {
                value = selectComp.getValue();
            }
            return value;
        }
        return null;
    }

    protected void setTargetComponentValue(ValueHolder target, Object value) {
        if (target != null) {
            if (target instanceof EditableValueHolder) {
                ((EditableValueHolder)target).setSubmittedValue(value);
            } else {
                target.setValue(value);
            }
        }
    }

    public static enum ShiftType {
        FIRST,
        UP,
        DOWN,
        LAST;

    }
}

