/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.servlet.http.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class FileUtils {
    private static final Log log = LogFactory.getLog(FileUtils.class);

    private FileUtils() {
    }

    public static Blob createSerializableBlob(InputStream in, String filename, String mimeType) {
        Blob blob = null;
        try {
            blob = Blobs.createBlob((InputStream)in, (String)mimeType);
            if (filename != null) {
                filename = FileUtils.getCleanFileName(filename);
            }
            blob.setFilename(filename);
            MimetypeRegistry mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            String detectedMimeType = mimeService.getMimetypeFromFilenameAndBlobWithDefault(filename, blob, null);
            if (detectedMimeType == null) {
                detectedMimeType = mimeType != null ? mimeType : "application/octet-stream";
            }
            blob.setMimeType(detectedMimeType);
        }
        catch (MimetypeDetectionException e) {
            log.error((Object)String.format("could not fetch mimetype for file %s", filename), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return blob;
    }

    public static Blob createBlob(Part part) throws IOException {
        Blob blob = null;
        try {
            Method getStoreLocationMethod;
            File file;
            Method isInMemoryMethod;
            boolean inMemory;
            Field fileItemField = part.getClass().getDeclaredField("fileItem");
            fileItemField.setAccessible(true);
            Object fileItem = fileItemField.get(part);
            if (fileItem != null && !(inMemory = ((Boolean)(isInMemoryMethod = fileItem.getClass().getDeclaredMethod("isInMemory", new Class[0])).invoke(fileItem, new Object[0])).booleanValue()) && (file = (File)(getStoreLocationMethod = fileItem.getClass().getDeclaredMethod("getStoreLocation", new Class[0])).invoke(fileItem, new Object[0])) != null) {
                blob = Blobs.createBlobWithExtension(null);
                Files.move(file.toPath(), blob.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
            // empty catch block
        }
        if (blob == null) {
            blob = Blobs.createBlob((InputStream)part.getInputStream());
        }
        blob.setMimeType(part.getContentType());
        blob.setFilename(FileUtils.retrieveFilename(part));
        return blob;
    }

    public static String retrieveFilename(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return FileUtils.getCleanFileName(filename);
        }
        return null;
    }

    public static String getCleanFileName(String filename) {
        int lastUnixSeparator;
        String res = null;
        int lastWinSeparator = filename.lastIndexOf(92);
        int lastSeparator = Math.max(lastWinSeparator, lastUnixSeparator = filename.lastIndexOf(47));
        res = lastSeparator != -1 ? filename.substring(lastSeparator + 1, filename.length()) : filename;
        return res;
    }

    public static void configureFileBlob(Blob blob) {
        String detectedMimeType;
        MimetypeRegistry mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        try {
            detectedMimeType = mimeService.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, null);
        }
        catch (MimetypeDetectionException e) {
            log.error((Object)("could not fetch mimetype for file " + blob.getFilename()), (Throwable)e);
            return;
        }
        if (detectedMimeType == null) {
            if (blob.getMimeType() != null) {
                return;
            }
            detectedMimeType = "application/octet-stream";
        }
        blob.setMimeType(detectedMimeType);
    }
}

