/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.cache.AbstractCache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.Jedis;

public class RedisCache
extends AbstractCache {
    protected static final String UTF_8 = "UTF-8";
    protected static final Log log = LogFactory.getLog(RedisCache.class);
    protected final RedisExecutor executor = (RedisExecutor)Framework.getService(RedisExecutor.class);
    protected final String namespace = ((RedisAdmin)Framework.getService(RedisAdmin.class)).namespace("cache", this.name);

    public RedisCache(CacheDescriptor desc) {
        super(desc);
    }

    protected String formatKey(String key) {
        return this.namespace.concat(key);
    }

    protected Serializable deserializeValue(byte[] workBytes) throws IOException {
        if (workBytes == null) {
            return null;
        }
        ByteArrayInputStream bain = new ByteArrayInputStream(workBytes);
        ObjectInputStream in = new ObjectInputStream(bain);
        try {
            return (Serializable)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected static byte[] bytes(String string) {
        try {
            return string.getBytes(UTF_8);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public Serializable get(final String key) {
        return this.executor.execute(new RedisCallable<Serializable>(){

            @Override
            public Serializable call(Jedis jedis) {
                try {
                    return RedisCache.this.deserializeValue(jedis.get(RedisCache.bytes(RedisCache.this.formatKey(key))));
                }
                catch (IOException e) {
                    log.error((Object)e);
                    return null;
                }
            }
        });
    }

    public Set<String> keySet() {
        return this.executor.execute(new RedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) {
                int offset = RedisCache.this.namespace.length();
                return jedis.keys(RedisCache.this.formatKey("*")).stream().map(key -> key.substring(offset)).collect(Collectors.toSet());
            }
        });
    }

    protected byte[] serializeValue(Serializable value) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baout);
        out.writeObject(value);
        out.flush();
        out.close();
        return baout.toByteArray();
    }

    public void invalidate(final String key) {
        this.executor.execute(new RedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                jedis.del(new String[]{RedisCache.this.formatKey(key)});
                return null;
            }
        });
    }

    public void invalidateAll() {
        ((RedisAdmin)Framework.getService(RedisAdmin.class)).clear(this.formatKey("*"));
    }

    public void put(final String key, final Serializable value) {
        this.executor.execute(new RedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                try {
                    byte[] bkey = RedisCache.bytes(RedisCache.this.formatKey(key));
                    jedis.set(bkey, RedisCache.this.serializeValue(value));
                    int ttlKey = RedisCache.this.ttl * 60;
                    jedis.expire(bkey, ttlKey);
                    return null;
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
        });
    }

    public boolean hasEntry(final String key) {
        return (Boolean)this.executor.execute(new RedisCallable<Serializable>(){

            @Override
            public Serializable call(Jedis jedis) {
                return jedis.exists(RedisCache.bytes(RedisCache.this.formatKey(key)));
            }
        });
    }
}

