/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.platform.convert.ooomanager.OOoManagerService;
import org.nuxeo.ecm.platform.convert.plugins.UTF8CharsetConverter;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class JODBasedConverter
implements ExternalConverter {
    protected static final String TMP_PATH_PARAMETER = "TmpDirectory";
    private static final Log log = LogFactory.getLog(JODBasedConverter.class);
    public static final String PDFA1_PARAM = "PDF/A-1";
    public static final String UPDATE_INDEX_PARAM = "updateDocumentIndex";
    protected static final Map<DocumentFamily, String> PDF_FILTER_NAMES = new HashMap<DocumentFamily, String>();
    protected ConverterDescriptor descriptor;

    public JODBasedConverter() {
        PDF_FILTER_NAMES.put(DocumentFamily.TEXT, "writer_pdf_Export");
        PDF_FILTER_NAMES.put(DocumentFamily.SPREADSHEET, "calc_pdf_Export");
        PDF_FILTER_NAMES.put(DocumentFamily.PRESENTATION, "impress_pdf_Export");
        PDF_FILTER_NAMES.put(DocumentFamily.DRAWING, "draw_pdf_Export");
    }

    protected String getDestinationMimeType() {
        return this.descriptor.getDestinationMimeType();
    }

    protected DocumentFormat getDestinationFormat(OfficeDocumentConverter documentConverter, DocumentFormat sourceFormat, boolean pdfa1) {
        String mimeType = this.getDestinationMimeType();
        DocumentFormat destinationFormat = documentConverter.getFormatRegistry().getFormatByMediaType(mimeType);
        if ("application/pdf".equals(mimeType)) {
            destinationFormat = this.extendPDFFormat(sourceFormat, destinationFormat, pdfa1);
        }
        return destinationFormat;
    }

    protected DocumentFormat extendPDFFormat(DocumentFormat sourceFormat, DocumentFormat defaultFormat, boolean pdfa1) {
        DocumentFamily sourceFamily = sourceFormat.getInputFamily();
        String sourceMediaType = sourceFormat.getMediaType();
        DocumentFormat pdfFormat = new DocumentFormat(pdfa1 ? PDFA1_PARAM : "PDF", "pdf", "application/pdf");
        HashMap storePropertiesByFamily = new HashMap();
        Map defaultStorePropertiesByFamily = defaultFormat.getStorePropertiesByFamily();
        for (DocumentFamily family : defaultStorePropertiesByFamily.keySet()) {
            if (family.equals((Object)sourceFamily)) continue;
            storePropertiesByFamily.put(family, defaultStorePropertiesByFamily.get(family));
        }
        storePropertiesByFamily.put(sourceFamily, this.extendPDFStoreProperties(sourceMediaType, pdfa1, (Map)defaultStorePropertiesByFamily.get(sourceFamily)));
        pdfFormat.setStorePropertiesByFamily(storePropertiesByFamily);
        return pdfFormat;
    }

    protected Map<String, Object> extendPDFStoreProperties(String mediatype, boolean pdfa1, Map<String, ?> originalProperties) {
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : originalProperties.entrySet()) {
            extendedProperties.put(entry.getKey(), entry.getValue());
        }
        if ("text/html".equals(mediatype)) {
            extendedProperties.put("FilterName", "writer_web_pdf_Export");
        }
        if (pdfa1) {
            HashMap<String, Constable> filterData = new HashMap<String, Constable>();
            filterData.put("SelectPdfVersion", Integer.valueOf(1));
            filterData.put("UseTaggedPDF", Boolean.TRUE);
            extendedProperties.put("FilterData", filterData);
        }
        return extendedProperties;
    }

    private static DocumentFormat getSourceFormat(OfficeDocumentConverter documentConverter, File file) {
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetypeStr = mimetypeRegistry.getMimetypeFromFile(file);
        DocumentFormat format = documentConverter.getFormatRegistry().getFormatByMediaType(mimetypeStr);
        return format;
    }

    private static DocumentFormat getSourceFormat(OfficeDocumentConverter documentConverter, String mimetype) {
        return documentConverter.getFormatRegistry().getFormatByMediaType(mimetype);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        blobHolder = new UTF8CharsetConverter().convert(blobHolder, parameters);
        Blob inputBlob = blobHolder.getBlob();
        String blobPath = blobHolder.getFilePath();
        if (inputBlob == null) {
            return null;
        }
        OfficeDocumentConverter documentConverter = this.newDocumentConverter();
        String sourceMimetype = inputBlob.getMimeType();
        boolean pdfa1 = parameters != null && Boolean.TRUE.equals(parameters.get(PDFA1_PARAM));
        File sourceFile = null;
        File outFile = null;
        File[] files = null;
        try {
            String ext;
            int dotPosition;
            if ("text/html".equals(sourceMimetype)) {
                inputBlob = this.checkCharsetMeta(inputBlob);
            }
            ext = (dotPosition = (ext = inputBlob.getFilename()).lastIndexOf(46)) == -1 ? ".bin" : ext.substring(dotPosition);
            sourceFile = Framework.createTempFile((String)"NXJOOoConverterDocumentIn", (String)ext);
            InputStream stream = inputBlob.getStream();
            FileUtils.copyToFile((InputStream)stream, (File)sourceFile);
            stream.close();
            DocumentFormat sourceFormat = null;
            if (sourceMimetype != null) {
                sourceFormat = JODBasedConverter.getSourceFormat(documentConverter, sourceMimetype);
            }
            if (sourceFormat == null) {
                sourceFormat = JODBasedConverter.getSourceFormat(documentConverter, sourceFile);
            }
            DocumentFormat destinationFormat = this.getDestinationFormat(documentConverter, sourceFormat, pdfa1);
            ArrayList<Blob> blobs = new ArrayList<Blob>();
            if (this.descriptor.getDestinationMimeType().equals("text/html")) {
                String tmpDirPath = this.getTmpDirectory();
                File myTmpDir = new File(tmpDirPath + "/JODConv_" + System.currentTimeMillis());
                boolean created = myTmpDir.mkdir();
                if (!created) {
                    throw new IOException("Unable to create temp dir");
                }
                outFile = new File(myTmpDir.getAbsolutePath() + "/" + "NXJOOoConverterDocumentOut." + destinationFormat.getExtension());
                created = outFile.createNewFile();
                if (!created) {
                    throw new IOException("Unable to create temp file");
                }
                log.debug((Object)("Input File = " + outFile.getAbsolutePath()));
                documentConverter.convert(sourceFile, outFile, destinationFormat);
                for (File file : files = myTmpDir.listFiles()) {
                    Blob indexBlob;
                    Blob blob;
                    try (FileInputStream in = new FileInputStream(file);){
                        blob = Blobs.createBlob((InputStream)in);
                    }
                    blob.setFilename(file.getName());
                    blobs.add(blob);
                    if (!file.getName().equals(outFile.getName())) continue;
                    try (FileInputStream in = new FileInputStream(file);){
                        indexBlob = Blobs.createBlob((InputStream)in);
                    }
                    indexBlob.setFilename("index.html");
                    blobs.add(0, indexBlob);
                }
            } else {
                Blob blob;
                outFile = Framework.createTempFile((String)"NXJOOoConverterDocumentOut", (String)('.' + destinationFormat.getExtension()));
                documentConverter.convert(sourceFile, outFile, destinationFormat, parameters);
                try (FileInputStream in = new FileInputStream(outFile);){
                    blob = Blobs.createBlob((InputStream)in, (String)this.getDestinationMimeType());
                }
                blobs.add(blob);
            }
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder(blobs);
            return simpleCachableBlobHolder;
        }
        catch (IOException e) {
            String msg = String.format("An error occurred trying to convert file %s to from %s to %s", blobPath, sourceMimetype, this.getDestinationMimeType());
            throw new ConversionException(msg, (Throwable)e);
        }
        finally {
            if (sourceFile != null) {
                sourceFile.delete();
            }
            if (outFile != null) {
                outFile.delete();
            }
            if (files != null) {
                for (void var38_49 : files) {
                    if (!var38_49.exists()) continue;
                    var38_49.delete();
                }
            }
        }
    }

    protected OfficeDocumentConverter newDocumentConverter() throws ConversionException {
        OOoManagerService oooManagerService = (OOoManagerService)Framework.getService(OOoManagerService.class);
        OfficeDocumentConverter documentConverter = oooManagerService.getDocumentConverter();
        if (documentConverter == null) {
            throw new ConversionException("Could not connect to the remote OpenOffice server");
        }
        return documentConverter;
    }

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ConverterCheckResult isConverterAvailable() {
        ConverterCheckResult result = new ConverterCheckResult();
        OOoManagerService oooManagerService = (OOoManagerService)Framework.getService(OOoManagerService.class);
        if (!oooManagerService.isOOoManagerStarted()) {
            result.setAvailable(false);
        }
        return result;
    }

    protected String getTmpDirectory() {
        String tmp = null;
        Map parameters = this.descriptor.getParameters();
        if (parameters != null && parameters.containsKey(TMP_PATH_PARAMETER)) {
            tmp = (String)parameters.get(TMP_PATH_PARAMETER);
        }
        if (tmp == null) {
            tmp = Environment.getDefault().getTemp().getPath();
        }
        return tmp;
    }

    protected Blob checkCharsetMeta(Blob inputBlob) throws IOException {
        Pattern charsetMetaPattern;
        Matcher charsetMetaMatcher;
        String charset = inputBlob.getEncoding();
        if (!StringUtils.isEmpty((String)charset) && !(charsetMetaMatcher = (charsetMetaPattern = Pattern.compile(String.format("content=\"text/html;\\s*charset=%s\"", charset))).matcher(inputBlob.getString())).find()) {
            String charsetMetaTag = String.format("<META http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">", charset);
            StringBuilder sb = new StringBuilder(charsetMetaTag);
            sb.append(new String(inputBlob.getByteArray(), charset));
            Blob blobWithCharsetMetaTag = Blobs.createBlob((String)sb.toString(), (String)"text/html", (String)charset, (String)inputBlob.getFilename());
            return blobWithCharsetMetaTag;
        }
        return inputBlob;
    }
}

